/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.FirDesignation;
import org.jetbrains.kotlin.analysis.low.level.api.fir.util.ExceptionUtilsKt;
import org.jetbrains.kotlin.fir.FirElementWithResolveState;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\r\u0010\f\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010\u000bR\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0011\u001a\u00020\u00108\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0016\u001a\u0004\u0018\u00010\u00138G\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0018\u001a\u00020\u00138G\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/FirDesignationState;", "", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/api/FirDesignation;", "designation", "<init>", "(Lorg/jetbrains/kotlin/analysis/low/level/api/fir/api/FirDesignation;)V", "", "canGoNext", "()Z", "", "goNext", "()V", "goToInnerDeclaration", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/api/FirDesignation;", "getDesignation", "()Lorg/jetbrains/kotlin/analysis/low/level/api/fir/api/FirDesignation;", "", "currentIndex", "I", "Lorg/jetbrains/kotlin/fir/FirElementWithResolveState;", "getCurrentDeclarationIfPresent", "()Lorg/jetbrains/kotlin/fir/FirElementWithResolveState;", "currentDeclarationIfPresent", "getCurrentDeclaration", "currentDeclaration"})
final class FirDesignationState {
    @NotNull
    private final FirDesignation designation;
    private int currentIndex;

    public FirDesignationState(@NotNull FirDesignation designation) {
        Intrinsics.checkNotNullParameter(designation, "designation");
        this.designation = designation;
        this.currentIndex = -1;
    }

    @NotNull
    public final FirDesignation getDesignation() {
        return this.designation;
    }

    public final boolean canGoNext() {
        return this.currentIndex < this.designation.getPath().size();
    }

    @Nullable
    public final FirElementWithResolveState getCurrentDeclarationIfPresent() {
        FirDeclaration firDeclaration = CollectionsKt.getOrNull(this.designation.getPath(), this.currentIndex);
        return firDeclaration != null ? (FirElementWithResolveState)firDeclaration : (this.currentIndex == this.designation.getPath().size() ? this.designation.getTarget() : null);
    }

    @NotNull
    public final FirElementWithResolveState getCurrentDeclaration() {
        FirElementWithResolveState firElementWithResolveState = this.getCurrentDeclarationIfPresent();
        if (firElementWithResolveState == null) {
            ExceptionUtilsKt.errorWithFirSpecificEntries$default("Went inside target declaration", null, null, null, null, null, 62, null);
            throw new KotlinNothingValueException();
        }
        return firElementWithResolveState;
    }

    public final void goNext() {
        if (!this.canGoNext()) {
            throw new IndexOutOfBoundsException();
        }
        int n = this.currentIndex;
        this.currentIndex = n + 1;
    }

    public final void goToInnerDeclaration() {
        if (this.currentIndex != this.designation.getPath().size()) {
            throw new IndexOutOfBoundsException();
        }
        int n = this.currentIndex;
        this.currentIndex = n + 1;
    }
}

