/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.caches;

import com.intellij.openapi.progress.ProgressManager;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u0002*\u0004\b\u0002\u0010\u00032\u00020\u0004:\u0002 !BO\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u0012\u001e\u0010\b\u001a\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00070\u0006\u0012\u001e\u0010\u000b\u001a\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\f\u0010\rJ$\u0010\u0011\u001a\u00028\u0003\"\u0004\b\u0003\u0010\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00030\u000fH\u0082\b\u00a2\u0006\u0004\b\u0011\u0010\u0012J\r\u0010\u0013\u001a\u00028\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0015\u001a\u00028\u0001H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0014J\u0011\u0010\u0016\u001a\u0004\u0018\u00018\u0001H\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0014R\u0014\u0010\u0005\u001a\u00028\u00008\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0017R0\u0010\u0018\u001a\u001c\u0012\u0004\u0012\u00028\u0000\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0007\u0018\u00010\u00068\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R0\u0010\u001a\u001a\u001c\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00020\n\u0018\u00010\t8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u0018\u0010\u001d\u001a\u0004\u0018\u00010\u001c8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR\u0018\u0010\u001f\u001a\u0004\u0018\u00010\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u001f\u0010\u0017"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/caches/ValueWithPostCompute;", "KEY", "VALUE", "DATA", "", "key", "Lkotlin/Function1;", "Lkotlin/Pair;", "calculate", "Lkotlin/Function3;", "", "postCompute", "<init>", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function3;)V", "T", "Lkotlin/Function0;", "body", "recursiveGuarded", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "getValue", "()Ljava/lang/Object;", "computeValueWithoutLock", "getValueIfComputed", "Ljava/lang/Object;", "_calculate", "Lkotlin/jvm/functions/Function1;", "_postCompute", "Lkotlin/jvm/functions/Function3;", "Ljava/util/concurrent/locks/ReentrantLock;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "value", "ValueIsPostComputingNow", "ValueIsNotComputed"})
public final class ValueWithPostCompute<KEY, VALUE, DATA> {
    private final KEY key;
    @Nullable
    private Function1<? super KEY, ? extends Pair<? extends VALUE, ? extends DATA>> _calculate;
    @Nullable
    private Function3<? super KEY, ? super VALUE, ? super DATA, Unit> _postCompute;
    @Nullable
    private volatile ReentrantLock lock;
    @Nullable
    private volatile Object value;

    public ValueWithPostCompute(KEY key, @NotNull Function1<? super KEY, ? extends Pair<? extends VALUE, ? extends DATA>> calculate, @NotNull Function3<? super KEY, ? super VALUE, ? super DATA, Unit> postCompute) {
        Intrinsics.checkNotNullParameter(calculate, "calculate");
        Intrinsics.checkNotNullParameter(postCompute, "postCompute");
        this.key = key;
        this._calculate = calculate;
        this._postCompute = postCompute;
        this.lock = new ReentrantLock();
        this.value = ValueIsNotComputed.INSTANCE;
    }

    private final <T> T recursiveGuarded(Function0<? extends T> body2) {
        boolean $i$f$recursiveGuarded = false;
        ReentrantLock reentrantLock = this.lock;
        Intrinsics.checkNotNull(reentrantLock);
        if (!(reentrantLock.getHoldCount() == 1)) {
            boolean bl = false;
            String string2 = "Should not be called recursively";
            throw new IllegalStateException(string2.toString());
        }
        return body2.invoke();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final VALUE getValue() {
        Object stateSnapshot = this.value;
        if (stateSnapshot instanceof ValueIsPostComputingNow) {
            if (((ValueIsPostComputingNow)stateSnapshot).getThreadId() == Thread.currentThread().getId()) {
                return (VALUE)((ValueIsPostComputingNow)stateSnapshot).getValue();
            }
            ReentrantLock reentrantLock = this.lock;
            if (reentrantLock != null) {
                boolean $i$f$checkCanceled;
                void $this$lockWithPCECheck$iv;
                Lock lock = reentrantLock;
                long lockingIntervalMs$iv = 50L;
                boolean $i$f$lockWithPCECheck = false;
                do {
                    $i$f$checkCanceled = false;
                    ProgressManager.checkCanceled();
                } while (!$this$lockWithPCECheck$iv.tryLock(lockingIntervalMs$iv, TimeUnit.MILLISECONDS));
                try {
                    $i$f$checkCanceled = false;
                    ProgressManager.checkCanceled();
                    boolean bl = false;
                    if (Intrinsics.areEqual(this.value, ValueIsNotComputed.INSTANCE)) {
                        VALUE VALUE = this.computeValueWithoutLock();
                        return VALUE;
                    }
                    Object object = this.value;
                    return (VALUE)object;
                }
                finally {
                    $this$lockWithPCECheck$iv.unlock();
                }
            }
            return (VALUE)this.value;
        }
        if (Intrinsics.areEqual(stateSnapshot, ValueIsNotComputed.INSTANCE)) {
            ReentrantLock reentrantLock = this.lock;
            if (reentrantLock != null) {
                boolean $i$f$checkCanceled;
                Lock $this$lockWithPCECheck$iv = reentrantLock;
                long lockingIntervalMs$iv = 50L;
                boolean $i$f$lockWithPCECheck = false;
                do {
                    $i$f$checkCanceled = false;
                    ProgressManager.checkCanceled();
                } while (!$this$lockWithPCECheck$iv.tryLock(lockingIntervalMs$iv, TimeUnit.MILLISECONDS));
                try {
                    $i$f$checkCanceled = false;
                    ProgressManager.checkCanceled();
                    boolean bl = false;
                    VALUE VALUE = this.computeValueWithoutLock();
                    return VALUE;
                }
                finally {
                    $this$lockWithPCECheck$iv.unlock();
                }
            }
            return (VALUE)this.value;
        }
        return (VALUE)stateSnapshot;
    }

    private final VALUE computeValueWithoutLock() {
        Pair<Object, Object> calculatedValue;
        Pair<Object, Object> pair;
        if (Intrinsics.areEqual(this.value, ValueIsNotComputed.INSTANCE)) {
            ReentrantLock reentrantLock = this.lock;
            Intrinsics.checkNotNull(reentrantLock);
            if (!reentrantLock.isHeldByCurrentThread()) {
                String string2 = "Failed requirement.";
                throw new IllegalArgumentException(string2.toString());
            }
        } else {
            if (!(this.lock == null)) {
                String string3 = "Failed requirement.";
                throw new IllegalArgumentException(string3.toString());
            }
            return (VALUE)this.value;
        }
        try {
            ValueWithPostCompute this_$iv = this;
            boolean $i$f$recursiveGuarded = false;
            ReentrantLock reentrantLock = this_$iv.lock;
            Intrinsics.checkNotNull(reentrantLock);
            if (!(reentrantLock.getHoldCount() == 1)) {
                boolean bl = false;
                String string4 = "Should not be called recursively";
                throw new IllegalStateException(string4.toString());
            }
            boolean bl = false;
            Function1<KEY, Pair<VALUE, DATA>> function1 = this._calculate;
            Intrinsics.checkNotNull(function1);
            pair = function1.invoke(this.key);
            VALUE calculated = pair.component1();
            DATA data2 = pair.component2();
            this.value = new ValueIsPostComputingNow(calculated, Thread.currentThread().getId());
            Function3<KEY, VALUE, DATA, Unit> function3 = this._postCompute;
            Intrinsics.checkNotNull(function3);
            function3.invoke(this.key, calculated, data2);
            pair = calculated;
        }
        catch (Throwable e) {
            this.value = ValueIsNotComputed.INSTANCE;
            throw e;
        }
        this.value = calculatedValue = pair;
        this._calculate = null;
        this._postCompute = null;
        this.lock = null;
        return (VALUE)calculatedValue;
    }

    @Nullable
    public final VALUE getValueIfComputed() {
        Object object = this.value;
        return (VALUE)(Intrinsics.areEqual(object, ValueIsNotComputed.INSTANCE) ? null : (object instanceof ValueIsPostComputingNow ? null : this.value));
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/caches/ValueWithPostCompute$ValueIsNotComputed;", "", "<init>", "()V"})
    private static final class ValueIsNotComputed {
        @NotNull
        public static final ValueIsNotComputed INSTANCE = new ValueIsNotComputed();

        private ValueIsNotComputed() {
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u00018\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0002\u0010\u0007\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010\n\u001a\u0004\b\u000b\u0010\f"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/caches/ValueWithPostCompute$ValueIsPostComputingNow;", "", "value", "", "threadId", "<init>", "(Ljava/lang/Object;J)V", "Ljava/lang/Object;", "getValue", "()Ljava/lang/Object;", "J", "getThreadId", "()J"})
    private static final class ValueIsPostComputingNow {
        @Nullable
        private final Object value;
        private final long threadId;

        public ValueIsPostComputingNow(@Nullable Object value2, long threadId) {
            this.value = value2;
            this.threadId = threadId;
        }

        @Nullable
        public final Object getValue() {
            return this.value;
        }

        public final long getThreadId() {
            return this.threadId;
        }
    }
}

