/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.caches.cleanable;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.low.level.api.fir.caches.cleanable.ReferenceWithCleanup;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\b&\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u0001*\b\b\u0001\u0010\u0003*\u00020\u00012\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J+\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b2\u0006\u0010\u0006\u001a\u00028\u00002\u0006\u0010\u0007\u001a\u00028\u0001H!\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\r\u0010\u0005J\u001a\u0010\u000e\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0006\u001a\u00028\u0000H\u0087\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ+\u0010\u0012\u001a\u00028\u00012\u0006\u0010\u0006\u001a\u00028\u00002\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0010H\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0013J7\u0010\u0015\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0006\u001a\u00028\u00002\u001c\u0010\u0011\u001a\u0018\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u0001\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u0014H\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0016J!\u0010\u0017\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0006\u001a\u00028\u00002\u0006\u0010\u0007\u001a\u00028\u0001H\u0007\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0019\u0010\u0019\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0006\u001a\u00028\u0000H\u0007\u00a2\u0006\u0004\b\u0019\u0010\u000fJ\r\u0010\u001a\u001a\u00020\f\u00a2\u0006\u0004\b\u001a\u0010\u0005J\r\u0010\u001c\u001a\u00020\u001b\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u000f\u0010\u001f\u001a\u00020\u001eH\u0017\u00a2\u0006\u0004\b\u001f\u0010 J\u001f\u0010!\u001a\u00020\f*\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\bH\u0002\u00a2\u0006\u0004\b!\u0010\"R,\u0010$\u001a\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b0#8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b$\u0010%R \u0010'\u001a\b\u0012\u0004\u0012\u00028\u00010&8\u0005X\u0085\u0004\u00a2\u0006\f\n\u0004\b'\u0010(\u001a\u0004\b)\u0010*R\u0011\u0010.\u001a\u00020+8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u0017\u00102\u001a\b\u0012\u0004\u0012\u00028\u00000/8G\u00a2\u0006\u0006\u001a\u0004\b0\u00101"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/caches/cleanable/CleanableValueReferenceCache;", "", "K", "V", "<init>", "()V", "key", "value", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/caches/cleanable/ReferenceWithCleanup;", "createReference$low_level_api_fir", "(Ljava/lang/Object;Ljava/lang/Object;)Lorg/jetbrains/kotlin/analysis/low/level/api/fir/caches/cleanable/ReferenceWithCleanup;", "createReference", "", "processQueue", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", "Lkotlin/Function1;", "computeValue", "computeIfAbsent", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "Lkotlin/Function2;", "compute", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "remove", "clear", "", "isEmpty", "()Z", "", "toString", "()Ljava/lang/String;", "performCleanup", "(Lorg/jetbrains/kotlin/analysis/low/level/api/fir/caches/cleanable/ReferenceWithCleanup;)V", "Ljava/util/concurrent/ConcurrentHashMap;", "backingMap", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/lang/ref/ReferenceQueue;", "referenceQueue", "Ljava/lang/ref/ReferenceQueue;", "getReferenceQueue", "()Ljava/lang/ref/ReferenceQueue;", "", "getSize", "()I", "size", "", "getKeys", "()Ljava/util/Set;", "keys"})
public abstract class CleanableValueReferenceCache<K, V> {
    @NotNull
    private final ConcurrentHashMap<K, ReferenceWithCleanup<K, V>> backingMap = new ConcurrentHashMap();
    @NotNull
    private final ReferenceQueue<V> referenceQueue = new ReferenceQueue();

    @NotNull
    protected final ReferenceQueue<V> getReferenceQueue() {
        return this.referenceQueue;
    }

    @NotNull
    public abstract ReferenceWithCleanup<K, V> createReference$low_level_api_fir(@NotNull K var1, @NotNull V var2);

    private final void processQueue() {
        while (this.referenceQueue.poll() != null) {
            Reference<V> ref;
            if (!(ref instanceof ReferenceWithCleanup)) {
                throw new IllegalStateException("Check failed.");
            }
            ReferenceWithCleanup cfr_ignored_0 = (ReferenceWithCleanup)((Object)ref);
            boolean wasRemoved = this.backingMap.remove(((ReferenceWithCleanup)((Object)ref)).getKey(), ref);
            if (!wasRemoved) continue;
            this.performCleanup((ReferenceWithCleanup)((Object)ref));
        }
    }

    @Nullable
    public final V get(@NotNull K key) {
        Intrinsics.checkNotNullParameter(key, "key");
        ReferenceWithCleanup<K, V> referenceWithCleanup = this.backingMap.get(key);
        return (V)(referenceWithCleanup != null ? referenceWithCleanup.get() : null);
    }

    @NotNull
    public final V computeIfAbsent(@NotNull K key, @NotNull Function1<? super K, ? extends V> computeValue) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(computeValue, "computeValue");
        V v = this.get(key);
        if (v != null) {
            V it = v;
            boolean bl = false;
            return it;
        }
        Object object = this.compute(key, (arg_0, arg_1) -> CleanableValueReferenceCache.computeIfAbsent$lambda$1(computeValue, key, arg_0, arg_1));
        if (object == null) {
            throw new IllegalStateException("`computeIfAbsent` should always return a non-null value.".toString());
        }
        return (V)object;
    }

    @Nullable
    public final V compute(@NotNull K key, @NotNull Function2<? super K, ? super V, ? extends V> computeValue) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(computeValue, "computeValue");
        Ref.ObjectRef newValue = new Ref.ObjectRef();
        Ref.ObjectRef removedRef = new Ref.ObjectRef();
        ReferenceWithCleanup newRef = this.backingMap.compute(key, (arg_0, arg_1) -> CleanableValueReferenceCache.compute$lambda$3((arg_0, arg_1) -> CleanableValueReferenceCache.compute$lambda$2(newValue, computeValue, key, removedRef, this, arg_0, arg_1), arg_0, arg_1));
        ReferenceWithCleanup referenceWithCleanup = (ReferenceWithCleanup)removedRef.element;
        if (referenceWithCleanup != null) {
            this.performCleanup(referenceWithCleanup);
        }
        this.processQueue();
        ReferenceWithCleanup referenceWithCleanup2 = newRef;
        if (!((referenceWithCleanup2 != null ? referenceWithCleanup2.get() : null) == newValue.element)) {
            boolean bl = false;
            String string2 = "The newly computed value was already garbage-collected before the end of the `compute` function.";
            throw new IllegalArgumentException(string2.toString());
        }
        return (V)newValue.element;
    }

    @Nullable
    public final V put(@NotNull K key, @NotNull V value2) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(value2, "value");
        Ref.ObjectRef oldValue = new Ref.ObjectRef();
        Ref.ObjectRef removedRef = new Ref.ObjectRef();
        this.backingMap.compute(key, (arg_0, arg_1) -> CleanableValueReferenceCache.put$lambda$6((arg_0, arg_1) -> CleanableValueReferenceCache.put$lambda$5(oldValue, value2, removedRef, this, key, arg_0, arg_1), arg_0, arg_1));
        ReferenceWithCleanup referenceWithCleanup = (ReferenceWithCleanup)removedRef.element;
        if (referenceWithCleanup != null) {
            this.performCleanup(referenceWithCleanup);
        }
        this.processQueue();
        return (V)oldValue.element;
    }

    @Nullable
    public final V remove(@NotNull K key) {
        ReferenceWithCleanup<K, V> ref;
        Intrinsics.checkNotNullParameter(key, "key");
        ReferenceWithCleanup<K, V> referenceWithCleanup = ref = this.backingMap.remove(key);
        if (referenceWithCleanup != null) {
            this.performCleanup(referenceWithCleanup);
        }
        this.processQueue();
        ReferenceWithCleanup<K, V> referenceWithCleanup2 = ref;
        return (V)(referenceWithCleanup2 != null ? referenceWithCleanup2.get() : null);
    }

    public final void clear() {
        Collection<ReferenceWithCleanup<K, V>> collection = this.backingMap.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ReferenceWithCleanup it = (ReferenceWithCleanup)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            this.performCleanup(it);
        }
        this.backingMap.clear();
        this.processQueue();
    }

    public final int getSize() {
        this.processQueue();
        return this.backingMap.size();
    }

    public final boolean isEmpty() {
        this.processQueue();
        return this.backingMap.isEmpty();
    }

    @NotNull
    public final Set<K> getKeys() {
        this.processQueue();
        Set set = this.backingMap.keySet();
        Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
        return CollectionsKt.toSet(set);
    }

    @NotNull
    public String toString() {
        return Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName() + " size:" + this.getSize();
    }

    private final void performCleanup(ReferenceWithCleanup<K, V> $this$performCleanup) {
        $this$performCleanup.getCleaner().cleanUp($this$performCleanup.get());
    }

    private static final Object computeIfAbsent$lambda$1(Function1 $computeValue, Object $key, Object object, Object currentValue) {
        Intrinsics.checkNotNullParameter(object, "<unused var>");
        Object object2 = currentValue;
        if (object2 == null) {
            object2 = $computeValue.invoke($key);
        }
        return object2;
    }

    private static final ReferenceWithCleanup compute$lambda$2(Ref.ObjectRef $newValue, Function2 $computeValue, Object $key, Ref.ObjectRef $removedRef, CleanableValueReferenceCache this$0, Object object, ReferenceWithCleanup currentRef) {
        ReferenceWithCleanup referenceWithCleanup;
        Intrinsics.checkNotNullParameter(object, "<unused var>");
        ReferenceWithCleanup referenceWithCleanup2 = currentRef;
        Object currentValue = referenceWithCleanup2 != null ? referenceWithCleanup2.get() : null;
        $newValue.element = $computeValue.invoke($key, currentValue);
        if ($newValue.element == null) {
            $removedRef.element = currentRef;
            referenceWithCleanup = null;
        } else if ($newValue.element == currentValue) {
            referenceWithCleanup = currentRef;
        } else {
            $removedRef.element = currentRef;
            Object t = $newValue.element;
            Intrinsics.checkNotNull(t);
            referenceWithCleanup = this$0.createReference$low_level_api_fir($key, t);
        }
        return referenceWithCleanup;
    }

    private static final ReferenceWithCleanup compute$lambda$3(Function2 $tmp0, Object p0, Object p1) {
        return (ReferenceWithCleanup)$tmp0.invoke(p0, p1);
    }

    private static final ReferenceWithCleanup put$lambda$5(Ref.ObjectRef $oldValue, Object $value, Ref.ObjectRef $removedRef, CleanableValueReferenceCache this$0, Object $key, Object object, ReferenceWithCleanup currentRef) {
        Intrinsics.checkNotNullParameter(object, "<unused var>");
        ReferenceWithCleanup referenceWithCleanup = currentRef;
        Object currentValue = referenceWithCleanup != null ? referenceWithCleanup.get() : null;
        $oldValue.element = currentValue;
        if ($value == currentValue) {
            return currentRef;
        }
        $removedRef.element = currentRef;
        return this$0.createReference$low_level_api_fir($key, $value);
    }

    private static final ReferenceWithCleanup put$lambda$6(Function2 $tmp0, Object p0, Object p1) {
        return (ReferenceWithCleanup)$tmp0.invoke(p0, p1);
    }
}

