/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.diagnostics;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.DiagnosticCheckerFilter;
import org.jetbrains.kotlin.analysis.low.level.api.fir.diagnostics.FileStructureElementDiagnostics;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.FileStructure;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.FileStructureCache;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.FileStructureElement;
import org.jetbrains.kotlin.diagnostics.KtPsiDiagnostic;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J%\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0007\u00a2\u0006\u0004\b\f\u0010\rJ%\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\bH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0012"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/diagnostics/DiagnosticsCollector;", "", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FileStructureCache;", "fileStructureCache", "<init>", "(Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FileStructureCache;)V", "Lorg/jetbrains/kotlin/psi/KtElement;", "element", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/api/DiagnosticCheckerFilter;", "filter", "", "Lorg/jetbrains/kotlin/diagnostics/KtPsiDiagnostic;", "getDiagnosticsFor", "(Lorg/jetbrains/kotlin/psi/KtElement;Lorg/jetbrains/kotlin/analysis/low/level/api/fir/api/DiagnosticCheckerFilter;)Ljava/util/List;", "Lorg/jetbrains/kotlin/psi/KtFile;", "ktFile", "collectDiagnosticsForFile", "(Lorg/jetbrains/kotlin/psi/KtFile;Lorg/jetbrains/kotlin/analysis/low/level/api/fir/api/DiagnosticCheckerFilter;)Ljava/util/List;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FileStructureCache;"})
public final class DiagnosticsCollector {
    @NotNull
    private final FileStructureCache fileStructureCache;

    public DiagnosticsCollector(@NotNull FileStructureCache fileStructureCache) {
        Intrinsics.checkNotNullParameter(fileStructureCache, "fileStructureCache");
        this.fileStructureCache = fileStructureCache;
    }

    @NotNull
    public final List<KtPsiDiagnostic> getDiagnosticsFor(@NotNull KtElement element, @NotNull DiagnosticCheckerFilter filter2) {
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(filter2, "filter");
        KtFile ktFile = element.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue(ktFile, "getContainingKtFile(...)");
        FileStructure fileStructure = this.fileStructureCache.getFileStructure(ktFile);
        FileStructureElement structureElement = FileStructure.getStructureElementFor$default(fileStructure, element, null, 2, null);
        FileStructureElementDiagnostics diagnostics = structureElement.getDiagnostics();
        return diagnostics.diagnosticsFor(filter2, element);
    }

    @NotNull
    public final List<KtPsiDiagnostic> collectDiagnosticsForFile(@NotNull KtFile ktFile, @NotNull DiagnosticCheckerFilter filter2) {
        Intrinsics.checkNotNullParameter(ktFile, "ktFile");
        Intrinsics.checkNotNullParameter(filter2, "filter");
        FileStructure fileStructure = this.fileStructureCache.getFileStructure(ktFile);
        return fileStructure.getAllDiagnosticsForFile(filter2);
    }
}

