/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.diagnostics;

import com.intellij.psi.PsiElement;
import com.intellij.util.SmartList;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.DiagnosticCheckerFilter;
import org.jetbrains.kotlin.analysis.low.level.api.fir.diagnostics.FileStructureElementDiagnosticList;
import org.jetbrains.kotlin.analysis.low.level.api.fir.diagnostics.FileStructureElementDiagnosticRetriever;
import org.jetbrains.kotlin.diagnostics.KtPsiDiagnostic;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J%\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0007\u00a2\u0006\u0004\b\f\u0010\rJ5\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u00062\u0018\u0010\u0010\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0004\u0012\u00020\u000f0\u000eH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0013R\u001b\u0010\u0019\u001a\u00020\u00148BX\u0083\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u001b\u0010\u001c\u001a\u00020\u00148BX\u0083\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u0016\u001a\u0004\b\u001b\u0010\u0018R\u001b\u0010\u001f\u001a\u00020\u00148BX\u0083\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u0016\u001a\u0004\b\u001e\u0010\u0018\u0082\u0002\u0007\n\u0005\b\u009920\u0001"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/diagnostics/FileStructureElementDiagnostics;", "", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/diagnostics/FileStructureElementDiagnosticRetriever;", "retriever", "<init>", "(Lorg/jetbrains/kotlin/analysis/low/level/api/fir/diagnostics/FileStructureElementDiagnosticRetriever;)V", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/api/DiagnosticCheckerFilter;", "filter", "Lcom/intellij/psi/PsiElement;", "element", "", "Lorg/jetbrains/kotlin/diagnostics/KtPsiDiagnostic;", "diagnosticsFor", "(Lorg/jetbrains/kotlin/analysis/low/level/api/fir/api/DiagnosticCheckerFilter;Lcom/intellij/psi/PsiElement;)Ljava/util/List;", "Lkotlin/Function1;", "", "action", "forEach", "(Lorg/jetbrains/kotlin/analysis/low/level/api/fir/api/DiagnosticCheckerFilter;Lkotlin/jvm/functions/Function1;)V", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/diagnostics/FileStructureElementDiagnosticRetriever;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/diagnostics/FileStructureElementDiagnosticList;", "diagnosticByDefaultCheckers$delegate", "Lkotlin/Lazy;", "getDiagnosticByDefaultCheckers", "()Lorg/jetbrains/kotlin/analysis/low/level/api/fir/diagnostics/FileStructureElementDiagnosticList;", "diagnosticByDefaultCheckers", "diagnosticByExtraCheckers$delegate", "getDiagnosticByExtraCheckers", "diagnosticByExtraCheckers", "diagnosticByExperimentalCheckers$delegate", "getDiagnosticByExperimentalCheckers", "diagnosticByExperimentalCheckers"})
public final class FileStructureElementDiagnostics {
    @NotNull
    private final FileStructureElementDiagnosticRetriever retriever;
    @NotNull
    private final Lazy diagnosticByDefaultCheckers$delegate;
    @NotNull
    private final Lazy diagnosticByExtraCheckers$delegate;
    @NotNull
    private final Lazy diagnosticByExperimentalCheckers$delegate;

    public FileStructureElementDiagnostics(@NotNull FileStructureElementDiagnosticRetriever retriever) {
        Intrinsics.checkNotNullParameter(retriever, "retriever");
        this.retriever = retriever;
        this.diagnosticByDefaultCheckers$delegate = LazyKt.lazy(() -> FileStructureElementDiagnostics.diagnosticByDefaultCheckers_delegate$lambda$0(this));
        this.diagnosticByExtraCheckers$delegate = LazyKt.lazy(() -> FileStructureElementDiagnostics.diagnosticByExtraCheckers_delegate$lambda$1(this));
        this.diagnosticByExperimentalCheckers$delegate = LazyKt.lazy(() -> FileStructureElementDiagnostics.diagnosticByExperimentalCheckers_delegate$lambda$2(this));
    }

    private final FileStructureElementDiagnosticList getDiagnosticByDefaultCheckers() {
        Lazy lazy = this.diagnosticByDefaultCheckers$delegate;
        return (FileStructureElementDiagnosticList)lazy.getValue();
    }

    private final FileStructureElementDiagnosticList getDiagnosticByExtraCheckers() {
        Lazy lazy = this.diagnosticByExtraCheckers$delegate;
        return (FileStructureElementDiagnosticList)lazy.getValue();
    }

    private final FileStructureElementDiagnosticList getDiagnosticByExperimentalCheckers() {
        Lazy lazy = this.diagnosticByExperimentalCheckers$delegate;
        return (FileStructureElementDiagnosticList)lazy.getValue();
    }

    @NotNull
    public final List<KtPsiDiagnostic> diagnosticsFor(@NotNull DiagnosticCheckerFilter filter2, @NotNull PsiElement element) {
        SmartList smartList;
        Intrinsics.checkNotNullParameter(filter2, "filter");
        Intrinsics.checkNotNullParameter(element, "element");
        SmartList $this$diagnosticsFor_u24lambda_u243 = smartList = new SmartList();
        boolean bl = false;
        if (filter2.getRunDefaultCheckers()) {
            $this$diagnosticsFor_u24lambda_u243.addAll(this.getDiagnosticByDefaultCheckers().diagnosticsFor(element));
        }
        if (filter2.getRunExtraCheckers()) {
            $this$diagnosticsFor_u24lambda_u243.addAll(this.getDiagnosticByExtraCheckers().diagnosticsFor(element));
        }
        if (filter2.getRunExperimentalCheckers()) {
            $this$diagnosticsFor_u24lambda_u243.addAll(this.getDiagnosticByExperimentalCheckers().diagnosticsFor(element));
        }
        return smartList;
    }

    public final void forEach(@NotNull DiagnosticCheckerFilter filter2, @NotNull Function1<? super List<? extends KtPsiDiagnostic>, Unit> action) {
        boolean $i$f$forEach;
        Iterable $this$forEach$iv$iv;
        boolean $i$f$forEach2;
        FileStructureElementDiagnosticList this_$iv;
        Intrinsics.checkNotNullParameter(filter2, "filter");
        Intrinsics.checkNotNullParameter(action, "action");
        boolean $i$f$forEach3 = false;
        if (filter2.getRunDefaultCheckers()) {
            this_$iv = this.getDiagnosticByDefaultCheckers();
            $i$f$forEach2 = false;
            $this$forEach$iv$iv = FileStructureElementDiagnosticList.access$getMap$p(this_$iv).values();
            $i$f$forEach = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                action.invoke((List<? extends KtPsiDiagnostic>)element$iv$iv);
            }
        }
        if (filter2.getRunExtraCheckers()) {
            this_$iv = this.getDiagnosticByExtraCheckers();
            $i$f$forEach2 = false;
            $this$forEach$iv$iv = FileStructureElementDiagnosticList.access$getMap$p(this_$iv).values();
            $i$f$forEach = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                action.invoke((List<? extends KtPsiDiagnostic>)element$iv$iv);
            }
        }
        if (filter2.getRunExperimentalCheckers()) {
            this_$iv = this.getDiagnosticByExperimentalCheckers();
            $i$f$forEach2 = false;
            $this$forEach$iv$iv = FileStructureElementDiagnosticList.access$getMap$p(this_$iv).values();
            $i$f$forEach = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                action.invoke((List<? extends KtPsiDiagnostic>)element$iv$iv);
            }
        }
    }

    private static final FileStructureElementDiagnosticList diagnosticByDefaultCheckers_delegate$lambda$0(FileStructureElementDiagnostics this$0) {
        return this$0.retriever.retrieve(DiagnosticCheckerFilter.Companion.getONLY_DEFAULT_CHECKERS());
    }

    private static final FileStructureElementDiagnosticList diagnosticByExtraCheckers_delegate$lambda$1(FileStructureElementDiagnostics this$0) {
        return this$0.retriever.retrieve(DiagnosticCheckerFilter.Companion.getONLY_EXTRA_CHECKERS());
    }

    private static final FileStructureElementDiagnosticList diagnosticByExperimentalCheckers_delegate$lambda$2(FileStructureElementDiagnostics this$0) {
        return this$0.retriever.retrieve(DiagnosticCheckerFilter.Companion.getONLY_EXPERIMENTAL_CHECKERS());
    }
}

