/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.analysis.low.level.api.fir.LLFirModuleResolveComponents;
import org.jetbrains.kotlin.analysis.low.level.api.fir.diagnostics.ClassDiagnosticRetriever;
import org.jetbrains.kotlin.analysis.low.level.api.fir.diagnostics.FileStructureElementDiagnosticRetrieverKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.diagnostics.FileStructureElementDiagnostics;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.DeclarationStructureElement;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.FileStructureElement;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.FirElementsRecorder;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousInitializer;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirErrorPrimaryConstructor;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.psi.KtElement;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001\nB\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\t"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/ClassDeclarationStructureElement;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FileStructureElement;", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "file", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "clazz", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/LLFirModuleResolveComponents;", "moduleComponents", "<init>", "(Lorg/jetbrains/kotlin/fir/declarations/FirFile;Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;Lorg/jetbrains/kotlin/analysis/low/level/api/fir/LLFirModuleResolveComponents;)V", "Recorder"})
public final class ClassDeclarationStructureElement
extends FileStructureElement {
    public ClassDeclarationStructureElement(@NotNull FirFile file2, @NotNull FirRegularClass clazz, @NotNull LLFirModuleResolveComponents moduleComponents) {
        Intrinsics.checkNotNullParameter(file2, "file");
        Intrinsics.checkNotNullParameter(clazz, "clazz");
        Intrinsics.checkNotNullParameter(moduleComponents, "moduleComponents");
        super(clazz, new FileStructureElementDiagnostics(new ClassDiagnosticRetriever(clazz, file2, moduleComponents)), null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J+\u0010\r\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u00062\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ+\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J+\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00132\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bH\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J+\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00172\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bH\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ+\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001b2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ+\u0010!\u001a\u00020\f2\u0006\u0010 \u001a\u00020\u001f2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bH\u0016\u00a2\u0006\u0004\b!\u0010\"J+\u0010$\u001a\u00020\f2\u0006\u0010#\u001a\u00020\u00022\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bH\u0016\u00a2\u0006\u0004\b$\u0010%J+\u0010(\u001a\u00020\f2\u0006\u0010'\u001a\u00020&2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bH\u0016\u00a2\u0006\u0004\b(\u0010)R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010*"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/ClassDeclarationStructureElement$Recorder;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FirElementsRecorder;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "firClass", "<init>", "(Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;)V", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "property", "", "Lorg/jetbrains/kotlin/psi/KtElement;", "Lorg/jetbrains/kotlin/fir/FirElement;", "data", "", "visitProperty", "(Lorg/jetbrains/kotlin/fir/declarations/FirProperty;Ljava/util/Map;)V", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "simpleFunction", "visitSimpleFunction", "(Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;Ljava/util/Map;)V", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "constructor", "visitConstructor", "(Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;Ljava/util/Map;)V", "Lorg/jetbrains/kotlin/fir/declarations/FirField;", "field", "visitField", "(Lorg/jetbrains/kotlin/fir/declarations/FirField;Ljava/util/Map;)V", "Lorg/jetbrains/kotlin/fir/declarations/FirErrorPrimaryConstructor;", "errorPrimaryConstructor", "visitErrorPrimaryConstructor", "(Lorg/jetbrains/kotlin/fir/declarations/FirErrorPrimaryConstructor;Ljava/util/Map;)V", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousInitializer;", "anonymousInitializer", "visitAnonymousInitializer", "(Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousInitializer;Ljava/util/Map;)V", "regularClass", "visitRegularClass", "(Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;Ljava/util/Map;)V", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "typeAlias", "visitTypeAlias", "(Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;Ljava/util/Map;)V", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;"})
    public static final class Recorder
    extends FirElementsRecorder {
        @NotNull
        private final FirRegularClass firClass;

        public Recorder(@NotNull FirRegularClass firClass) {
            Intrinsics.checkNotNullParameter(firClass, "firClass");
            this.firClass = firClass;
        }

        @Override
        public void visitProperty(@NotNull FirProperty property, @NotNull Map<KtElement, FirElement> data2) {
            Intrinsics.checkNotNullParameter(property, "property");
            Intrinsics.checkNotNullParameter(data2, "data");
        }

        @Override
        public void visitSimpleFunction(@NotNull FirSimpleFunction simpleFunction, @NotNull Map<KtElement, FirElement> data2) {
            Intrinsics.checkNotNullParameter(simpleFunction, "simpleFunction");
            Intrinsics.checkNotNullParameter(data2, "data");
        }

        @Override
        public void visitConstructor(@NotNull FirConstructor constructor, @NotNull Map<KtElement, FirElement> data2) {
            Intrinsics.checkNotNullParameter(constructor, "constructor");
            Intrinsics.checkNotNullParameter(data2, "data");
            if (FileStructureElementDiagnosticRetrieverKt.isImplicitConstructor(constructor)) {
                DeclarationStructureElement.Recorder.INSTANCE.visitConstructor(constructor, data2);
            }
        }

        @Override
        public void visitField(@NotNull FirField field, @NotNull Map<KtElement, FirElement> data2) {
            Intrinsics.checkNotNullParameter(field, "field");
            Intrinsics.checkNotNullParameter(data2, "data");
            KtSourceElement ktSourceElement = field.getSource();
            if (Intrinsics.areEqual(ktSourceElement != null ? ktSourceElement.getKind() : null, KtFakeSourceElementKind.ClassDelegationField.INSTANCE)) {
                DeclarationStructureElement.Recorder.INSTANCE.visitField(field, data2);
            }
        }

        @Override
        public void visitErrorPrimaryConstructor(@NotNull FirErrorPrimaryConstructor errorPrimaryConstructor, @NotNull Map<KtElement, FirElement> data2) {
            Intrinsics.checkNotNullParameter(errorPrimaryConstructor, "errorPrimaryConstructor");
            Intrinsics.checkNotNullParameter(data2, "data");
            this.visitConstructor((FirConstructor)errorPrimaryConstructor, data2);
        }

        @Override
        public void visitAnonymousInitializer(@NotNull FirAnonymousInitializer anonymousInitializer, @NotNull Map<KtElement, FirElement> data2) {
            Intrinsics.checkNotNullParameter(anonymousInitializer, "anonymousInitializer");
            Intrinsics.checkNotNullParameter(data2, "data");
        }

        @Override
        public void visitRegularClass(@NotNull FirRegularClass regularClass, @NotNull Map<KtElement, FirElement> data2) {
            Intrinsics.checkNotNullParameter(regularClass, "regularClass");
            Intrinsics.checkNotNullParameter(data2, "data");
            if (regularClass == this.firClass) {
                super.visitRegularClass(regularClass, data2);
            }
        }

        @Override
        public void visitTypeAlias(@NotNull FirTypeAlias typeAlias, @NotNull Map<KtElement, FirElement> data2) {
            Intrinsics.checkNotNullParameter(typeAlias, "typeAlias");
            Intrinsics.checkNotNullParameter(data2, "data");
        }
    }
}

