/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.analysis.low.level.api.fir.LLFirModuleResolveComponents;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.FirDesignation;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.FirDesignationKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.targets.LLFirClassSpecificMembersResolveTarget;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.targets.TargetUtilsKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.diagnostics.FileStructureElementDiagnosticRetrieverKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.ClassDeclarationStructureElement;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.DeclarationStructureElement;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.FileStructureElement;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.RootScriptStructureElement;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.declarations.FirDanglingModifierList;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirScript;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.impl.FirPrimaryConstructor;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FileElementFactory;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "firDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "firFile", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/LLFirModuleResolveComponents;", "moduleComponents", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FileStructureElement;", "createFileStructureElement", "(Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;Lorg/jetbrains/kotlin/fir/declarations/FirFile;Lorg/jetbrains/kotlin/analysis/low/level/api/fir/LLFirModuleResolveComponents;)Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FileStructureElement;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "firClass", "", "lazyResolveClassGeneratedMembers", "(Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;)V"})
public final class FileElementFactory {
    @NotNull
    public static final FileElementFactory INSTANCE = new FileElementFactory();

    private FileElementFactory() {
    }

    @NotNull
    public final FileStructureElement createFileStructureElement(@NotNull FirDeclaration firDeclaration, @NotNull FirFile firFile, @NotNull LLFirModuleResolveComponents moduleComponents) {
        FileStructureElement fileStructureElement;
        Intrinsics.checkNotNullParameter(firDeclaration, "firDeclaration");
        Intrinsics.checkNotNullParameter(firFile, "firFile");
        Intrinsics.checkNotNullParameter(moduleComponents, "moduleComponents");
        FirDeclaration firDeclaration2 = firDeclaration;
        if (firDeclaration2 instanceof FirRegularClass) {
            FirLazyDeclarationResolverKt.lazyResolveToPhase(firDeclaration, FirResolvePhase.BODY_RESOLVE.getPrevious());
            this.lazyResolveClassGeneratedMembers((FirRegularClass)firDeclaration);
            fileStructureElement = new ClassDeclarationStructureElement(firFile, (FirRegularClass)firDeclaration, moduleComponents);
        } else if (firDeclaration2 instanceof FirScript) {
            FirLazyDeclarationResolverKt.lazyResolveToPhase(firDeclaration, FirResolvePhase.BODY_RESOLVE.getPrevious());
            fileStructureElement = new RootScriptStructureElement(firFile, (FirScript)firDeclaration, moduleComponents);
        } else {
            FirLazyDeclarationResolverKt.lazyResolveToPhase(firDeclaration, FirResolvePhase.BODY_RESOLVE);
            if (firDeclaration instanceof FirPrimaryConstructor) {
                Iterable $this$forEach$iv = ((FirPrimaryConstructor)firDeclaration).getValueParameters();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    FirValueParameter parameter = (FirValueParameter)element$iv;
                    boolean bl = false;
                    FirProperty firProperty = ClassMembersKt.getCorrespondingProperty(parameter);
                    if (firProperty != null) {
                        FirLazyDeclarationResolverKt.lazyResolveToPhase(firProperty, FirResolvePhase.BODY_RESOLVE);
                    }
                }
            }
            fileStructureElement = new DeclarationStructureElement(firFile, firDeclaration, moduleComponents);
        }
        return fileStructureElement;
    }

    private final void lazyResolveClassGeneratedMembers(FirRegularClass firClass) {
        List<FirDeclaration> list;
        List<FirDeclaration> $this$lazyResolveClassGeneratedMembers_u24lambda_u241 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        for (FirDeclaration member : firClass.getDeclarations()) {
            if (member instanceof FirSimpleFunction) {
                KtSourceElement ktSourceElement = ((FirSimpleFunction)member).getSource();
                if (Intrinsics.areEqual(ktSourceElement != null ? ktSourceElement.getKind() : null, KtFakeSourceElementKind.DataClassGeneratedMembers.INSTANCE)) {
                    $this$lazyResolveClassGeneratedMembers_u24lambda_u241.add(member);
                    continue;
                }
            }
            KtSourceElement ktSourceElement = member.getSource();
            if (Intrinsics.areEqual(ktSourceElement != null ? ktSourceElement.getKind() : null, KtFakeSourceElementKind.EnumGeneratedDeclaration.INSTANCE)) {
                $this$lazyResolveClassGeneratedMembers_u24lambda_u241.add(member);
                continue;
            }
            if (FileStructureElementDiagnosticRetrieverKt.isImplicitConstructor(member)) {
                $this$lazyResolveClassGeneratedMembers_u24lambda_u241.add(member);
                continue;
            }
            if (member instanceof FirField) {
                KtSourceElement ktSourceElement2 = ((FirField)member).getSource();
                if (Intrinsics.areEqual(ktSourceElement2 != null ? ktSourceElement2.getKind() : null, KtFakeSourceElementKind.ClassDelegationField.INSTANCE)) {
                    $this$lazyResolveClassGeneratedMembers_u24lambda_u241.add(member);
                    continue;
                }
            }
            if (!(member instanceof FirDanglingModifierList)) continue;
            $this$lazyResolveClassGeneratedMembers_u24lambda_u241.add(member);
        }
        List classMembersToResolve = CollectionsKt.build(list);
        if (classMembersToResolve.isEmpty()) {
            return;
        }
        FirDesignation firClassDesignation = FirDesignationKt.collectDesignation$default(firClass, null, 1, null);
        LLFirClassSpecificMembersResolveTarget designationWithMembers = new LLFirClassSpecificMembersResolveTarget(firClassDesignation, classMembersToResolve);
        TargetUtilsKt.resolve(designationWithMembers, FirResolvePhase.BODY_RESOLVE);
    }
}

