/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.low.level.api.fir.LLFirModuleResolveComponents;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.DiagnosticCheckerFilter;
import org.jetbrains.kotlin.analysis.low.level.api.fir.diagnostics.FileStructureElementDiagnosticList;
import org.jetbrains.kotlin.analysis.low.level.api.fir.diagnostics.FileStructureElementDiagnostics;
import org.jetbrains.kotlin.analysis.low.level.api.fir.diagnostics.LLFirDiagnosticVisitor;
import org.jetbrains.kotlin.analysis.low.level.api.fir.element.builder.FirElementBuilderKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.DeclarationStructureElement;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.FileElementFactory;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.FileStructure;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.FileStructureElement;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.RootStructureElement;
import org.jetbrains.kotlin.analysis.low.level.api.fir.util.DeclarationUtilsKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.util.ExceptionUtilsKt;
import org.jetbrains.kotlin.diagnostics.KtPsiDiagnostic;
import org.jetbrains.kotlin.fir.declarations.FirCodeFragment;
import org.jetbrains.kotlin.fir.declarations.FirDanglingModifierList;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.resolve.providers.FirProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirProviderKt;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.utils.exceptions.ExceptionAttachementBuilderUtilsKt;
import org.jetbrains.kotlin.utils.exceptions.ExceptionAttachmentBuilder;
import org.jetbrains.kotlin.utils.exceptions.KotlinExceptionWithAttachments;
import org.jetbrains.kotlin.utils.exceptions.KotlinIllegalArgumentExceptionWithAttachments;
import org.jetbrains.kotlin.utils.exceptions.PlatformExceptionUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 =2\u00020\u0001:\u0001=B!\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000eJ#\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\n2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0013J%\u0010\u0016\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\n2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u0014H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J!\u0010\u0018\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J#\u0010\u001a\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u000b\u001a\u00020\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001b\u0010\u001e\u001a\u00020\u001d*\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u001d\u0010$\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010!\u001a\u00020 H\u0007\u00a2\u0006\u0004\b$\u0010%J/\u0010(\u001a\u00020\f*\b\u0012\u0004\u0012\u00020#0\u00142\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00110&2\u0006\u0010!\u001a\u00020 H\u0002\u00a2\u0006\u0004\b(\u0010)J\u0015\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00110&H\u0007\u00a2\u0006\u0004\b*\u0010+J\u0017\u0010-\u001a\u00020\u00112\u0006\u0010,\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b-\u0010.J\u0017\u00101\u001a\u00020\u00112\u0006\u00100\u001a\u00020/H\u0002\u00a2\u0006\u0004\b1\u00102J\u0017\u00103\u001a\u00020\u00112\u0006\u00100\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b3\u00104R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u00105R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u00106R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u00107R\u0014\u00109\u001a\u0002088\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b9\u0010:R \u0010'\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00110;8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b'\u0010<"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FileStructure;", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "ktFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "firFile", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/LLFirModuleResolveComponents;", "moduleComponents", "<init>", "(Lorg/jetbrains/kotlin/psi/KtFile;Lorg/jetbrains/kotlin/fir/declarations/FirFile;Lorg/jetbrains/kotlin/analysis/low/level/api/fir/LLFirModuleResolveComponents;)V", "Lorg/jetbrains/kotlin/psi/KtElement;", "element", "", "invalidateElement", "(Lorg/jetbrains/kotlin/psi/KtElement;)V", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "nonLocalContainer", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FileStructureElement;", "getStructureElementFor", "(Lorg/jetbrains/kotlin/psi/KtElement;Lorg/jetbrains/kotlin/psi/KtDeclaration;)Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FileStructureElement;", "", "result", "addStructureElementForTo", "(Lorg/jetbrains/kotlin/psi/KtElement;Ljava/util/Collection;)V", "getContainerKtElement", "(Lorg/jetbrains/kotlin/psi/KtElement;Lorg/jetbrains/kotlin/psi/KtDeclaration;)Lorg/jetbrains/kotlin/psi/KtElement;", "getStructureKtElement", "(Lorg/jetbrains/kotlin/psi/KtElement;Lorg/jetbrains/kotlin/psi/KtDeclaration;)Lorg/jetbrains/kotlin/psi/KtDeclaration;", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "", "isPartOfSuperClassCall", "(Lorg/jetbrains/kotlin/psi/KtClassOrObject;Lorg/jetbrains/kotlin/psi/KtElement;)Z", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/api/DiagnosticCheckerFilter;", "diagnosticCheckerFilter", "", "Lorg/jetbrains/kotlin/diagnostics/KtPsiDiagnostic;", "getAllDiagnosticsForFile", "(Lorg/jetbrains/kotlin/analysis/low/level/api/fir/api/DiagnosticCheckerFilter;)Ljava/util/List;", "", "structureElements", "collectDiagnosticsFromStructureElements", "(Ljava/util/Collection;Ljava/util/Collection;Lorg/jetbrains/kotlin/analysis/low/level/api/fir/api/DiagnosticCheckerFilter;)V", "getAllStructureElements", "()Ljava/util/Collection;", "declaration", "createDeclarationStructure", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;)Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FileStructureElement;", "Lorg/jetbrains/kotlin/psi/KtModifierList;", "container", "createDanglingModifierListStructure", "(Lorg/jetbrains/kotlin/psi/KtModifierList;)Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FileStructureElement;", "createStructureElement", "(Lorg/jetbrains/kotlin/psi/KtElement;)Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FileStructureElement;", "Lorg/jetbrains/kotlin/psi/KtFile;", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/LLFirModuleResolveComponents;", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirProvider;", "firProvider", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirProvider;", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/concurrent/ConcurrentHashMap;", "Companion"})
public final class FileStructure {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KtFile ktFile;
    @NotNull
    private final FirFile firFile;
    @NotNull
    private final LLFirModuleResolveComponents moduleComponents;
    @NotNull
    private final FirProvider firProvider;
    @NotNull
    private final ConcurrentHashMap<KtElement, FileStructureElement> structureElements;

    private FileStructure(KtFile ktFile, FirFile firFile, LLFirModuleResolveComponents moduleComponents) {
        this.ktFile = ktFile;
        this.firFile = firFile;
        this.moduleComponents = moduleComponents;
        this.firProvider = FirProviderKt.getFirProvider(this.firFile.getModuleData().getSession());
        this.structureElements = new ConcurrentHashMap();
    }

    public final void invalidateElement(@NotNull KtElement element) {
        Intrinsics.checkNotNullParameter(element, "element");
        KtElement container = this.getContainerKtElement(element, FileStructure.Companion.findNonLocalContainer(element));
        this.structureElements.remove(container);
    }

    @NotNull
    public final FileStructureElement getStructureElementFor(@NotNull KtElement element, @Nullable KtDeclaration nonLocalContainer) {
        Intrinsics.checkNotNullParameter(element, "element");
        KtElement container = this.getContainerKtElement(element, nonLocalContainer);
        ConcurrentMap $this$getOrPut$iv = this.structureElements;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(container);
        if (object == null) {
            boolean bl = false;
            FileStructureElement default$iv = this.createStructureElement(container);
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(container, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        Intrinsics.checkNotNullExpressionValue(object, "getOrPut(...)");
        return (FileStructureElement)object;
    }

    public static /* synthetic */ FileStructureElement getStructureElementFor$default(FileStructure fileStructure, KtElement ktElement, KtDeclaration ktDeclaration, int n, Object object) {
        if ((n & 2) != 0) {
            ktDeclaration = FileStructure.Companion.findNonLocalContainer(ktElement);
        }
        return fileStructure.getStructureElementFor(ktElement, ktDeclaration);
    }

    private final void addStructureElementForTo(KtElement element, Collection<FileStructureElement> result2) {
        boolean $i$f$checkCanceled = false;
        ProgressManager.checkCanceled();
        LLFirDiagnosticVisitor.Companion this_$iv = LLFirDiagnosticVisitor.Companion;
        boolean $i$f$suppressAndLogExceptions = false;
        try {
            boolean bl = false;
            result2.add(FileStructure.getStructureElementFor$default(this, element, null, 2, null));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable e$iv) {
            PlatformExceptionUtilsKt.rethrowIntellijPlatformExceptionIfNeeded(e$iv);
            LLFirDiagnosticVisitor.Companion $this$thisLogger$iv$iv = this_$iv;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(LLFirDiagnosticVisitor.Companion.class);
            Intrinsics.checkNotNullExpressionValue(logger, "getInstance(...)");
            logger.error("The diagnostic collector has been interrupted by an exception. The result may be incomplete", e$iv);
            Object var6_8 = null;
        }
    }

    private final KtElement getContainerKtElement(KtElement element, KtDeclaration nonLocalContainer) {
        KtDeclaration declaration = this.getStructureKtElement(element, nonLocalContainer);
        KtElement container = null;
        if (declaration != null) {
            container = declaration;
        } else {
            KtElement ktElement;
            KtModifierList modifierList2 = PsiTreeUtil.getParentOfType((PsiElement)element, KtModifierList.class, false);
            if (modifierList2 != null && PsiUtilsKt.getNextSiblingIgnoringWhitespaceAndComments$default(modifierList2, false, 1, null) instanceof PsiErrorElement) {
                ktElement = modifierList2;
            } else {
                KtFile ktFile = element.getContainingKtFile();
                Intrinsics.checkNotNull(ktFile);
                ktElement = ktFile;
            }
            container = ktElement;
        }
        return container;
    }

    private final KtDeclaration getStructureKtElement(KtElement element, KtDeclaration nonLocalContainer) {
        KtPrimaryConstructor resultedContainer;
        KtDeclaration ktDeclaration;
        KtDeclaration ktDeclaration2 = nonLocalContainer;
        boolean bl = ktDeclaration2 != null ? FirElementBuilderKt.isAutonomousDeclaration(ktDeclaration2) : false;
        if (bl) {
            ktDeclaration = nonLocalContainer;
        } else {
            KtDeclaration ktDeclaration3 = nonLocalContainer;
            if (ktDeclaration3 != null) {
                KtDeclaration ktDeclaration4 = ktDeclaration3;
                Companion companion = Companion;
                KtElement p0 = ktDeclaration4;
                boolean bl2 = false;
                ktDeclaration = companion.findNonLocalContainer(p0);
            } else {
                ktDeclaration = null;
            }
        }
        KtDeclaration container = ktDeclaration;
        KtPrimaryConstructor ktPrimaryConstructor = resultedContainer = container instanceof KtClassOrObject && this.isPartOfSuperClassCall((KtClassOrObject)container, element) ? ((KtClassOrObject)container).getPrimaryConstructor() : null;
        return ktPrimaryConstructor != null ? (KtDeclaration)ktPrimaryConstructor : container;
    }

    private final boolean isPartOfSuperClassCall(KtClassOrObject $this$isPartOfSuperClassCall, KtElement element) {
        for (KtSuperTypeListEntry entry : $this$isPartOfSuperClassCall.getSuperTypeListEntries()) {
            boolean typeReferenceIsAncestor;
            if (!(entry instanceof KtSuperTypeCallEntry)) continue;
            KtTypeReference ktTypeReference = ((KtSuperTypeCallEntry)entry).getCalleeExpression().getTypeReference();
            boolean bl = ktTypeReference != null ? PsiUtilsKt.isAncestor(ktTypeReference, element, false) : (typeReferenceIsAncestor = false);
            if (typeReferenceIsAncestor) {
                return false;
            }
            if (!PsiUtilsKt.isAncestor(entry, element, false)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public final List<KtPsiDiagnostic> getAllDiagnosticsForFile(@NotNull DiagnosticCheckerFilter diagnosticCheckerFilter) {
        List list;
        Intrinsics.checkNotNullParameter(diagnosticCheckerFilter, "diagnosticCheckerFilter");
        Collection<FileStructureElement> structureElements = this.getAllStructureElements();
        List $this$getAllDiagnosticsForFile_u24lambda_u242 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        this.collectDiagnosticsFromStructureElements($this$getAllDiagnosticsForFile_u24lambda_u242, structureElements, diagnosticCheckerFilter);
        return CollectionsKt.build(list);
    }

    private final void collectDiagnosticsFromStructureElements(Collection<KtPsiDiagnostic> $this$collectDiagnosticsFromStructureElements, Collection<? extends FileStructureElement> structureElements, DiagnosticCheckerFilter diagnosticCheckerFilter) {
        Iterable $this$forEach$iv = structureElements;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl;
            List diagnostics;
            boolean $i$f$forEach2;
            Iterable $this$forEach$iv$iv$iv;
            boolean $i$f$forEach3;
            FileStructureElementDiagnosticList this_$iv$iv;
            FileStructureElement structureElement = (FileStructureElement)element$iv;
            boolean bl2 = false;
            ProgressManager.checkCanceled();
            FileStructureElementDiagnostics this_$iv = structureElement.getDiagnostics();
            boolean $i$f$forEach4 = false;
            if (diagnosticCheckerFilter.getRunDefaultCheckers()) {
                this_$iv$iv = FileStructureElementDiagnostics.access$getDiagnosticByDefaultCheckers(this_$iv);
                $i$f$forEach3 = false;
                $this$forEach$iv$iv$iv = FileStructureElementDiagnosticList.access$getMap$p(this_$iv$iv).values();
                $i$f$forEach2 = false;
                for (Object element$iv$iv$iv : $this$forEach$iv$iv$iv) {
                    diagnostics = (List)element$iv$iv$iv;
                    bl = false;
                    $this$collectDiagnosticsFromStructureElements.addAll(diagnostics);
                }
            }
            if (diagnosticCheckerFilter.getRunExtraCheckers()) {
                this_$iv$iv = FileStructureElementDiagnostics.access$getDiagnosticByExtraCheckers(this_$iv);
                $i$f$forEach3 = false;
                $this$forEach$iv$iv$iv = FileStructureElementDiagnosticList.access$getMap$p(this_$iv$iv).values();
                $i$f$forEach2 = false;
                for (Object element$iv$iv$iv : $this$forEach$iv$iv$iv) {
                    diagnostics = (List)element$iv$iv$iv;
                    bl = false;
                    $this$collectDiagnosticsFromStructureElements.addAll(diagnostics);
                }
            }
            if (!diagnosticCheckerFilter.getRunExperimentalCheckers()) continue;
            this_$iv$iv = FileStructureElementDiagnostics.access$getDiagnosticByExperimentalCheckers(this_$iv);
            $i$f$forEach3 = false;
            $this$forEach$iv$iv$iv = FileStructureElementDiagnosticList.access$getMap$p(this_$iv$iv).values();
            $i$f$forEach2 = false;
            for (Object element$iv$iv$iv : $this$forEach$iv$iv$iv) {
                diagnostics = (List)element$iv$iv$iv;
                bl = false;
                $this$collectDiagnosticsFromStructureElements.addAll(diagnostics);
            }
        }
    }

    @NotNull
    public final Collection<FileStructureElement> getAllStructureElements() {
        Set structureElements = new LinkedHashSet();
        this.addStructureElementForTo(this.ktFile, structureElements);
        this.ktFile.accept(new KtVisitorVoid(this, structureElements){
            final /* synthetic */ FileStructure this$0;
            final /* synthetic */ Set<FileStructureElement> $structureElements;
            {
                this.this$0 = $receiver;
                this.$structureElements = $structureElements;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter(element, "element");
                element.acceptChildren(this);
            }

            public void visitDeclaration(KtDeclaration dcl) {
                boolean canHaveInnerStructure;
                Intrinsics.checkNotNullParameter(dcl, "dcl");
                FileStructure.access$addStructureElementForTo(this.this$0, dcl, this.$structureElements);
                boolean bl = canHaveInnerStructure = dcl instanceof KtClassOrObject || dcl instanceof KtScript || dcl instanceof KtDestructuringDeclaration;
                if (canHaveInnerStructure) {
                    dcl.acceptChildren(this);
                }
            }

            public void visitModifierList(KtModifierList list) {
                Intrinsics.checkNotNullParameter(list, "list");
                if (Intrinsics.areEqual(list.getParent(), FileStructure.access$getKtFile$p(this.this$0))) {
                    FileStructure.access$addStructureElementForTo(this.this$0, list, this.$structureElements);
                }
            }
        });
        return CollectionsKt.asReversed(CollectionsKt.toList(structureElements));
    }

    private final FileStructureElement createDeclarationStructure(KtDeclaration declaration) {
        FirDeclaration firDeclaration = DeclarationUtilsKt.findSourceNonLocalFirDeclaration(declaration, this.firFile, this.firProvider);
        return FileElementFactory.INSTANCE.createFileStructureElement(firDeclaration, this.firFile, this.moduleComponents);
    }

    private final FileStructureElement createDanglingModifierListStructure(KtModifierList container) {
        FirDeclaration firDeclaration = DeclarationUtilsKt.findSourceByTraversingWholeTree(container, this.moduleComponents.getFirFileBuilder(), this.firFile);
        FirDanglingModifierList firDanglingModifierList = firDeclaration instanceof FirDanglingModifierList ? (FirDanglingModifierList)firDeclaration : null;
        if (firDanglingModifierList == null) {
            ExceptionUtilsKt.errorWithFirSpecificEntries$default("No dangling modifier found", null, null, null, container, null, 46, null);
            throw new KotlinNothingValueException();
        }
        FirDanglingModifierList firDanglingModifierList2 = firDanglingModifierList;
        FirLazyDeclarationResolverKt.lazyResolveToPhase(firDanglingModifierList2, FirResolvePhase.BODY_RESOLVE);
        return new DeclarationStructureElement(this.firFile, firDanglingModifierList2, this.moduleComponents);
    }

    /*
     * WARNING - void declaration
     */
    private final FileStructureElement createStructureElement(KtElement container) {
        FileStructureElement fileStructureElement;
        if (container instanceof KtCodeFragment) {
            FirCodeFragment firCodeFragment = DeclarationUtilsKt.getCodeFragment(this.firFile);
            FirLazyDeclarationResolverKt.lazyResolveToPhase(firCodeFragment, FirResolvePhase.BODY_RESOLVE);
            fileStructureElement = new DeclarationStructureElement(this.firFile, firCodeFragment, this.moduleComponents);
        } else if (container instanceof KtFile) {
            FirFile firFile = this.moduleComponents.getFirFileBuilder().buildRawFirFileWithCaching(this.ktFile);
            FirLazyDeclarationResolverKt.lazyResolveToPhase(firFile, FirResolvePhase.BODY_RESOLVE.getPrevious());
            fileStructureElement = new RootStructureElement(firFile, this.moduleComponents);
        } else if (container instanceof KtDeclaration) {
            fileStructureElement = this.createDeclarationStructure((KtDeclaration)container);
        } else if (container instanceof KtModifierList && PsiUtilsKt.getNextSiblingIgnoringWhitespaceAndComments$default(container, false, 1, null) instanceof PsiErrorElement) {
            fileStructureElement = this.createDanglingModifierListStructure((KtModifierList)container);
        } else {
            void $this$buildErrorWithAttachment_u24lambda_u240$iv$iv;
            ExceptionAttachmentBuilder exceptionAttachmentBuilder;
            String message$iv = "Invalid container " + Reflection.getOrCreateKotlinClass(container.getClass());
            Throwable cause$iv = null;
            String attachmentName$iv = "info.txt";
            boolean $i$f$errorWithAttachment = false;
            boolean $i$f$buildErrorWithAttachment = false;
            KotlinIllegalArgumentExceptionWithAttachments exception$iv$iv = new KotlinIllegalArgumentExceptionWithAttachments(message$iv, cause$iv);
            KotlinExceptionWithAttachments $this$buildAttachment$iv$iv$iv = exception$iv$iv;
            boolean $i$f$buildAttachment = false;
            ExceptionAttachmentBuilder exceptionAttachmentBuilder2 = exceptionAttachmentBuilder = new ExceptionAttachmentBuilder();
            String string2 = attachmentName$iv;
            KotlinExceptionWithAttachments kotlinExceptionWithAttachments = $this$buildAttachment$iv$iv$iv;
            boolean bl = false;
            void $this$createStructureElement_u24lambda_u245 = $this$buildErrorWithAttachment_u24lambda_u240$iv$iv;
            boolean bl2 = false;
            ExceptionAttachementBuilderUtilsKt.withPsiEntry((ExceptionAttachmentBuilder)$this$createStructureElement_u24lambda_u245, "container", container);
            kotlinExceptionWithAttachments.withAttachment(string2, exceptionAttachmentBuilder.buildString());
            throw (Throwable)exception$iv$iv;
        }
        return fileStructureElement;
    }

    public /* synthetic */ FileStructure(KtFile ktFile, FirFile firFile, LLFirModuleResolveComponents moduleComponents, DefaultConstructorMarker $constructor_marker) {
        this(ktFile, firFile, moduleComponents);
    }

    public static final /* synthetic */ void access$addStructureElementForTo(FileStructure $this, KtElement element, Collection result2) {
        $this.addStructureElementForTo(element, result2);
    }

    public static final /* synthetic */ KtFile access$getKtFile$p(FileStructure $this) {
        return $this.ktFile;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0019\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000f"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FileStructure$Companion;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/psi/KtFile;", "ktFile", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/LLFirModuleResolveComponents;", "moduleComponents", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FileStructure;", "build", "(Lorg/jetbrains/kotlin/psi/KtFile;Lorg/jetbrains/kotlin/analysis/low/level/api/fir/LLFirModuleResolveComponents;)Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FileStructure;", "Lorg/jetbrains/kotlin/psi/KtElement;", "element", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "findNonLocalContainer", "(Lorg/jetbrains/kotlin/psi/KtElement;)Lorg/jetbrains/kotlin/psi/KtDeclaration;"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FileStructure build(@NotNull KtFile ktFile, @NotNull LLFirModuleResolveComponents moduleComponents) {
            Intrinsics.checkNotNullParameter(ktFile, "ktFile");
            Intrinsics.checkNotNullParameter(moduleComponents, "moduleComponents");
            FirFile firFile = moduleComponents.getFirFileBuilder().buildRawFirFileWithCaching(ktFile);
            return new FileStructure(ktFile, firFile, moduleComponents, null);
        }

        private final KtDeclaration findNonLocalContainer(KtElement element) {
            return FirElementBuilderKt.getNonLocalContainingOrThisDeclaration(element, findNonLocalContainer.1.INSTANCE);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

