/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure;

import com.intellij.util.containers.ContainerUtil;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.low.level.api.fir.LLFirModuleResolveComponents;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.FileStructure;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0019\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\u000b\u0010\nR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\fR \u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\b0\r8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000f"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FileStructureCache;", "", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/LLFirModuleResolveComponents;", "moduleResolveComponents", "<init>", "(Lorg/jetbrains/kotlin/analysis/low/level/api/fir/LLFirModuleResolveComponents;)V", "Lorg/jetbrains/kotlin/psi/KtFile;", "ktFile", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FileStructure;", "getFileStructure", "(Lorg/jetbrains/kotlin/psi/KtFile;)Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FileStructure;", "getCachedFileStructure", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/LLFirModuleResolveComponents;", "Ljava/util/concurrent/ConcurrentMap;", "cache", "Ljava/util/concurrent/ConcurrentMap;"})
public final class FileStructureCache {
    @NotNull
    private final LLFirModuleResolveComponents moduleResolveComponents;
    @NotNull
    private final ConcurrentMap<KtFile, FileStructure> cache;

    public FileStructureCache(@NotNull LLFirModuleResolveComponents moduleResolveComponents) {
        Intrinsics.checkNotNullParameter(moduleResolveComponents, "moduleResolveComponents");
        this.moduleResolveComponents = moduleResolveComponents;
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentSoftKeySoftValueMap();
        Intrinsics.checkNotNullExpressionValue(concurrentMap, "createConcurrentSoftKeySoftValueMap(...)");
        this.cache = concurrentMap;
    }

    @NotNull
    public final FileStructure getFileStructure(@NotNull KtFile ktFile) {
        Intrinsics.checkNotNullParameter(ktFile, "ktFile");
        FileStructure fileStructure = this.cache.computeIfAbsent(ktFile, arg_0 -> FileStructureCache.getFileStructure$lambda$1(arg_0 -> FileStructureCache.getFileStructure$lambda$0(ktFile, this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue(fileStructure, "computeIfAbsent(...)");
        return fileStructure;
    }

    @Nullable
    public final FileStructure getCachedFileStructure(@NotNull KtFile ktFile) {
        Intrinsics.checkNotNullParameter(ktFile, "ktFile");
        return (FileStructure)this.cache.get(ktFile);
    }

    private static final FileStructure getFileStructure$lambda$0(KtFile $ktFile, FileStructureCache this$0, KtFile it) {
        return FileStructure.Companion.build($ktFile, this$0.moduleResolveComponents);
    }

    private static final FileStructure getFileStructure$lambda$1(Function1 $tmp0, Object p0) {
        return (FileStructure)$tmp0.invoke(p0);
    }
}

