/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.FileStructureElement;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.FirElementsRecorder;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtConstructorDelegationCall;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtScriptInitializer;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentName;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0019\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0019\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\f\u0010\nR \u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\b0\r8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000f"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/KtToFirMapping;", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "firElement", "<init>", "(Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)V", "Lorg/jetbrains/kotlin/psi/KtElement;", "ktElement", "Lorg/jetbrains/kotlin/fir/FirElement;", "getElement", "(Lorg/jetbrains/kotlin/psi/KtElement;)Lorg/jetbrains/kotlin/fir/FirElement;", "element", "getFir", "", "mapping", "Ljava/util/Map;"})
public final class KtToFirMapping {
    @NotNull
    private final Map<KtElement, FirElement> mapping;

    public KtToFirMapping(@NotNull FirDeclaration firElement) {
        Intrinsics.checkNotNullParameter(firElement, "firElement");
        this.mapping = FirElementsRecorder.Companion.recordElementsFrom(firElement, FileStructureElement.Companion.recorderFor(firElement));
    }

    @Nullable
    public final FirElement getElement(@NotNull KtElement ktElement) {
        Intrinsics.checkNotNullParameter(ktElement, "ktElement");
        return this.mapping.get(ktElement);
    }

    @Nullable
    public final FirElement getFir(@NotNull KtElement element) {
        FirElement firElement;
        Object object;
        Intrinsics.checkNotNullParameter(element, "element");
        PsiElement current = element;
        while (Intrinsics.areEqual(current, element) || current instanceof KtUserType || current instanceof KtTypeReference || current instanceof KtDotQualifiedExpression || current instanceof KtNullableType) {
            if (current instanceof KtElement && (object = this.getElement((KtElement)current)) != null) {
                FirElement it = object;
                boolean bl = false;
                return it;
            }
            current = current.getParent();
        }
        object = current;
        if (object instanceof KtPrefixExpression || object instanceof KtAnnotationEntry || object instanceof KtSafeQualifiedExpression || object instanceof KtDestructuringDeclaration || object instanceof KtThisExpression || object instanceof KtSuperExpression || object instanceof KtImportDirective || object instanceof KtPackageDirective || object instanceof KtSuperTypeCallEntry || object instanceof KtConstructorDelegationCall || object instanceof KtTypeProjection) {
            PsiElement psiElement = current;
            Intrinsics.checkNotNull(psiElement, "null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtElement");
            firElement = this.getElement((KtElement)psiElement);
        } else if (object instanceof KtCallExpression) {
            PsiElement parent2 = ((KtCallExpression)current).getParent();
            firElement = ((KtCallExpression)current).getValueArgumentList() == null && parent2 instanceof KtQualifiedExpression && Intrinsics.areEqual(((KtQualifiedExpression)parent2).getSelectorExpression(), current) ? this.getElement((KtElement)parent2) : this.getElement((KtElement)current);
        } else if (object instanceof KtBinaryExpression) {
            firElement = element instanceof KtArrayAccessExpression || element instanceof KtOperationReferenceExpression ? this.getElement((KtElement)current) : null;
        } else if (object instanceof KtBlockExpression) {
            if (element instanceof KtScriptInitializer) {
                PsiElement psiElement = ((KtBlockExpression)current).getParent();
                Intrinsics.checkNotNull(psiElement, "null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtScript");
                firElement = this.getElement((KtScript)psiElement);
            } else {
                firElement = null;
            }
        } else if (object instanceof PsiErrorElement) {
            PsiElement parent3 = ((PsiErrorElement)current).getParent();
            firElement = parent3 instanceof KtDestructuringDeclaration ? this.getElement((KtElement)parent3) : null;
        } else if (object instanceof KtValueArgumentName) {
            PsiElement psiElement = ((KtValueArgumentName)current).getParent();
            Intrinsics.checkNotNull(psiElement, "null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtValueArgument");
            firElement = this.getElement((KtValueArgument)psiElement);
        } else if (object instanceof KtContainerNode) {
            PsiElement parent4 = ((KtContainerNode)current).getParent();
            firElement = parent4 instanceof KtExpressionWithLabel ? this.getElement((KtElement)parent4) : null;
        } else if (object instanceof KtConstructorCalleeExpression) {
            PsiElement psiElement = ((KtConstructorCalleeExpression)current).getParent();
            Intrinsics.checkNotNull(psiElement, "null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCallElement");
            firElement = this.getElement((KtCallElement)psiElement);
        } else if (object instanceof KtParameter) {
            PsiElement psiElement = current;
            Intrinsics.checkNotNull(psiElement, "null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtElement");
            firElement = this.getElement((KtElement)psiElement);
        } else {
            firElement = null;
        }
        return firElement;
    }
}

