/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.lazy.resolve;

import com.intellij.openapi.diagnostic.Logger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhaseKt;
import org.jetbrains.kotlin.fir.symbols.FirLazyResolveContractViolationException;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J)\u0010\t\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\f\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\f\u0010\rR,\u0010\u000f\u001a\u001a\u0012\b\u0012\u0006*\u00020\u00040\u0004*\f\u0012\b\u0012\u0006*\u00020\u00040\u00040\u000e0\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010\u0082\u0002\u0007\n\u0005\b\u009920\u0001"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/lazy/resolve/LLFirLazyResolveContractChecker;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/fir/declarations/FirResolvePhase;", "phase", "Lkotlin/Function0;", "", "resolve", "lazyResolveToPhaseInside", "(Lorg/jetbrains/kotlin/fir/declarations/FirResolvePhase;Lkotlin/jvm/functions/Function0;)V", "requestedPhase", "checkIfCanLazyResolveToPhase", "(Lorg/jetbrains/kotlin/fir/declarations/FirResolvePhase;)V", "Ljava/lang/ThreadLocal;", "currentTransformerPhase", "Ljava/lang/ThreadLocal;", "LoggerHolder"})
public final class LLFirLazyResolveContractChecker {
    private final ThreadLocal<FirResolvePhase> currentTransformerPhase = ThreadLocal.withInitial(LLFirLazyResolveContractChecker::currentTransformerPhase$lambda$0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void lazyResolveToPhaseInside(@NotNull FirResolvePhase phase, @NotNull Function0<Unit> resolve2) {
        Intrinsics.checkNotNullParameter((Object)phase, "phase");
        Intrinsics.checkNotNullParameter(resolve2, "resolve");
        boolean $i$f$lazyResolveToPhaseInside = false;
        this.checkIfCanLazyResolveToPhase(phase);
        FirResolvePhase previousPhase = (FirResolvePhase)((Object)this.currentTransformerPhase.get());
        this.currentTransformerPhase.set(phase);
        try {
            resolve2.invoke();
        }
        finally {
            InlineMarker.finallyStart(1);
            this.currentTransformerPhase.set(previousPhase);
            InlineMarker.finallyEnd(1);
        }
    }

    private final void checkIfCanLazyResolveToPhase(FirResolvePhase requestedPhase) {
        FirResolvePhase firResolvePhase = this.currentTransformerPhase.get();
        if (firResolvePhase == null) {
            return;
        }
        FirResolvePhase currentPhase = firResolvePhase;
        if (!FirResolvePhaseKt.isItAllowedToCallLazyResolveTo(currentPhase, requestedPhase)) {
            FirLazyResolveContractViolationException exception = new FirLazyResolveContractViolationException(currentPhase, requestedPhase);
            if (System.getProperty("kotlin.suppress.lazy.resolve.contract.violation") != null) {
                LoggerHolder.INSTANCE.getLOG().warn(exception);
            } else {
                throw exception;
            }
        }
    }

    private static final FirResolvePhase currentTransformerPhase$lambda$0() {
        return null;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001f\u0010\u0006\u001a\u00070\u0004\u00a2\u0006\u0002\b\u00058\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\t"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/lazy/resolve/LLFirLazyResolveContractChecker$LoggerHolder;", "", "<init>", "()V", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;"})
    private static final class LoggerHolder {
        @NotNull
        public static final LoggerHolder INSTANCE = new LoggerHolder();
        @NotNull
        private static final Logger LOG;

        private LoggerHolder() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        static {
            Logger logger = Logger.getInstance(LLFirLazyResolveContractChecker.class);
            Intrinsics.checkNotNullExpressionValue(logger, "getInstance(...)");
            LOG = logger;
        }
    }
}

