/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.providers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.low.level.api.fir.providers.FirCallableSignatureKt;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.types.FirTypeRef;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bBA\b\u0002\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u0012\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0004\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0019\u0010\u000f\u001a\u00020\u000e2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\f\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0015\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u0011\u00a2\u0006\u0004\b\u000f\u0010\u0012J\u001a\u0010\u0014\u001a\u00020\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u0096\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0016\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0018R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0019R\u001c\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0019R\u0014\u0010\b\u001a\u00020\u00078\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\u001aR\u0014\u0010\t\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0018"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/providers/FirCallableSignature;", "", "", "receiverType", "", "contextReceiverTypes", "parameters", "", "typeParametersCount", "returnType", "<init>", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;ILjava/lang/String;)V", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "declaration", "", "hasTheSameSignature", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;)Z", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "(Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;)Z", "other", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "Ljava/lang/String;", "Ljava/util/List;", "I", "Companion"})
public final class FirCallableSignature {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String receiverType;
    @NotNull
    private final List<String> contextReceiverTypes;
    @Nullable
    private final List<String> parameters;
    private final int typeParametersCount;
    @NotNull
    private final String returnType;

    private FirCallableSignature(String receiverType, List<String> contextReceiverTypes, List<String> parameters2, int typeParametersCount2, String returnType) {
        this.receiverType = receiverType;
        this.contextReceiverTypes = contextReceiverTypes;
        this.parameters = parameters2;
        this.typeParametersCount = typeParametersCount2;
        this.returnType = returnType;
    }

    public final boolean hasTheSameSignature(@NotNull FirCallableSymbol<?> declaration) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        return this.hasTheSameSignature((FirCallableDeclaration)declaration.getFir());
    }

    public final boolean hasTheSameSignature(@NotNull FirCallableDeclaration declaration) {
        Object parameter;
        int index2;
        Object object;
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        if (this.receiverType == null != (declaration.getReceiverParameter() == null)) {
            return false;
        }
        if (this.contextReceiverTypes.size() != declaration.getContextParameters().size()) {
            return false;
        }
        if (this.typeParametersCount != declaration.getTypeParameters().size()) {
            return false;
        }
        List<String> list = this.parameters;
        if (!Intrinsics.areEqual(list != null ? Integer.valueOf(list.size()) : null, (object = declaration instanceof FirFunction ? (FirFunction)declaration : null) != null && (object = ((FirFunction)object).getValueParameters()) != null ? Integer.valueOf(object.size()) : null)) {
            return false;
        }
        FirLazyDeclarationResolverKt.lazyResolveToPhase(declaration, FirResolvePhase.TYPES);
        FirPureAbstractElement firPureAbstractElement = declaration.getReceiverParameter();
        if (!Intrinsics.areEqual(this.receiverType, firPureAbstractElement != null && (firPureAbstractElement = firPureAbstractElement.getTypeRef()) != null ? FirCallableSignatureKt.renderType$default((FirTypeRef)firPureAbstractElement, null, 1, null) : null)) {
            return false;
        }
        List<FirValueParameter> receivers = declaration.getContextParameters();
        Iterator iterator2 = ((Iterable)this.contextReceiverTypes).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            index2 = n++;
            parameter = (String)iterator2.next();
            if (Intrinsics.areEqual(FirCallableSignatureKt.renderType$default(receivers.get(index2).getReturnTypeRef(), null, 1, null), parameter)) continue;
            return false;
        }
        if (declaration instanceof FirFunction) {
            if (this.parameters == null) {
                String string2 = "Required value was null.";
                throw new IllegalArgumentException(string2.toString());
            }
            iterator2 = ((Iterable)((FirFunction)declaration).getValueParameters()).iterator();
            n = 0;
            while (iterator2.hasNext()) {
                index2 = n++;
                parameter = (FirValueParameter)iterator2.next();
                if (Intrinsics.areEqual(this.parameters.get(index2), FirCallableSignatureKt.renderType$default(((FirValueParameter)parameter).getReturnTypeRef(), null, 1, null))) continue;
                return false;
            }
        }
        return Intrinsics.areEqual(this.returnType, FirCallableSignatureKt.renderType$default(declaration.getSymbol().getResolvedReturnTypeRef(), null, 1, null));
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FirCallableSignature)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.receiverType, ((FirCallableSignature)other).receiverType)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.contextReceiverTypes, ((FirCallableSignature)other).contextReceiverTypes)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.parameters, ((FirCallableSignature)other).parameters)) {
            return false;
        }
        if (this.typeParametersCount != ((FirCallableSignature)other).typeParametersCount) {
            return false;
        }
        return Intrinsics.areEqual(this.returnType, ((FirCallableSignature)other).returnType);
    }

    public int hashCode() {
        String string2 = this.receiverType;
        int result2 = string2 != null ? string2.hashCode() : 0;
        result2 = 31 * result2 + ((Object)this.contextReceiverTypes).hashCode();
        List<String> list = this.parameters;
        result2 = 31 * result2 + (list != null ? ((Object)list).hashCode() : 0);
        result2 = 31 * result2 + Integer.hashCode(this.typeParametersCount);
        result2 = 31 * result2 + this.returnType.hashCode();
        return result2;
    }

    public /* synthetic */ FirCallableSignature(String receiverType, List contextReceiverTypes, List parameters2, int typeParametersCount2, String returnType, DefaultConstructorMarker $constructor_marker) {
        this(receiverType, contextReceiverTypes, parameters2, typeParametersCount2, returnType);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0007\u001a\u00020\u00062\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\u0007\u0010\u000b"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/providers/FirCallableSignature$Companion;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "callableSymbol", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/providers/FirCallableSignature;", "createSignature", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;)Lorg/jetbrains/kotlin/analysis/low/level/api/fir/providers/FirCallableSignature;", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "callableDeclaration", "(Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;)Lorg/jetbrains/kotlin/analysis/low/level/api/fir/providers/FirCallableSignature;"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FirCallableSignature createSignature(@NotNull FirCallableSymbol<?> callableSymbol) {
            Intrinsics.checkNotNullParameter(callableSymbol, "callableSymbol");
            return this.createSignature((FirCallableDeclaration)callableSymbol.getFir());
        }

        @NotNull
        public final FirCallableSignature createSignature(@NotNull FirCallableDeclaration callableDeclaration) {
            List list;
            FirValueParameter it;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Intrinsics.checkNotNullParameter(callableDeclaration, "callableDeclaration");
            FirLazyDeclarationResolverKt.lazyResolveToPhase(callableDeclaration, FirResolvePhase.TYPES);
            Iterable iterable = callableDeclaration.getContextParameters();
            FirPureAbstractElement firPureAbstractElement = callableDeclaration.getReceiverParameter();
            String string2 = firPureAbstractElement != null && (firPureAbstractElement = firPureAbstractElement.getTypeRef()) != null ? FirCallableSignatureKt.renderType$default((FirTypeRef)firPureAbstractElement, null, 1, null) : null;
            boolean $i$f$map = false;
            void var4_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                FirValueParameter firValueParameter = (FirValueParameter)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(FirCallableSignatureKt.renderType$default(it.getReturnTypeRef(), null, 1, null));
            }
            Collection collection2 = (List)destination$iv$iv;
            String string3 = string2;
            if (callableDeclaration instanceof FirFunction) {
                Collection<String> collection3;
                $this$map$iv = ((FirFunction)callableDeclaration).getValueParameters();
                collection = collection2;
                string2 = string3;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (FirValueParameter)item$iv$iv;
                    collection3 = destination$iv$iv;
                    boolean bl = false;
                    collection3.add(FirCallableSignatureKt.renderType$default(it.getReturnTypeRef(), null, 1, null));
                }
                collection3 = (List)destination$iv$iv;
                string3 = string2;
                collection2 = collection;
                list = collection3;
            } else {
                list = null;
            }
            DefaultConstructorMarker defaultConstructorMarker = null;
            String string4 = FirCallableSignatureKt.renderType$default(callableDeclaration.getSymbol().getResolvedReturnTypeRef(), null, 1, null);
            int n = callableDeclaration.getTypeParameters().size();
            List list2 = list;
            List list3 = collection2;
            String string5 = string3;
            return new FirCallableSignature(string5, list3, list2, n, string4, defaultConstructorMarker);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

