/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.providers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.utils.SortUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u0000 \u001f2\u00020\u0001:\u0002 \u001fB\u0017\b\u0002\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0002\u00a2\u0006\u0004\b\f\u0010\bJ\u001b\u0010\u000f\u001a\u00060\u000eR\u00020\u00002\u0006\u0010\r\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0012\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u0014R$\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\b\u0012\u00060\u000eR\u00020\u00000\u00158\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R \u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00110\u00158\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0017R$\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00198\u0006@BX\u0087\u000e\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\u001e"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/providers/KmpModuleSorter;", "", "", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "modules", "<init>", "(Ljava/util/List;)V", "sort", "()Ljava/util/List;", "", "groupModules", "()V", "sortModules", "module", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/providers/KmpModuleSorter$KmpGroup;", "findOrCreateRootKmpGroup", "(Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;)Lorg/jetbrains/kotlin/analysis/low/level/api/fir/providers/KmpModuleSorter$KmpGroup;", "", "getOriginalPositionOrSetCorrupted", "(Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;)I", "Ljava/util/List;", "", "groupsByModules", "Ljava/util/Map;", "originalPositions", "", "value", "hasErrors", "Z", "getHasErrors", "()Z", "Companion", "KmpGroup"})
public final class KmpModuleSorter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<KaModule> modules;
    @NotNull
    private final Map<KaModule, KmpGroup> groupsByModules;
    @NotNull
    private final Map<KaModule, Integer> originalPositions;
    private boolean hasErrors;

    private KmpModuleSorter(List<? extends KaModule> modules) {
        this.modules = modules;
        this.groupsByModules = new LinkedHashMap();
        this.originalPositions = new LinkedHashMap();
    }

    public final boolean getHasErrors() {
        return this.hasErrors;
    }

    private final List<KaModule> sort() {
        this.groupModules();
        List<KaModule> sorted2 = this.sortModules();
        return this.hasErrors ? this.modules : sorted2;
    }

    private final void groupModules() {
        Iterator iterator2 = ((Iterable)this.modules).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index2 = n++;
            KaModule module2 = (KaModule)iterator2.next();
            Integer n2 = index2;
            this.originalPositions.put(module2, n2);
            KmpGroup group = this.findOrCreateRootKmpGroup(module2);
            group.addModule(module2);
            this.groupsByModules.putIfAbsent(module2, group);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<KaModule> sortModules() {
        KaModule[] sortedModules = new KaModule[this.modules.size()];
        Iterable $this$forEachIndexed$iv = this.modules;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void module2;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            KaModule kaModule = (KaModule)item$iv;
            int index2 = n;
            boolean bl = false;
            KmpGroup group = this.groupsByModules.get(module2);
            if (group == null) {
                sortedModules[index2] = module2;
                continue;
            }
            sortedModules[group.getUpdatedIndexOf((KaModule)module2)] = module2;
        }
        return CollectionsKt.filterNotNull((Iterable)ArraysKt.toList(sortedModules));
    }

    private final KmpGroup findOrCreateRootKmpGroup(KaModule module2) {
        KmpGroup kmpGroup;
        KaModule root;
        KaModule kaModule;
        KmpGroup kmpGroup2 = this.groupsByModules.get(module2);
        if (kmpGroup2 != null) {
            KmpGroup it = kmpGroup2;
            boolean bl = false;
            return it;
        }
        if (module2.getDirectDependsOnDependencies().isEmpty()) {
            kaModule = module2;
        } else {
            Object v1;
            block8: {
                Iterable $this$singleOrNull$iv = module2.getTransitiveDependsOnDependencies();
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    KaModule dependency = (KaModule)element$iv;
                    boolean bl = false;
                    if (!dependency.getDirectDependsOnDependencies().isEmpty()) continue;
                    if (found$iv) {
                        v1 = null;
                        break block8;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v1 = !found$iv ? null : single$iv;
            }
            kaModule = root = (KaModule)v1;
        }
        if (root == null) {
            this.hasErrors = true;
            return new KmpGroup();
        }
        Map<KaModule, KmpGroup> $this$getOrPut$iv = this.groupsByModules;
        boolean $i$f$getOrPut = false;
        KmpGroup value$iv = $this$getOrPut$iv.get(root);
        if (value$iv == null) {
            boolean bl = false;
            KmpGroup answer$iv = new KmpGroup();
            $this$getOrPut$iv.put(root, answer$iv);
            kmpGroup = answer$iv;
        } else {
            kmpGroup = value$iv;
        }
        return kmpGroup;
    }

    private final int getOriginalPositionOrSetCorrupted(KaModule module2) {
        Integer originalPosition = this.originalPositions.get(module2);
        if (originalPosition == null) {
            this.hasErrors = true;
        }
        Integer n = originalPosition;
        return n != null ? n : 0;
    }

    public /* synthetic */ KmpModuleSorter(List modules, DefaultConstructorMarker $constructor_marker) {
        this(modules);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\b"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/providers/KmpModuleSorter$Companion;", "", "<init>", "()V", "", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "modules", "order", "(Ljava/util/List;)Ljava/util/List;"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<KaModule> order(@NotNull List<? extends KaModule> modules) {
            Intrinsics.checkNotNullParameter(modules, "modules");
            if (modules.size() < 2) {
                return modules;
            }
            return new KmpModuleSorter(modules, null).sort();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\n\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\r\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011R!\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u00128BX\u0083\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R'\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00188BX\u0083\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u0014\u001a\u0004\b\u001a\u0010\u001b"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/providers/KmpModuleSorter$KmpGroup;", "", "<init>", "(Lorg/jetbrains/kotlin/analysis/low/level/api/fir/providers/KmpModuleSorter;)V", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "module", "", "addModule", "(Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;)V", "", "getUpdatedIndexOf", "(Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;)I", "", "debugText", "()Ljava/lang/String;", "", "modules", "Ljava/util/List;", "", "sortedModules$delegate", "Lkotlin/Lazy;", "getSortedModules", "()Ljava/util/List;", "sortedModules", "", "oldReplacedModulesBySortedModules$delegate", "getOldReplacedModulesBySortedModules", "()Ljava/util/Map;", "oldReplacedModulesBySortedModules"})
    private final class KmpGroup {
        @NotNull
        private final List<KaModule> modules = new ArrayList();
        @NotNull
        private final Lazy sortedModules$delegate = LazyKt.lazy(() -> KmpGroup.sortedModules_delegate$lambda$2(this, KmpModuleSorter.this));
        @NotNull
        private final Lazy oldReplacedModulesBySortedModules$delegate = LazyKt.lazy(() -> KmpGroup.oldReplacedModulesBySortedModules_delegate$lambda$3(this));

        private final List<KaModule> getSortedModules() {
            Lazy lazy = this.sortedModules$delegate;
            return (List)lazy.getValue();
        }

        private final Map<KaModule, KaModule> getOldReplacedModulesBySortedModules() {
            Lazy lazy = this.oldReplacedModulesBySortedModules$delegate;
            return (Map)lazy.getValue();
        }

        public final void addModule(@NotNull KaModule module2) {
            Intrinsics.checkNotNullParameter(module2, "module");
            this.modules.add(module2);
        }

        public final int getUpdatedIndexOf(@NotNull KaModule module2) {
            Integer newPosition;
            Integer n;
            Intrinsics.checkNotNullParameter(module2, "module");
            if (!this.modules.contains(module2)) {
                throw new IllegalStateException("Check failed.");
            }
            if (this.modules.size() == 1) {
                return KmpModuleSorter.this.getOriginalPositionOrSetCorrupted(module2);
            }
            KaModule kaModule = this.getOldReplacedModulesBySortedModules().get(module2);
            if (kaModule != null) {
                KaModule kaModule2 = kaModule;
                KmpModuleSorter kmpModuleSorter = KmpModuleSorter.this;
                KaModule it = kaModule2;
                boolean bl = false;
                n = kmpModuleSorter.getOriginalPositionOrSetCorrupted(it);
            } else {
                n = newPosition = null;
            }
            if (newPosition == null) {
                KmpModuleSorter.this.hasErrors = true;
            }
            Integer n2 = newPosition;
            return n2 != null ? n2 : 0;
        }

        @NotNull
        public final String debugText() {
            return CollectionsKt.joinToString$default(this.getOldReplacedModulesBySortedModules().entrySet(), "; ", "[", "]", 0, null, arg_0 -> KmpGroup.debugText$lambda$5(KmpModuleSorter.this, arg_0), 24, null);
        }

        private static final Iterable sortedModules_delegate$lambda$2$lambda$0(KaModule $this$topologicalSort) {
            Intrinsics.checkNotNullParameter($this$topologicalSort, "$this$topologicalSort");
            return $this$topologicalSort.getDirectDependsOnDependencies();
        }

        private static final List sortedModules_delegate$lambda$2(KmpGroup this$0, KmpModuleSorter this$1) {
            List list;
            List it = list = SortUtilsKt.topologicalSort$default(this$0.modules, null, KmpGroup::sortedModules_delegate$lambda$2$lambda$0, 2, null);
            boolean bl = false;
            if (it.size() != this$0.modules.size()) {
                this$1.hasErrors = true;
            }
            return list;
        }

        private static final Map oldReplacedModulesBySortedModules_delegate$lambda$3(KmpGroup this$0) {
            return MapsKt.toMap(CollectionsKt.zip((Iterable)this$0.getSortedModules(), (Iterable)this$0.modules));
        }

        private static final CharSequence debugText$lambda$5(KmpModuleSorter this$0, Map.Entry entry) {
            Intrinsics.checkNotNullParameter(entry, "<destruct>");
            KaModule sorted2 = (KaModule)entry.getKey();
            KaModule replaced = (KaModule)entry.getValue();
            return sorted2 + " -> " + replaced + " (ix -> ix': " + this$0.originalPositions.get(sorted2) + " -> " + this$0.originalPositions.get(replaced) + ')';
        }
    }
}

