/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.providers;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.low.level.api.fir.providers.FirCallableSignature;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolNamesProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001d\u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00072\u0006\u0010\u0006\u001a\u00020\u0005H\u0017\u00a2\u0006\u0004\b\b\u0010\tJ1\u0010\u0012\u001a\u00020\u00112\u0010\u0010\f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\n2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J-\u0010\u0015\u001a\u00020\u00112\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00140\n2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0013J-\u0010\u0017\u001a\u00020\u00112\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00160\n2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0013J\u0017\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ1\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\u001d\"\f\b\u0000\u0010\u001c*\u0006\u0012\u0002\b\u00030\u000b2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u001dH\u0002\u00a2\u0006\u0004\b\u001f\u0010 J!\u0010#\u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020!2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b#\u0010$R\u0014\u0010\u0002\u001a\u00020\u00018\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0002\u0010%R\u0014\u0010)\u001a\u00020&8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010("}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/providers/LLFirDanglingFileDependenciesSymbolProvider;", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "delegate", "<init>", "(Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;)V", "Lorg/jetbrains/kotlin/name/ClassId;", "classId", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "getClassLikeSymbolByClassId", "(Lorg/jetbrains/kotlin/name/ClassId;)Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "destination", "Lorg/jetbrains/kotlin/name/FqName;", "packageFqName", "Lorg/jetbrains/kotlin/name/Name;", "name", "", "getTopLevelCallableSymbolsTo", "(Ljava/util/List;Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/name/Name;)V", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "getTopLevelFunctionSymbolsTo", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "getTopLevelPropertySymbolsTo", "fqName", "", "hasPackage", "(Lorg/jetbrains/kotlin/name/FqName;)Z", "T", "", "symbols", "filterSymbols", "(Ljava/util/List;)Ljava/util/List;", "Lcom/intellij/openapi/vfs/VirtualFile;", "virtualFile", "getSymbolRootFile", "(Lcom/intellij/openapi/vfs/VirtualFile;Lorg/jetbrains/kotlin/name/FqName;)Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolNamesProvider;", "getSymbolNamesProvider", "()Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolNamesProvider;", "symbolNamesProvider", "CandidateSignature"})
public final class LLFirDanglingFileDependenciesSymbolProvider
extends FirSymbolProvider {
    @NotNull
    private final FirSymbolProvider delegate;

    public LLFirDanglingFileDependenciesSymbolProvider(@NotNull FirSymbolProvider delegate) {
        Intrinsics.checkNotNullParameter(delegate, "delegate");
        super(delegate.getSession());
        this.delegate = delegate;
    }

    @Override
    @NotNull
    public FirSymbolNamesProvider getSymbolNamesProvider() {
        return this.delegate.getSymbolNamesProvider();
    }

    @Override
    @Nullable
    public FirClassLikeSymbol<?> getClassLikeSymbolByClassId(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter(classId, "classId");
        return this.delegate.getClassLikeSymbolByClassId(classId);
    }

    @Override
    public void getTopLevelCallableSymbolsTo(@NotNull List<FirCallableSymbol<?>> destination, @NotNull FqName packageFqName, @NotNull Name name) {
        Intrinsics.checkNotNullParameter(destination, "destination");
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        Intrinsics.checkNotNullParameter(name, "name");
        Collection collection = destination;
        List<FirCallableSymbol<?>> p0 = this.delegate.getTopLevelCallableSymbols(packageFqName, name);
        boolean bl = false;
        Iterable iterable = this.filterSymbols(p0);
        CollectionsKt.addAll(collection, iterable);
    }

    @Override
    public void getTopLevelFunctionSymbolsTo(@NotNull List<FirNamedFunctionSymbol> destination, @NotNull FqName packageFqName, @NotNull Name name) {
        Intrinsics.checkNotNullParameter(destination, "destination");
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        Intrinsics.checkNotNullParameter(name, "name");
        Collection collection = destination;
        List<FirNamedFunctionSymbol> p0 = this.delegate.getTopLevelFunctionSymbols(packageFqName, name);
        boolean bl = false;
        Iterable iterable = this.filterSymbols(p0);
        CollectionsKt.addAll(collection, iterable);
    }

    @Override
    public void getTopLevelPropertySymbolsTo(@NotNull List<FirPropertySymbol> destination, @NotNull FqName packageFqName, @NotNull Name name) {
        Intrinsics.checkNotNullParameter(destination, "destination");
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        Intrinsics.checkNotNullParameter(name, "name");
        Collection collection = destination;
        List<FirPropertySymbol> p0 = this.delegate.getTopLevelPropertySymbols(packageFqName, name);
        boolean bl = false;
        Iterable iterable = this.filterSymbols(p0);
        CollectionsKt.addAll(collection, iterable);
    }

    @Override
    public boolean hasPackage(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        return this.delegate.hasPackage(fqName2);
    }

    private final <T extends FirCallableSymbol<?>> List<T> filterSymbols(List<? extends T> symbols) {
        if (symbols.size() < 2) {
            return symbols;
        }
        LinkedHashMap binarySymbols = new LinkedHashMap();
        ArrayList<FirCallableSymbol> otherSymbols = new ArrayList<FirCallableSymbol>();
        Object object = symbols.iterator();
        while (object.hasNext()) {
            FirCallableSymbol symbol = (FirCallableSymbol)object.next();
            if (symbol.getCallableId().getClassName() == null) {
                VirtualFile symbolRootVirtualFile;
                VirtualFile symbolVirtualFile;
                PsiFile symbolFile;
                CallableId callableId = symbol.getCallableId();
                PsiElement psiElement = UtilsKt.getPsi((FirElement)symbol.getFir());
                PsiFile psiFile = symbolFile = psiElement != null ? psiElement.getContainingFile() : null;
                VirtualFile virtualFile = symbolVirtualFile = psiFile != null ? psiFile.getVirtualFile() : null;
                if (symbolFile instanceof KtFile && ((KtFile)symbolFile).isCompiled() && symbolVirtualFile != null && (symbolRootVirtualFile = this.getSymbolRootFile(symbolVirtualFile, ((KtFile)symbolFile).getPackageFqName())) != null) {
                    Object object2;
                    Object object3;
                    Cloneable answer$iv;
                    Map $this$getOrPut$iv;
                    CandidateSignature key = new CandidateSignature(callableId, FirCallableSignature.Companion.createSignature(symbol));
                    Map map2 = binarySymbols;
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv.get(key);
                    if (value$iv == null) {
                        boolean bl = false;
                        answer$iv = new LinkedHashMap();
                        $this$getOrPut$iv.put(key, answer$iv);
                        object3 = answer$iv;
                    } else {
                        object3 = value$iv;
                    }
                    $this$getOrPut$iv = (Map)object3;
                    $i$f$getOrPut = false;
                    value$iv = $this$getOrPut$iv.get(symbolRootVirtualFile);
                    if (value$iv == null) {
                        boolean bl = false;
                        answer$iv = new ArrayList();
                        $this$getOrPut$iv.put(symbolRootVirtualFile, answer$iv);
                        object2 = answer$iv;
                    } else {
                        object2 = value$iv;
                    }
                    ((List)object2).add(symbol);
                    continue;
                }
            }
            otherSymbols.add(symbol);
        }
        if (!((Map)binarySymbols).isEmpty()) {
            Object $this$filterSymbols_u24lambda_u244 = object = CollectionsKt.createListBuilder();
            boolean bl = false;
            $this$filterSymbols_u24lambda_u244.addAll((Collection)otherSymbols);
            for (Object v : binarySymbols.values()) {
                Intrinsics.checkNotNullExpressionValue(v, "next(...)");
                Map binarySymbolGroup = (Map)v;
                List firstBinarySymbolGroupValue = (List)CollectionsKt.first(binarySymbolGroup.values());
                if (!(!((Collection)firstBinarySymbolGroupValue).isEmpty())) continue;
                $this$filterSymbols_u24lambda_u244.addAll(firstBinarySymbolGroupValue);
            }
            return CollectionsKt.build(object);
        }
        return symbols;
    }

    private final VirtualFile getSymbolRootFile(VirtualFile virtualFile, FqName packageFqName) {
        List<Name> packageFqNameSegments = CollectionsKt.asReversed(packageFqName.pathSegments());
        int nestingLevel = packageFqNameSegments.size();
        VirtualFile current = virtualFile;
        int index2 = 0;
        while (true) {
            VirtualFile parent2;
            boolean bl;
            boolean bl2 = bl = index2 <= nestingLevel;
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            if (current.getParent() == null) {
                return null;
            }
            if (index2 == nestingLevel) {
                return parent2;
            }
            if (!Intrinsics.areEqual(parent2.getName(), packageFqNameSegments.get(index2).asString())) {
                return null;
            }
            current = parent2;
            ++index2;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u0002H\u00c7\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u0004H\u00c7\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ$\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0004H\u00c7\u0001\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010\u0010\u001a\u00020\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0013\u001a\u00020\u0012H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0016\u001a\u00020\u0015H\u00d7\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0018\u001a\u0004\b\u0019\u0010\tR\u001a\u0010\u0005\u001a\u00020\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001a\u001a\u0004\b\u001b\u0010\u000b"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/providers/LLFirDanglingFileDependenciesSymbolProvider$CandidateSignature;", "", "Lorg/jetbrains/kotlin/name/CallableId;", "callableId", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/providers/FirCallableSignature;", "signature", "<init>", "(Lorg/jetbrains/kotlin/name/CallableId;Lorg/jetbrains/kotlin/analysis/low/level/api/fir/providers/FirCallableSignature;)V", "component1", "()Lorg/jetbrains/kotlin/name/CallableId;", "component2", "()Lorg/jetbrains/kotlin/analysis/low/level/api/fir/providers/FirCallableSignature;", "copy", "(Lorg/jetbrains/kotlin/name/CallableId;Lorg/jetbrains/kotlin/analysis/low/level/api/fir/providers/FirCallableSignature;)Lorg/jetbrains/kotlin/analysis/low/level/api/fir/providers/LLFirDanglingFileDependenciesSymbolProvider$CandidateSignature;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lorg/jetbrains/kotlin/name/CallableId;", "getCallableId", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/providers/FirCallableSignature;", "getSignature"})
    private static final class CandidateSignature {
        @NotNull
        private final CallableId callableId;
        @NotNull
        private final FirCallableSignature signature;

        public CandidateSignature(@NotNull CallableId callableId, @NotNull FirCallableSignature signature2) {
            Intrinsics.checkNotNullParameter(callableId, "callableId");
            Intrinsics.checkNotNullParameter(signature2, "signature");
            this.callableId = callableId;
            this.signature = signature2;
        }

        @NotNull
        public final CallableId getCallableId() {
            return this.callableId;
        }

        @NotNull
        public final FirCallableSignature getSignature() {
            return this.signature;
        }

        @NotNull
        public final CallableId component1() {
            return this.callableId;
        }

        @NotNull
        public final FirCallableSignature component2() {
            return this.signature;
        }

        @NotNull
        public final CandidateSignature copy(@NotNull CallableId callableId, @NotNull FirCallableSignature signature2) {
            Intrinsics.checkNotNullParameter(callableId, "callableId");
            Intrinsics.checkNotNullParameter(signature2, "signature");
            return new CandidateSignature(callableId, signature2);
        }

        public static /* synthetic */ CandidateSignature copy$default(CandidateSignature candidateSignature, CallableId callableId, FirCallableSignature firCallableSignature, int n, Object object) {
            if ((n & 1) != 0) {
                callableId = candidateSignature.callableId;
            }
            if ((n & 2) != 0) {
                firCallableSignature = candidateSignature.signature;
            }
            return candidateSignature.copy(callableId, firCallableSignature);
        }

        @NotNull
        public String toString() {
            return "CandidateSignature(callableId=" + this.callableId + ", signature=" + this.signature + ')';
        }

        public int hashCode() {
            int result2 = this.callableId.hashCode();
            result2 = result2 * 31 + this.signature.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CandidateSignature)) {
                return false;
            }
            CandidateSignature candidateSignature = (CandidateSignature)other;
            if (!Intrinsics.areEqual(this.callableId, candidateSignature.callableId)) {
                return false;
            }
            return Intrinsics.areEqual(this.signature, candidateSignature.signature);
        }
    }
}

