/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.resolve.extensions;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.permissions.KaAnalysisPermissionRegistry;
import org.jetbrains.kotlin.analysis.api.resolve.extensions.KaResolveExtension;
import org.jetbrains.kotlin.analysis.api.resolve.extensions.KaResolveExtensionProvider;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u001d\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u00072\u0006\u0010\u000b\u001a\u00020\bH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0015\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\b\u00a2\u0006\u0004\b\u0010\u0010\u0011J/\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00070\u00132\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J-\u0010\u001a\u001a\u00020\u0019*\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00170\u00162\u0006\u0010\u0018\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u001cR-\u0010!\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00070\u00138BX\u0083\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 "}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/resolve/extensions/LLFirResolveExtensionToolPackageFilter;", "", "", "Lorg/jetbrains/kotlin/analysis/api/resolve/extensions/KaResolveExtension;", "extensions", "<init>", "(Ljava/util/List;)V", "", "Lorg/jetbrains/kotlin/name/FqName;", "getAllPackages", "()Ljava/util/Set;", "packageFqName", "Lorg/jetbrains/kotlin/name/Name;", "getAllSubPackages", "(Lorg/jetbrains/kotlin/name/FqName;)Ljava/util/Set;", "", "packageExists", "(Lorg/jetbrains/kotlin/name/FqName;)Z", "packages", "", "createSubPackagesMapping", "(Ljava/util/Set;)Ljava/util/Map;", "", "", "packageName", "", "collectAllSubPackages", "(Ljava/util/Map;Lorg/jetbrains/kotlin/name/FqName;)V", "Ljava/util/List;", "packageSubPackages$delegate", "Lkotlin/Lazy;", "getPackageSubPackages", "()Ljava/util/Map;", "packageSubPackages"})
public final class LLFirResolveExtensionToolPackageFilter {
    @NotNull
    private final List<KaResolveExtension> extensions;
    @NotNull
    private final Lazy packageSubPackages$delegate;

    public LLFirResolveExtensionToolPackageFilter(@NotNull List<? extends KaResolveExtension> extensions) {
        Intrinsics.checkNotNullParameter(extensions, "extensions");
        this.extensions = extensions;
        this.packageSubPackages$delegate = LazyKt.lazy(() -> LLFirResolveExtensionToolPackageFilter.packageSubPackages_delegate$lambda$2(this));
    }

    private final Map<FqName, Set<Name>> getPackageSubPackages() {
        Lazy lazy = this.packageSubPackages$delegate;
        return (Map)lazy.getValue();
    }

    @NotNull
    public final Set<FqName> getAllPackages() {
        return this.getPackageSubPackages().keySet();
    }

    @NotNull
    public final Set<Name> getAllSubPackages(@NotNull FqName packageFqName) {
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        Set<Name> set = this.getPackageSubPackages().get(packageFqName);
        if (set == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    public final boolean packageExists(@NotNull FqName packageFqName) {
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        return this.getPackageSubPackages().containsKey(packageFqName);
    }

    private final Map<FqName, Set<Name>> createSubPackagesMapping(Set<FqName> packages2) {
        Map<FqName, Set<Name>> map2;
        Map<FqName, Set<Name>> $this$createSubPackagesMapping_u24lambda_u243 = map2 = MapsKt.createMapBuilder();
        boolean bl = false;
        for (FqName packageName : packages2) {
            this.collectAllSubPackages($this$createSubPackagesMapping_u24lambda_u243, packageName);
        }
        return MapsKt.build(map2);
    }

    private final void collectAllSubPackages(Map<FqName, Set<Name>> $this$collectAllSubPackages, FqName packageName) {
        FqName currentPackage = FqName.ROOT;
        for (Name packagePart : packageName.pathSegments()) {
            Set set;
            Map<FqName, Set<Name>> $this$getOrPut$iv = $this$collectAllSubPackages;
            boolean $i$f$getOrPut = false;
            Set value$iv = $this$getOrPut$iv.get(currentPackage);
            if (value$iv == null) {
                boolean bl = false;
                Set answer$iv = new LinkedHashSet();
                $this$getOrPut$iv.put(currentPackage, answer$iv);
                set = answer$iv;
            } else {
                set = value$iv;
            }
            set.add((Name)packagePart);
            currentPackage = currentPackage.child(packagePart);
        }
        $this$collectAllSubPackages.putIfAbsent(currentPackage, new LinkedHashSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final Map packageSubPackages_delegate$lambda$2(LLFirResolveExtensionToolPackageFilter this$0) {
        Set set;
        boolean $i$f$forbidAnalysis = false;
        String string2 = KaResolveExtensionProvider.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string2, "getSimpleName(...)");
        String description$iv$iv = string2;
        boolean $i$f$forbidAnalysis2 = false;
        KaAnalysisPermissionRegistry permissionRegistry$iv$iv = KaAnalysisPermissionRegistry.Companion.getInstance();
        if (permissionRegistry$iv$iv.getExplicitAnalysisRestriction() != null) {
            void destination$iv;
            void $this$flatMapTo$iv;
            boolean bl = false;
            Iterable iterable = this$0.extensions;
            Collection collection = new LinkedHashSet();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv : $this$flatMapTo$iv) {
                KaResolveExtension it = (KaResolveExtension)element$iv;
                boolean bl2 = false;
                Iterable list$iv = it.getContainedPackages();
                CollectionsKt.addAll(destination$iv, list$iv);
            }
            set = (Set)destination$iv;
        } else {
            Set set2;
            permissionRegistry$iv$iv.setExplicitAnalysisRestriction(new KaAnalysisPermissionRegistry.KaExplicitAnalysisRestriction(description$iv$iv));
            try {
                boolean bl = false;
                Iterable $this$flatMapTo$iv = this$0.extensions;
                Collection destination$iv = new LinkedHashSet();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv : $this$flatMapTo$iv) {
                    KaResolveExtension it = (KaResolveExtension)element$iv;
                    boolean bl3 = false;
                    Iterable list$iv = it.getContainedPackages();
                    CollectionsKt.addAll(destination$iv, list$iv);
                }
                set2 = (Set)destination$iv;
            }
            finally {
                permissionRegistry$iv$iv.setExplicitAnalysisRestriction(null);
            }
            set = set2;
        }
        Set packagesFromExtensions = set;
        return this$0.createSubPackagesMapping(packagesFromExtensions);
    }
}

