/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.sessions;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import java.lang.ref.WeakReference;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirSessionCache;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirSessionValidityModificationTracker;
import org.jetbrains.kotlin.fir.BuiltinTypes;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH'\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\u000e\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0011\u001a\u00020\u0010H\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0014\u001a\u00020\u0013H\u0017\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0005\u001a\u00020\u00048\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0019\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001f\u001a\u00020\u001c8G\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR*\u0010\"\u001a\u00020 2\u0006\u0010!\u001a\u00020 8\u0006@@X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\"\u0010#\u001a\u0004\b\"\u0010$\"\u0004\b%\u0010&R\u001a\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00100'8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b(\u0010)R\u0016\u0010+\u001a\u0004\u0018\u00010\u00108AX\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u0012"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSession;", "Lorg/jetbrains/kotlin/fir/FirSession;", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "ktModule", "Lorg/jetbrains/kotlin/fir/BuiltinTypes;", "builtinTypes", "Lorg/jetbrains/kotlin/fir/FirSession$Kind;", "kind", "<init>", "(Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;Lorg/jetbrains/kotlin/fir/BuiltinTypes;Lorg/jetbrains/kotlin/fir/FirSession$Kind;)V", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "getScopeSession", "()Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "Lcom/intellij/openapi/util/ModificationTracker;", "createValidityTracker", "()Lcom/intellij/openapi/util/ModificationTracker;", "Lcom/intellij/openapi/Disposable;", "requestDisposable", "()Lcom/intellij/openapi/Disposable;", "", "toString", "()Ljava/lang/String;", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "getKtModule", "()Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "Lorg/jetbrains/kotlin/fir/BuiltinTypes;", "getBuiltinTypes", "()Lorg/jetbrains/kotlin/fir/BuiltinTypes;", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "project", "", "value", "isValid", "Z", "()Z", "setValid$low_level_api_fir", "(Z)V", "Lkotlin/Lazy;", "lazyDisposable", "Lkotlin/Lazy;", "getRequestedDisposableOrNull$low_level_api_fir", "requestedDisposableOrNull"})
public abstract class LLFirSession
extends FirSession {
    @NotNull
    private final KaModule ktModule;
    @NotNull
    private final BuiltinTypes builtinTypes;
    private volatile boolean isValid;
    @NotNull
    private final Lazy<Disposable> lazyDisposable;

    public LLFirSession(@NotNull KaModule ktModule, @NotNull BuiltinTypes builtinTypes, @NotNull FirSession.Kind kind) {
        Intrinsics.checkNotNullParameter(ktModule, "ktModule");
        Intrinsics.checkNotNullParameter(builtinTypes, "builtinTypes");
        Intrinsics.checkNotNullParameter((Object)kind, "kind");
        super(null, kind);
        this.ktModule = ktModule;
        this.builtinTypes = builtinTypes;
        this.isValid = true;
        this.lazyDisposable = LazyKt.lazy(() -> LLFirSession.lazyDisposable$lambda$0(this));
    }

    @NotNull
    public final KaModule getKtModule() {
        return this.ktModule;
    }

    @Override
    @NotNull
    public BuiltinTypes getBuiltinTypes() {
        return this.builtinTypes;
    }

    @NotNull
    public abstract ScopeSession getScopeSession();

    @NotNull
    public final Project getProject() {
        return this.ktModule.getProject();
    }

    public final boolean isValid() {
        return this.isValid;
    }

    public final void setValid$low_level_api_fir(boolean bl) {
        this.isValid = bl;
    }

    @NotNull
    public final ModificationTracker createValidityTracker() {
        return new LLFirSessionValidityModificationTracker(new WeakReference<LLFirSession>(this));
    }

    @NotNull
    public final Disposable requestDisposable() {
        return this.lazyDisposable.getValue();
    }

    @Nullable
    public final Disposable getRequestedDisposableOrNull$low_level_api_fir() {
        return this.lazyDisposable.isInitialized() ? this.lazyDisposable.getValue() : null;
    }

    @Override
    @NotNull
    public String toString() {
        return Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName() + " for " + this.ktModule.getModuleDescription();
    }

    private static final Disposable lazyDisposable$lambda$0(LLFirSession this$0) {
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue(disposable, "newDisposable(...)");
        Disposable disposable2 = disposable;
        Disposer.register(LLFirSessionCache.Companion.getInstance(this$0.getProject()), disposable2);
        return disposable2;
    }
}

