/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.util;

import com.intellij.psi.PsiElement;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.FirDesignation;
import org.jetbrains.kotlin.analysis.low.level.api.fir.element.builder.FirElementBuilderKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.util.ContextCollectorVisitor;
import org.jetbrains.kotlin.analysis.low.level.api.fir.util.DesignationInterceptor;
import org.jetbrains.kotlin.analysis.low.level.api.fir.util.FirElementFinder;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirTowerDataContext;
import org.jetbrains.kotlin.fir.resolve.SessionHolder;
import org.jetbrains.kotlin.fir.resolve.dfa.RealVariable;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0004\u001d\u001e\u001f B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J5\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\bH\u0007\u00a2\u0006\u0004\b\f\u0010\rJ!\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\bH\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015JE\u0010\f\u001a\u00020\u001b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\b\u0010\u0016\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0017\u001a\u00020\u00132\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0007\u00a2\u0006\u0004\b\f\u0010\u001c"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/util/ContextCollector;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "file", "Lorg/jetbrains/kotlin/fir/resolve/SessionHolder;", "holder", "Lcom/intellij/psi/PsiElement;", "targetElement", "bodyElement", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/util/ContextCollector$Context;", "process", "(Lorg/jetbrains/kotlin/fir/declarations/FirFile;Lorg/jetbrains/kotlin/fir/resolve/SessionHolder;Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;)Lorg/jetbrains/kotlin/analysis/low/level/api/fir/util/ContextCollector$Context;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/api/FirDesignation;", "computeDesignation", "(Lorg/jetbrains/kotlin/fir/declarations/FirFile;Lcom/intellij/psi/PsiElement;)Lorg/jetbrains/kotlin/analysis/low/level/api/fir/api/FirDesignation;", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "declaration", "", "isValidTarget", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;)Z", "designation", "shouldCollectBodyContext", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/util/ContextCollector$FilterResponse;", "filter", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/util/ContextCollector$ContextProvider;", "(Lorg/jetbrains/kotlin/fir/declarations/FirFile;Lorg/jetbrains/kotlin/fir/resolve/SessionHolder;Lorg/jetbrains/kotlin/analysis/low/level/api/fir/api/FirDesignation;ZLkotlin/jvm/functions/Function1;)Lorg/jetbrains/kotlin/analysis/low/level/api/fir/util/ContextCollector$ContextProvider;", "ContextKind", "Context", "FilterResponse", "ContextProvider"})
public final class ContextCollector {
    @NotNull
    public static final ContextCollector INSTANCE = new ContextCollector();

    private ContextCollector() {
    }

    @Nullable
    public final Context process(@NotNull FirFile file2, @NotNull SessionHolder holder, @NotNull PsiElement targetElement, @Nullable PsiElement bodyElement) {
        Intrinsics.checkNotNullParameter(file2, "file");
        Intrinsics.checkNotNullParameter(holder, "holder");
        Intrinsics.checkNotNullParameter(targetElement, "targetElement");
        boolean isBodyContextCollected = bodyElement != null;
        Set<PsiElement> acceptedElements = SequencesKt.toSet(PsiUtilsKt.getParentsWithSelf(targetElement));
        ContextProvider contextProvider = this.process(file2, holder, this.computeDesignation(file2, targetElement), isBodyContextCollected, arg_0 -> ContextCollector.process$lambda$0(targetElement, acceptedElements, arg_0));
        for (PsiElement acceptedElement : acceptedElements) {
            Context bodyContext;
            if (acceptedElement == bodyElement && (bodyContext = contextProvider.get(acceptedElement, ContextKind.BODY)) != null) {
                return bodyContext;
            }
            Context elementContext = contextProvider.get(acceptedElement, ContextKind.SELF);
            if (elementContext == null) continue;
            return elementContext;
        }
        return null;
    }

    public static /* synthetic */ Context process$default(ContextCollector contextCollector2, FirFile firFile, SessionHolder sessionHolder, PsiElement psiElement, PsiElement psiElement2, int n, Object object) {
        if ((n & 8) != 0) {
            psiElement2 = psiElement;
        }
        return contextCollector2.process(firFile, sessionHolder, psiElement, psiElement2);
    }

    @Nullable
    public final FirDesignation computeDesignation(@NotNull FirFile file2, @NotNull PsiElement targetElement) {
        FirDesignation designationPath;
        Intrinsics.checkNotNullParameter(file2, "file");
        Intrinsics.checkNotNullParameter(targetElement, "targetElement");
        KtDeclaration contextKtDeclaration2 = FirElementBuilderKt.getNonLocalContainingOrThisDeclaration(targetElement, (Function1<? super KtDeclaration, Boolean>)new Function1<KtDeclaration, Boolean>((Object)this){

            public final Boolean invoke(KtDeclaration p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return ContextCollector.access$isValidTarget((ContextCollector)this.receiver, p0);
            }
        });
        if (contextKtDeclaration2 != null && (designationPath = FirElementFinder.Companion.collectDesignationPath(file2, contextKtDeclaration2)) != null) {
            return designationPath;
        }
        return null;
    }

    private final boolean isValidTarget(KtDeclaration declaration) {
        if (FirElementBuilderKt.isAutonomousDeclaration(declaration)) {
            return true;
        }
        return declaration instanceof KtParameter && KtPsiUtilKt.isPropertyParameter((KtParameter)declaration);
    }

    @NotNull
    public final ContextProvider process(@NotNull FirFile file2, @NotNull SessionHolder holder, @Nullable FirDesignation designation, boolean shouldCollectBodyContext, @NotNull Function1<? super PsiElement, ? extends FilterResponse> filter2) {
        DesignationInterceptor designationInterceptor;
        Intrinsics.checkNotNullParameter(file2, "file");
        Intrinsics.checkNotNullParameter(holder, "holder");
        Intrinsics.checkNotNullParameter(filter2, "filter");
        FirDesignation firDesignation = designation;
        if (firDesignation != null) {
            FirDesignation p0 = firDesignation;
            boolean bl = false;
            designationInterceptor = new DesignationInterceptor(p0);
        } else {
            designationInterceptor = null;
        }
        DesignationInterceptor interceptor = designationInterceptor;
        ContextCollectorVisitor visitor2 = new ContextCollectorVisitor(holder, shouldCollectBodyContext, filter2, interceptor);
        visitor2.collect(file2);
        return (arg_0, arg_1) -> ContextCollector.process$lambda$1(visitor2, arg_0, arg_1);
    }

    private static final FilterResponse process$lambda$0(PsiElement $targetElement, Set $acceptedElements, PsiElement candidate) {
        Intrinsics.checkNotNullParameter(candidate, "candidate");
        PsiElement psiElement = candidate;
        return Intrinsics.areEqual(psiElement, $targetElement) ? FilterResponse.STOP : ($acceptedElements.contains(psiElement) ? FilterResponse.CONTINUE : FilterResponse.SKIP);
    }

    private static final Context process$lambda$1(ContextCollectorVisitor $visitor, PsiElement element, ContextKind kind) {
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter((Object)kind, "kind");
        return $visitor.get(element, kind);
    }

    public static final /* synthetic */ boolean access$isValidTarget(ContextCollector $this, KtDeclaration declaration) {
        return $this.isValidTarget(declaration);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004\u00a2\u0006\u0004\b\t\u0010\nR\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u000b\u001a\u0004\b\f\u0010\rR,\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\b\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/util/ContextCollector$Context;", "", "Lorg/jetbrains/kotlin/fir/declarations/FirTowerDataContext;", "towerDataContext", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/RealVariable;", "", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "smartCasts", "<init>", "(Lorg/jetbrains/kotlin/fir/declarations/FirTowerDataContext;Ljava/util/Map;)V", "Lorg/jetbrains/kotlin/fir/declarations/FirTowerDataContext;", "getTowerDataContext", "()Lorg/jetbrains/kotlin/fir/declarations/FirTowerDataContext;", "Ljava/util/Map;", "getSmartCasts", "()Ljava/util/Map;"})
    public static final class Context {
        @NotNull
        private final FirTowerDataContext towerDataContext;
        @NotNull
        private final Map<RealVariable, Set<ConeKotlinType>> smartCasts;

        public Context(@NotNull FirTowerDataContext towerDataContext, @NotNull Map<RealVariable, ? extends Set<? extends ConeKotlinType>> smartCasts) {
            Intrinsics.checkNotNullParameter(towerDataContext, "towerDataContext");
            Intrinsics.checkNotNullParameter(smartCasts, "smartCasts");
            this.towerDataContext = towerDataContext;
            this.smartCasts = smartCasts;
        }

        @NotNull
        public final FirTowerDataContext getTowerDataContext() {
            return this.towerDataContext;
        }

        @NotNull
        public final Map<RealVariable, Set<ConeKotlinType>> getSmartCasts() {
            return this.smartCasts;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/util/ContextCollector$ContextKind;", "", "<init>", "(Ljava/lang/String;I)V", "SELF", "BODY"})
    public static final class ContextKind
    extends Enum<ContextKind> {
        public static final /* enum */ ContextKind SELF = new ContextKind();
        public static final /* enum */ ContextKind BODY = new ContextKind();
        private static final /* synthetic */ ContextKind[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ContextKind[] values() {
            return (ContextKind[])$VALUES.clone();
        }

        public static ContextKind valueOf(String value2) {
            return Enum.valueOf(ContextKind.class, value2);
        }

        @NotNull
        public static EnumEntries<ContextKind> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = contextKindArray = new ContextKind[]{ContextKind.SELF, ContextKind.BODY};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\"\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u00a7\u0002\u00a2\u0006\u0004\b\u0007\u0010\b\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/util/ContextCollector$ContextProvider;", "", "Lcom/intellij/psi/PsiElement;", "element", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/util/ContextCollector$ContextKind;", "kind", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/util/ContextCollector$Context;", "get", "(Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/analysis/low/level/api/fir/util/ContextCollector$ContextKind;)Lorg/jetbrains/kotlin/analysis/low/level/api/fir/util/ContextCollector$Context;"})
    public static interface ContextProvider {
        @Nullable
        public Context get(@NotNull PsiElement var1, @NotNull ContextKind var2);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/util/ContextCollector$FilterResponse;", "", "<init>", "(Ljava/lang/String;I)V", "CONTINUE", "STOP", "SKIP"})
    public static final class FilterResponse
    extends Enum<FilterResponse> {
        public static final /* enum */ FilterResponse CONTINUE = new FilterResponse();
        public static final /* enum */ FilterResponse STOP = new FilterResponse();
        public static final /* enum */ FilterResponse SKIP = new FilterResponse();
        private static final /* synthetic */ FilterResponse[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static FilterResponse[] values() {
            return (FilterResponse[])$VALUES.clone();
        }

        public static FilterResponse valueOf(String value2) {
            return Enum.valueOf(FilterResponse.class, value2);
        }

        @NotNull
        public static EnumEntries<FilterResponse> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = filterResponseArray = new FilterResponse[]{FilterResponse.CONTINUE, FilterResponse.STOP, FilterResponse.SKIP};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

