/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.util;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.low.level.api.fir.util.ExceptionUtilsKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.diagnostics.FirDiagnosticHolder;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a3\u0010\u0006\u001a\u00028\u0000\"\u0004\b\u0000\u0010\u0000*\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00022\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a\u0010\u0010\t\u001a\u00020\bH\u0080\b\u00a2\u0006\u0004\b\t\u0010\n\u001a\u0013\u0010\r\u001a\u00020\f*\u00020\u000bH\u0000\u00a2\u0006\u0004\b\r\u0010\u000e\"\u0018\u0010\u0010\u001a\u00020\f*\u00020\u000f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\"\u0018\u0010\u0015\u001a\u00020\u000b*\u00020\u00128AX\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\"\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u0016*\u00020\u00128AX\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u0082\u0002\u0007\n\u0005\b\u009920\u0001"}, d2={"T", "Ljava/util/concurrent/locks/Lock;", "", "lockingIntervalMs", "Lkotlin/Function0;", "action", "lockWithPCECheck", "(Ljava/util/concurrent/locks/Lock;JLkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "", "checkCanceled", "()V", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "", "isNonAnonymousClassOrObject", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;)Z", "Lorg/jetbrains/kotlin/fir/FirElement;", "isErrorElement", "(Lorg/jetbrains/kotlin/fir/FirElement;)Z", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "getKtDeclaration", "(Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)Lorg/jetbrains/kotlin/psi/KtDeclaration;", "ktDeclaration", "Lorg/jetbrains/kotlin/psi/KtFile;", "getContainingKtFileIfAny", "(Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)Lorg/jetbrains/kotlin/psi/KtFile;", "containingKtFileIfAny"})
public final class UtilsKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T lockWithPCECheck(@NotNull Lock $this$lockWithPCECheck, long lockingIntervalMs, @NotNull Function0<? extends T> action) {
        boolean $i$f$checkCanceled;
        Intrinsics.checkNotNullParameter($this$lockWithPCECheck, "<this>");
        Intrinsics.checkNotNullParameter(action, "action");
        boolean $i$f$lockWithPCECheck = false;
        do {
            $i$f$checkCanceled = false;
            ProgressManager.checkCanceled();
        } while (!$this$lockWithPCECheck.tryLock(lockingIntervalMs, TimeUnit.MILLISECONDS));
        try {
            $i$f$checkCanceled = false;
            ProgressManager.checkCanceled();
            T t = action.invoke();
            return t;
        }
        finally {
            InlineMarker.finallyStart(1);
            $this$lockWithPCECheck.unlock();
            InlineMarker.finallyEnd(1);
        }
    }

    public static final void checkCanceled() {
        boolean $i$f$checkCanceled = false;
        ProgressManager.checkCanceled();
    }

    public static final boolean isErrorElement(@NotNull FirElement $this$isErrorElement) {
        Intrinsics.checkNotNullParameter($this$isErrorElement, "<this>");
        return $this$isErrorElement instanceof FirDiagnosticHolder;
    }

    @NotNull
    public static final KtDeclaration getKtDeclaration(@NotNull FirDeclaration $this$ktDeclaration) {
        KtDeclaration ktDeclaration;
        Intrinsics.checkNotNullParameter($this$ktDeclaration, "<this>");
        PsiElement psiElement = org.jetbrains.kotlin.fir.UtilsKt.getPsi($this$ktDeclaration);
        if (psiElement == null) {
            ExceptionUtilsKt.errorWithFirSpecificEntries$default("PSI element was not found", null, $this$ktDeclaration, null, null, null, 58, null);
            throw new KotlinNothingValueException();
        }
        PsiElement psi = psiElement;
        PsiElement psiElement2 = psi;
        if (psiElement2 instanceof KtDeclaration) {
            ktDeclaration = (KtDeclaration)psi;
        } else if (psiElement2 instanceof KtObjectLiteralExpression) {
            KtObjectDeclaration ktObjectDeclaration = ((KtObjectLiteralExpression)psi).getObjectDeclaration();
            Intrinsics.checkNotNullExpressionValue(ktObjectDeclaration, "getObjectDeclaration(...)");
            ktDeclaration = ktObjectDeclaration;
        } else {
            ExceptionUtilsKt.errorWithFirSpecificEntries$default("FirDeclaration.psi (" + Reflection.getOrCreateKotlinClass($this$ktDeclaration.getClass()).getSimpleName() + ") should be KtDeclaration but was " + Reflection.getOrCreateKotlinClass(psi.getClass()).getSimpleName(), null, $this$ktDeclaration, null, psi, null, 42, null);
            throw new KotlinNothingValueException();
        }
        return ktDeclaration;
    }

    @Nullable
    public static final KtFile getContainingKtFileIfAny(@NotNull FirDeclaration $this$containingKtFileIfAny) {
        Intrinsics.checkNotNullParameter($this$containingKtFileIfAny, "<this>");
        PsiElement psiElement = org.jetbrains.kotlin.fir.UtilsKt.getPsi($this$containingKtFileIfAny);
        PsiFile psiFile = psiElement != null ? psiElement.getContainingFile() : null;
        return psiFile instanceof KtFile ? (KtFile)psiFile : null;
    }

    public static final boolean isNonAnonymousClassOrObject(@NotNull KtDeclaration $this$isNonAnonymousClassOrObject) {
        Intrinsics.checkNotNullParameter($this$isNonAnonymousClassOrObject, "<this>");
        return $this$isNonAnonymousClassOrObject instanceof KtClassOrObject && !KtPsiUtilKt.isObjectLiteral((KtClassOrObject)$this$isNonAnonymousClassOrObject);
    }
}

