/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.project.structure.builder;

import com.intellij.mock.MockProject;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaLibraryModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaLibrarySourceModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.analysis.api.standalone.base.projectStructure.StandaloneProjectFactory;
import org.jetbrains.kotlin.analysis.project.structure.builder.KtBinaryModuleBuilder;
import org.jetbrains.kotlin.analysis.project.structure.impl.KaLibraryModuleImpl;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreProjectEnvironment;
import org.jetbrains.kotlin.platform.TargetPlatform;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0017\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\tH\u0005\u00a2\u0006\u0004\b\u0007\u0010\u000bR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\fR\"\u0010\u000e\u001a\u00020\r8\u0007@\u0006X\u0087.\u00a2\u0006\u0012\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R$\u0010\u0015\u001a\u0004\u0018\u00010\u00148\u0007@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a"}, d2={"Lorg/jetbrains/kotlin/analysis/project/structure/builder/KtLibraryModuleBuilder;", "Lorg/jetbrains/kotlin/analysis/project/structure/builder/KtBinaryModuleBuilder;", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreProjectEnvironment;", "kotlinCoreProjectEnvironment", "<init>", "(Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreProjectEnvironment;)V", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaLibraryModule;", "build", "()Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaLibraryModule;", "", "isSdk", "(Z)Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaLibraryModule;", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreProjectEnvironment;", "", "libraryName", "Ljava/lang/String;", "getLibraryName", "()Ljava/lang/String;", "setLibraryName", "(Ljava/lang/String;)V", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaLibrarySourceModule;", "librarySources", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaLibrarySourceModule;", "getLibrarySources", "()Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaLibrarySourceModule;", "setLibrarySources", "(Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaLibrarySourceModule;)V"})
public class KtLibraryModuleBuilder
extends KtBinaryModuleBuilder {
    @NotNull
    private final KotlinCoreProjectEnvironment kotlinCoreProjectEnvironment;
    public String libraryName;
    @Nullable
    private KaLibrarySourceModule librarySources;

    public KtLibraryModuleBuilder(@NotNull KotlinCoreProjectEnvironment kotlinCoreProjectEnvironment) {
        Intrinsics.checkNotNullParameter(kotlinCoreProjectEnvironment, "kotlinCoreProjectEnvironment");
        this.kotlinCoreProjectEnvironment = kotlinCoreProjectEnvironment;
    }

    @NotNull
    public final String getLibraryName() {
        String string2 = this.libraryName;
        if (string2 != null) {
            return string2;
        }
        Intrinsics.throwUninitializedPropertyAccessException("libraryName");
        return null;
    }

    public final void setLibraryName(@NotNull String string2) {
        Intrinsics.checkNotNullParameter(string2, "<set-?>");
        this.libraryName = string2;
    }

    @Nullable
    public final KaLibrarySourceModule getLibrarySources() {
        return this.librarySources;
    }

    public final void setLibrarySources(@Nullable KaLibrarySourceModule kaLibrarySourceModule) {
        this.librarySources = kaLibrarySourceModule;
    }

    @Override
    @NotNull
    public KaLibraryModule build() {
        return this.build(false);
    }

    @NotNull
    protected final KaLibraryModule build(boolean isSdk) {
        List<Path> binaryRoots = this.getBinaryRoots();
        List<VirtualFile> binaryVirtualFiles = this.getBinaryVirtualFiles();
        GlobalSearchScope contentScope = StandaloneProjectFactory.INSTANCE.createSearchScopeByLibraryRoots((Collection<? extends Path>)binaryRoots, (Collection<? extends VirtualFile>)binaryVirtualFiles, this.kotlinCoreProjectEnvironment);
        List<KaModule> list = this.getDirectRegularDependencies();
        List<KaModule> list2 = this.getDirectDependsOnDependencies();
        List<KaModule> list3 = this.getDirectFriendDependencies();
        TargetPlatform targetPlatform = this.getPlatform();
        MockProject mockProject = this.kotlinCoreProjectEnvironment.getProject();
        Intrinsics.checkNotNullExpressionValue(mockProject, "getProject(...)");
        return new KaLibraryModuleImpl(list, list2, list3, contentScope, targetPlatform, mockProject, (Collection<? extends Path>)binaryRoots, (Collection<? extends VirtualFile>)binaryVirtualFiles, this.getLibraryName(), this.librarySources, isSdk);
    }
}

