/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.project.structure.builder;

import com.intellij.mock.MockProject;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.analysis.api.standalone.base.projectStructure.KotlinStaticProjectStructureProvider;
import org.jetbrains.kotlin.analysis.project.structure.impl.KotlinStandaloneProjectStructureProvider;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreProjectEnvironment;
import org.jetbrains.kotlin.platform.TargetPlatform;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J!\u0010\t\u001a\u00028\u0000\"\b\b\u0000\u0010\u0007*\u00020\u00062\u0006\u0010\b\u001a\u00028\u0000H\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\f\u001a\u00020\u000bH\u0007\u00a2\u0006\u0004\b\f\u0010\rR\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u00118\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\"\u0010\u0015\u001a\u00020\u00148\u0007@\u0006X\u0087.\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a"}, d2={"Lorg/jetbrains/kotlin/analysis/project/structure/builder/KtModuleProviderBuilder;", "", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreProjectEnvironment;", "kotlinCoreProjectEnvironment", "<init>", "(Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreProjectEnvironment;)V", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "M", "module", "addModule", "(Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;)Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "Lorg/jetbrains/kotlin/analysis/api/standalone/base/projectStructure/KotlinStaticProjectStructureProvider;", "build", "()Lorg/jetbrains/kotlin/analysis/api/standalone/base/projectStructure/KotlinStaticProjectStructureProvider;", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreProjectEnvironment;", "getKotlinCoreProjectEnvironment", "()Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreProjectEnvironment;", "", "mainModules", "Ljava/util/List;", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "platform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getPlatform", "()Lorg/jetbrains/kotlin/platform/TargetPlatform;", "setPlatform", "(Lorg/jetbrains/kotlin/platform/TargetPlatform;)V"})
public final class KtModuleProviderBuilder {
    @NotNull
    private final KotlinCoreProjectEnvironment kotlinCoreProjectEnvironment;
    @NotNull
    private final List<KaModule> mainModules;
    public TargetPlatform platform;

    public KtModuleProviderBuilder(@NotNull KotlinCoreProjectEnvironment kotlinCoreProjectEnvironment) {
        Intrinsics.checkNotNullParameter(kotlinCoreProjectEnvironment, "kotlinCoreProjectEnvironment");
        this.kotlinCoreProjectEnvironment = kotlinCoreProjectEnvironment;
        this.mainModules = new ArrayList();
    }

    @NotNull
    public final KotlinCoreProjectEnvironment getKotlinCoreProjectEnvironment() {
        return this.kotlinCoreProjectEnvironment;
    }

    @NotNull
    public final <M extends KaModule> M addModule(@NotNull M module2) {
        Intrinsics.checkNotNullParameter(module2, "module");
        this.mainModules.add(module2);
        return module2;
    }

    @NotNull
    public final TargetPlatform getPlatform() {
        TargetPlatform targetPlatform = this.platform;
        if (targetPlatform != null) {
            return targetPlatform;
        }
        Intrinsics.throwUninitializedPropertyAccessException("platform");
        return null;
    }

    public final void setPlatform(@NotNull TargetPlatform targetPlatform) {
        Intrinsics.checkNotNullParameter(targetPlatform, "<set-?>");
        this.platform = targetPlatform;
    }

    @NotNull
    public final KotlinStaticProjectStructureProvider build() {
        TargetPlatform targetPlatform = this.getPlatform();
        MockProject mockProject = this.kotlinCoreProjectEnvironment.getProject();
        Intrinsics.checkNotNullExpressionValue(mockProject, "getProject(...)");
        return new KotlinStandaloneProjectStructureProvider(targetPlatform, mockProject, this.mainModules);
    }
}

