/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.project.structure.builder;

import com.intellij.mock.MockProject;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.local.CoreLocalFileSystem;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaSourceModule;
import org.jetbrains.kotlin.analysis.project.structure.builder.KtModuleBuilder;
import org.jetbrains.kotlin.analysis.project.structure.impl.KaModuleUtilsKt;
import org.jetbrains.kotlin.analysis.project.structure.impl.KaSourceModuleImpl;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreProjectEnvironment;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.config.LanguageVersionSettingsImpl;
import org.jetbrains.kotlin.platform.TargetPlatform;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u001b\u0010\r\u001a\u00020\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0015\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001b\u0010\u0014\u001a\u00020\b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000b\u00a2\u0006\u0004\b\u0014\u0010\u000eJ\u000f\u0010\u0016\u001a\u00020\u0015H\u0017\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0015\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0018H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001bR\"\u0010\u001d\u001a\u00020\u001c8\u0007@\u0006X\u0087.\u00a2\u0006\u0012\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\"\u0010$\u001a\u00020#8\u0007@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b$\u0010%\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001a\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00060*8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b+\u0010,R\u001a\u0010-\u001a\b\u0012\u0004\u0012\u00020\u000f0*8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b-\u0010,"}, d2={"Lorg/jetbrains/kotlin/analysis/project/structure/builder/KtSourceModuleBuilder;", "Lorg/jetbrains/kotlin/analysis/project/structure/builder/KtModuleBuilder;", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreProjectEnvironment;", "kotlinCoreProjectEnvironment", "<init>", "(Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreProjectEnvironment;)V", "Ljava/nio/file/Path;", "path", "", "addSourceRoot", "(Ljava/nio/file/Path;)V", "", "paths", "addSourceRoots", "(Ljava/util/Collection;)V", "Lcom/intellij/openapi/vfs/VirtualFile;", "virtualFile", "addSourceVirtualFile", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "virtualFiles", "addSourceVirtualFiles", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaSourceModule;", "build", "()Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaSourceModule;", "", "collectVirtualFilesByRoots", "()Ljava/util/List;", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreProjectEnvironment;", "", "moduleName", "Ljava/lang/String;", "getModuleName", "()Ljava/lang/String;", "setModuleName", "(Ljava/lang/String;)V", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "getLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "setLanguageVersionSettings", "(Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "", "sourceRoots", "Ljava/util/List;", "sourceVirtualFiles"})
public final class KtSourceModuleBuilder
extends KtModuleBuilder {
    @NotNull
    private final KotlinCoreProjectEnvironment kotlinCoreProjectEnvironment;
    public String moduleName;
    @NotNull
    private LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final List<Path> sourceRoots;
    @NotNull
    private final List<VirtualFile> sourceVirtualFiles;

    public KtSourceModuleBuilder(@NotNull KotlinCoreProjectEnvironment kotlinCoreProjectEnvironment) {
        Intrinsics.checkNotNullParameter(kotlinCoreProjectEnvironment, "kotlinCoreProjectEnvironment");
        this.kotlinCoreProjectEnvironment = kotlinCoreProjectEnvironment;
        this.languageVersionSettings = new LanguageVersionSettingsImpl(LanguageVersion.LATEST_STABLE, ApiVersion.LATEST, null, null, 12, null);
        this.sourceRoots = new ArrayList();
        this.sourceVirtualFiles = new ArrayList();
    }

    @NotNull
    public final String getModuleName() {
        String string2 = this.moduleName;
        if (string2 != null) {
            return string2;
        }
        Intrinsics.throwUninitializedPropertyAccessException("moduleName");
        return null;
    }

    public final void setModuleName(@NotNull String string2) {
        Intrinsics.checkNotNullParameter(string2, "<set-?>");
        this.moduleName = string2;
    }

    @NotNull
    public final LanguageVersionSettings getLanguageVersionSettings() {
        return this.languageVersionSettings;
    }

    public final void setLanguageVersionSettings(@NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter(languageVersionSettings, "<set-?>");
        this.languageVersionSettings = languageVersionSettings;
    }

    public final void addSourceRoot(@NotNull Path path) {
        Intrinsics.checkNotNullParameter(path, "path");
        this.sourceRoots.add(path);
    }

    public final void addSourceRoots(@NotNull Collection<? extends Path> paths2) {
        Intrinsics.checkNotNullParameter(paths2, "paths");
        this.sourceRoots.addAll(paths2);
    }

    public final void addSourceVirtualFile(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter(virtualFile, "virtualFile");
        this.sourceVirtualFiles.add(virtualFile);
    }

    public final void addSourceVirtualFiles(@NotNull Collection<? extends VirtualFile> virtualFiles) {
        Intrinsics.checkNotNullParameter(virtualFiles, "virtualFiles");
        this.sourceVirtualFiles.addAll(virtualFiles);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public KaSourceModule build() {
        void $this$mapNotNullTo$iv$iv;
        List<VirtualFile> virtualFiles = this.collectVirtualFilesByRoots();
        PsiManager psiManager = PsiManager.getInstance(this.kotlinCoreProjectEnvironment.getProject());
        Intrinsics.checkNotNullExpressionValue(psiManager, "getInstance(...)");
        PsiManager psiManager2 = psiManager;
        Iterable $this$mapNotNull$iv = virtualFiles;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            PsiFile it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl2 = false;
            if (psiManager2.findFile(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List psiFiles = (List)destination$iv$iv;
        GlobalSearchScope globalSearchScope = GlobalSearchScope.filesScope((Project)this.kotlinCoreProjectEnvironment.getProject(), (Collection<? extends VirtualFile>)virtualFiles);
        Intrinsics.checkNotNullExpressionValue(globalSearchScope, "filesScope(...)");
        GlobalSearchScope contentScope = globalSearchScope;
        List<KaModule> list = this.getDirectRegularDependencies();
        List<KaModule> list2 = this.getDirectDependsOnDependencies();
        List<KaModule> list3 = this.getDirectFriendDependencies();
        TargetPlatform targetPlatform = this.getPlatform();
        MockProject mockProject = this.kotlinCoreProjectEnvironment.getProject();
        Intrinsics.checkNotNullExpressionValue(mockProject, "getProject(...)");
        return new KaSourceModuleImpl(list, list2, list3, contentScope, targetPlatform, mockProject, this.getModuleName(), this.languageVersionSettings, psiFiles);
    }

    private final List<VirtualFile> collectVirtualFilesByRoots() {
        List<VirtualFile> list;
        CoreLocalFileSystem coreLocalFileSystem = this.kotlinCoreProjectEnvironment.getEnvironment().getLocalFileSystem();
        Intrinsics.checkNotNullExpressionValue(coreLocalFileSystem, "getLocalFileSystem(...)");
        CoreLocalFileSystem localFileSystem = coreLocalFileSystem;
        List<VirtualFile> $this$collectVirtualFilesByRoots_u24lambda_u242 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        for (Path root : this.sourceRoots) {
            LinkOption[] linkOptionArray = new LinkOption[]{};
            List<Path> files2 = Files.isDirectory(root, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? KaModuleUtilsKt.collectSourceFilePaths(root) : (KaModuleUtilsKt.hasSuitableExtensionToAnalyse(root) ? CollectionsKt.listOf(root) : CollectionsKt.emptyList());
            for (Path file2 : files2) {
                VirtualFile virtualFile;
                if (localFileSystem.findFileByNioFile(file2.toAbsolutePath()) == null) continue;
                $this$collectVirtualFilesByRoots_u24lambda_u242.add(virtualFile);
            }
        }
        $this$collectVirtualFilesByRoots_u24lambda_u242.addAll((Collection)this.sourceVirtualFiles);
        List<VirtualFile> $this$sortBy$iv = $this$collectVirtualFilesByRoots_u24lambda_u242;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith($this$sortBy$iv, new Comparator(){

                public final int compare(T a, T b) {
                    VirtualFile it = (VirtualFile)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getPath());
                    it = (VirtualFile)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it.getPath()));
                }
            });
        }
        return CollectionsKt.build(list);
    }
}

