/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analyzer;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.CompilationErrorException;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.types.error.ErrorUtils;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u0003\n\u0002\b\u0006\b\u0016\u0018\u0000 $2\u00020\u0001:\u0003%&$B#\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\u000b\u001a\u00020\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u0096\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u0002H\u0087\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u0004H\u0087\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u0006H\u0086\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\r\u0010\u0016\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0016\u0010\u0015J\r\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001a\u001a\u0004\b\u001b\u0010\u0011R\u001a\u0010\u0005\u001a\u00020\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001c\u001a\u0004\b\u001d\u0010\u0013R\u001a\u0010\u0007\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010\u001e\u001a\u0004\b\u001f\u0010\u0015R\u0011\u0010#\u001a\u00020 8G\u00a2\u0006\u0006\u001a\u0004\b!\u0010\""}, d2={"Lorg/jetbrains/kotlin/analyzer/AnalysisResult;", "", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "bindingContext", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "moduleDescriptor", "", "shouldGenerateCode", "<init>", "(Lorg/jetbrains/kotlin/resolve/BindingContext;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Z)V", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "component1", "()Lorg/jetbrains/kotlin/resolve/BindingContext;", "component2", "()Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "component3", "()Z", "isError", "", "throwIfError", "()V", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "getBindingContext", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "getModuleDescriptor", "Z", "getShouldGenerateCode", "", "getError", "()Ljava/lang/Throwable;", "error", "Companion", "CompilationError", "InternalError"})
public class AnalysisResult {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BindingContext bindingContext;
    @NotNull
    private final ModuleDescriptor moduleDescriptor;
    private final boolean shouldGenerateCode;
    @NotNull
    private static final AnalysisResult EMPTY;

    protected AnalysisResult(@NotNull BindingContext bindingContext, @NotNull ModuleDescriptor moduleDescriptor, boolean shouldGenerateCode) {
        Intrinsics.checkNotNullParameter(bindingContext, "bindingContext");
        Intrinsics.checkNotNullParameter(moduleDescriptor, "moduleDescriptor");
        this.bindingContext = bindingContext;
        this.moduleDescriptor = moduleDescriptor;
        this.shouldGenerateCode = shouldGenerateCode;
    }

    public /* synthetic */ AnalysisResult(BindingContext bindingContext, ModuleDescriptor moduleDescriptor, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = true;
        }
        this(bindingContext, moduleDescriptor, bl);
    }

    @NotNull
    public final BindingContext getBindingContext() {
        return this.bindingContext;
    }

    @NotNull
    public final ModuleDescriptor getModuleDescriptor() {
        return this.moduleDescriptor;
    }

    public final boolean getShouldGenerateCode() {
        return this.shouldGenerateCode;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof AnalysisResult && Intrinsics.areEqual(this.bindingContext, ((AnalysisResult)other).bindingContext) && Intrinsics.areEqual(this.moduleDescriptor, ((AnalysisResult)other).moduleDescriptor) && this.shouldGenerateCode == ((AnalysisResult)other).shouldGenerateCode;
    }

    public int hashCode() {
        int result2 = 17;
        result2 = 29 * result2 + this.bindingContext.hashCode();
        result2 = 29 * result2 + this.moduleDescriptor.hashCode();
        result2 = 29 * result2 + Boolean.hashCode(this.shouldGenerateCode);
        return result2;
    }

    @NotNull
    public final BindingContext component1() {
        return this.bindingContext;
    }

    @NotNull
    public final ModuleDescriptor component2() {
        return this.moduleDescriptor;
    }

    public final boolean component3() {
        return this.shouldGenerateCode;
    }

    @NotNull
    public final Throwable getError() {
        if (!(this instanceof InternalError)) {
            throw new IllegalStateException("Should only be called for error analysis result");
        }
        return ((InternalError)this).getException();
    }

    public final boolean isError() {
        return this instanceof InternalError || this instanceof CompilationError;
    }

    public final void throwIfError() {
        AnalysisResult analysisResult = this;
        if (analysisResult instanceof InternalError) {
            throw new IllegalStateException("failed to analyze: " + this.getError(), this.getError());
        }
        if (analysisResult instanceof CompilationError) {
            throw new CompilationErrorException();
        }
    }

    @NotNull
    public static final AnalysisResult success(@NotNull BindingContext bindingContext, @NotNull ModuleDescriptor module2) {
        return Companion.success(bindingContext, module2);
    }

    @NotNull
    public static final AnalysisResult success(@NotNull BindingContext bindingContext, @NotNull ModuleDescriptor module2, boolean shouldGenerateCode) {
        return Companion.success(bindingContext, module2, shouldGenerateCode);
    }

    @NotNull
    public static final AnalysisResult internalError(@NotNull BindingContext bindingContext, @NotNull Throwable error) {
        return Companion.internalError(bindingContext, error);
    }

    @NotNull
    public static final AnalysisResult compilationError(@NotNull BindingContext bindingContext) {
        return Companion.compilationError(bindingContext);
    }

    static {
        BindingContext bindingContext = BindingContext.EMPTY;
        Intrinsics.checkNotNullExpressionValue(bindingContext, "EMPTY");
        EMPTY = Companion.success(bindingContext, ErrorUtils.INSTANCE.getErrorModule());
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\t\u0010\nJ'\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u000bH\u0007\u00a2\u0006\u0004\b\t\u0010\rJ\u001f\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u000eH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\b8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017"}, d2={"Lorg/jetbrains/kotlin/analyzer/AnalysisResult$Companion;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "bindingContext", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "module", "Lorg/jetbrains/kotlin/analyzer/AnalysisResult;", "success", "(Lorg/jetbrains/kotlin/resolve/BindingContext;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;)Lorg/jetbrains/kotlin/analyzer/AnalysisResult;", "", "shouldGenerateCode", "(Lorg/jetbrains/kotlin/resolve/BindingContext;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Z)Lorg/jetbrains/kotlin/analyzer/AnalysisResult;", "", "error", "internalError", "(Lorg/jetbrains/kotlin/resolve/BindingContext;Ljava/lang/Throwable;)Lorg/jetbrains/kotlin/analyzer/AnalysisResult;", "compilationError", "(Lorg/jetbrains/kotlin/resolve/BindingContext;)Lorg/jetbrains/kotlin/analyzer/AnalysisResult;", "EMPTY", "Lorg/jetbrains/kotlin/analyzer/AnalysisResult;", "getEMPTY", "()Lorg/jetbrains/kotlin/analyzer/AnalysisResult;"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AnalysisResult getEMPTY() {
            return EMPTY;
        }

        @NotNull
        public final AnalysisResult success(@NotNull BindingContext bindingContext, @NotNull ModuleDescriptor module2) {
            Intrinsics.checkNotNullParameter(bindingContext, "bindingContext");
            Intrinsics.checkNotNullParameter(module2, "module");
            return new AnalysisResult(bindingContext, module2, true);
        }

        @NotNull
        public final AnalysisResult success(@NotNull BindingContext bindingContext, @NotNull ModuleDescriptor module2, boolean shouldGenerateCode) {
            Intrinsics.checkNotNullParameter(bindingContext, "bindingContext");
            Intrinsics.checkNotNullParameter(module2, "module");
            return new AnalysisResult(bindingContext, module2, shouldGenerateCode);
        }

        @NotNull
        public final AnalysisResult internalError(@NotNull BindingContext bindingContext, @NotNull Throwable error) {
            Intrinsics.checkNotNullParameter(bindingContext, "bindingContext");
            Intrinsics.checkNotNullParameter(error, "error");
            return new InternalError(bindingContext, error);
        }

        @NotNull
        public final AnalysisResult compilationError(@NotNull BindingContext bindingContext) {
            Intrinsics.checkNotNullParameter(bindingContext, "bindingContext");
            return new CompilationError(bindingContext);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005"}, d2={"Lorg/jetbrains/kotlin/analyzer/AnalysisResult$CompilationError;", "Lorg/jetbrains/kotlin/analyzer/AnalysisResult;", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "bindingContext", "<init>", "(Lorg/jetbrains/kotlin/resolve/BindingContext;)V"})
    private static final class CompilationError
    extends AnalysisResult {
        public CompilationError(@NotNull BindingContext bindingContext) {
            Intrinsics.checkNotNullParameter(bindingContext, "bindingContext");
            super(bindingContext, ErrorUtils.INSTANCE.getErrorModule(), false, 4, null);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u001a\u0010\u0005\u001a\u00020\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\b\u001a\u0004\b\t\u0010\n"}, d2={"Lorg/jetbrains/kotlin/analyzer/AnalysisResult$InternalError;", "Lorg/jetbrains/kotlin/analyzer/AnalysisResult;", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "bindingContext", "", "exception", "<init>", "(Lorg/jetbrains/kotlin/resolve/BindingContext;Ljava/lang/Throwable;)V", "Ljava/lang/Throwable;", "getException", "()Ljava/lang/Throwable;"})
    private static final class InternalError
    extends AnalysisResult {
        @NotNull
        private final Throwable exception;

        public InternalError(@NotNull BindingContext bindingContext, @NotNull Throwable exception) {
            Intrinsics.checkNotNullParameter(bindingContext, "bindingContext");
            Intrinsics.checkNotNullParameter(exception, "exception");
            super(bindingContext, ErrorUtils.INSTANCE.getErrorModule(), false, 4, null);
            this.exception = exception;
        }

        @NotNull
        public final Throwable getException() {
            return this.exception;
        }
    }
}

