/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava.classes;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.classes.LightClassUtilsKt$shouldNotBeVisibleAsLightClass$;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtDeclarationContainer;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0015\u0010\u0002\u001a\u0004\u0018\u00010\u0001*\u00020\u0000H\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u001a\u0011\u0010\u0005\u001a\u00020\u0004*\u00020\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006\u001a\u0017\u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0000H\u0002\u00a2\u0006\u0004\b\b\u0010\u0006\u001a\u0017\u0010\t\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0000H\u0002\u00a2\u0006\u0004\b\t\u0010\u0006\u001a\u0017\u0010\f\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\f\u0010\r\u001a\u0017\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0000H\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000f"}, d2={"Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "", "defaultJavaAncestorQualifiedName", "(Lorg/jetbrains/kotlin/psi/KtClassOrObject;)Ljava/lang/String;", "", "shouldNotBeVisibleAsLightClass", "(Lorg/jetbrains/kotlin/psi/KtClassOrObject;)Z", "classOrObject", "classDeclaredInUnexpectedPosition", "isEnumEntryWithoutBody", "Lcom/intellij/psi/PsiElement;", "psi", "hasParseErrorsAround", "(Lcom/intellij/psi/PsiElement;)Z", "getOutermostClassOrObject", "(Lorg/jetbrains/kotlin/psi/KtClassOrObject;)Lorg/jetbrains/kotlin/psi/KtClassOrObject;"})
public final class LightClassUtilsKt {
    @Nullable
    public static final String defaultJavaAncestorQualifiedName(@NotNull KtClassOrObject $this$defaultJavaAncestorQualifiedName) {
        Intrinsics.checkNotNullParameter($this$defaultJavaAncestorQualifiedName, "<this>");
        if (!($this$defaultJavaAncestorQualifiedName instanceof KtClass)) {
            return "java.lang.Object";
        }
        return $this$defaultJavaAncestorQualifiedName.isAnnotation() ? "java.lang.annotation.Annotation" : (((KtClass)$this$defaultJavaAncestorQualifiedName).isEnum() ? "java.lang.Enum" : (((KtClass)$this$defaultJavaAncestorQualifiedName).isInterface() ? "java.lang.Object" : "java.lang.Object"));
    }

    public static final boolean shouldNotBeVisibleAsLightClass(@NotNull KtClassOrObject $this$shouldNotBeVisibleAsLightClass) {
        boolean bl;
        PsiFile containingFile;
        block8: {
            Intrinsics.checkNotNullParameter($this$shouldNotBeVisibleAsLightClass, "<this>");
            PsiFile psiFile = $this$shouldNotBeVisibleAsLightClass.getContainingFile();
            Intrinsics.checkNotNullExpressionValue(psiFile, "getContainingFile(...)");
            containingFile = psiFile;
            if (containingFile instanceof KtCodeFragment) {
                return true;
            }
            KtFile ktFile = containingFile instanceof KtFile ? (KtFile)containingFile : null;
            boolean bl2 = ktFile != null ? ktFile.isCompiled() : false;
            if (bl2 && Intrinsics.areEqual(((KtFile)containingFile).getVirtualFile().getExtension(), "kotlin_builtins")) {
                return true;
            }
            Sequence<PsiElement> $this$filterIsInstance$iv = PsiUtilsKt.getParentsWithSelf($this$shouldNotBeVisibleAsLightClass);
            boolean $i$f$filterIsInstance = false;
            Sequence<PsiElement> sequence2 = SequencesKt.filter($this$filterIsInstance$iv, shouldNotBeVisibleAsLightClass$$inlined$filterIsInstance$1.INSTANCE);
            Intrinsics.checkNotNull(sequence2, "null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            Sequence<PsiElement> $this$any$iv = sequence2;
            boolean $i$f$any = false;
            Iterator<PsiElement> iterator2 = $this$any$iv.iterator();
            while (iterator2.hasNext()) {
                PsiElement element$iv = iterator2.next();
                KtClassOrObject it = (KtClassOrObject)element$iv;
                boolean bl3 = false;
                if (!PsiUtilsKt.hasExpectModifier(it)) continue;
                bl = true;
                break block8;
            }
            bl = false;
        }
        if (bl) {
            return true;
        }
        if ($this$shouldNotBeVisibleAsLightClass.isLocal()) {
            if (containingFile.getVirtualFile() == null) {
                return true;
            }
            if (LightClassUtilsKt.hasParseErrorsAround($this$shouldNotBeVisibleAsLightClass) || PsiUtilCore.hasErrorElementChild($this$shouldNotBeVisibleAsLightClass)) {
                return true;
            }
            if (LightClassUtilsKt.classDeclaredInUnexpectedPosition($this$shouldNotBeVisibleAsLightClass)) {
                return true;
            }
        }
        return LightClassUtilsKt.isEnumEntryWithoutBody($this$shouldNotBeVisibleAsLightClass);
    }

    private static final boolean classDeclaredInUnexpectedPosition(KtClassOrObject classOrObject) {
        if (classOrObject instanceof KtObjectDeclaration) {
            return false;
        }
        PsiElement classParent = classOrObject.getParent();
        return !(classParent instanceof KtBlockExpression) && !(classParent instanceof KtDeclarationContainer);
    }

    private static final boolean isEnumEntryWithoutBody(KtClassOrObject classOrObject) {
        if (!(classOrObject instanceof KtEnumEntry)) {
            return false;
        }
        Object object = classOrObject.getBody();
        return object != null && (object = ((KtClassBody)object).getDeclarations()) != null ? object.isEmpty() : true;
    }

    private static final boolean hasParseErrorsAround(PsiElement psi) {
        block9: {
            block10: {
                ASTNode node;
                block7: {
                    block8: {
                        ASTNode aSTNode = psi.getNode();
                        if (aSTNode == null) {
                            return false;
                        }
                        node = aSTNode;
                        ASTNode aSTNode2 = TreeUtil.nextLeaf(node);
                        if (aSTNode2 == null) break block7;
                        ASTNode nextLeaf = aSTNode2;
                        boolean bl = false;
                        if (Intrinsics.areEqual(nextLeaf.getElementType(), TokenType.ERROR_ELEMENT)) break block8;
                        ASTNode aSTNode3 = nextLeaf.getTreePrev();
                        if (!Intrinsics.areEqual(aSTNode3 != null ? aSTNode3.getElementType() : null, TokenType.ERROR_ELEMENT)) break block7;
                    }
                    return true;
                }
                ASTNode aSTNode = TreeUtil.prevLeaf(node);
                if (aSTNode == null) break block9;
                ASTNode prevLeaf = aSTNode;
                boolean bl = false;
                if (Intrinsics.areEqual(prevLeaf.getElementType(), TokenType.ERROR_ELEMENT)) break block10;
                ASTNode aSTNode4 = prevLeaf.getTreeNext();
                if (!Intrinsics.areEqual(aSTNode4 != null ? aSTNode4.getElementType() : null, TokenType.ERROR_ELEMENT)) break block9;
            }
            return true;
        }
        return false;
    }

    @NotNull
    public static final KtClassOrObject getOutermostClassOrObject(@NotNull KtClassOrObject classOrObject) {
        Intrinsics.checkNotNullParameter(classOrObject, "classOrObject");
        KtClassOrObject ktClassOrObject = KtPsiUtil.getOutermostClassOrObject(classOrObject);
        if (ktClassOrObject == null) {
            throw new IllegalStateException("Attempt to build a light class for a local class: " + classOrObject.getText());
        }
        return ktClassOrObject;
    }
}

