/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava.elements;

import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.impl.java.stubs.ClsStubPsiFactory;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.impl.java.stubs.impl.PsiJavaFileStubImpl;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.AstLoadingFilter;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForFacade;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPackageDirective;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0017\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\u000e\u001a\u00020\rH\u0017\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0013\u001a\u00020\u0010H\u0017\u00a2\u0006\u0004\b\u0013\u0010\u0012J\u0015\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u0014H\u0017\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0017\u001a\u00020\u0002H\u0017\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u000f\u0010\u001f\u001a\u00020\u001eH\u0017\u00a2\u0006\u0004\b\u001f\u0010 J\u000f\u0010\"\u001a\u00020!H\u0017\u00a2\u0006\u0004\b\"\u0010#J\u000f\u0010%\u001a\u00020$H\u0016\u00a2\u0006\u0004\b%\u0010&J\u001a\u0010*\u001a\u00020)2\b\u0010(\u001a\u0004\u0018\u00010'H\u0096\u0002\u00a2\u0006\u0004\b*\u0010+J\u0019\u0010-\u001a\u00020)2\b\u0010,\u001a\u0004\u0018\u00010\u001eH\u0016\u00a2\u0006\u0004\b-\u0010.J\u0017\u00100\u001a\u00020\u001b2\u0006\u0010/\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b0\u00101J\u000f\u00102\u001a\u00020)H\u0016\u00a2\u0006\u0004\b2\u00103R\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u00104\u001a\u0004\b5\u0010\u0018R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u00106R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u00107R\u001e\u0010:\u001a\n\u0012\u0004\u0012\u000209\u0018\u0001088\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b:\u0010;R\u0014\u0010<\u001a\u00020'8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b<\u0010="}, d2={"Lorg/jetbrains/kotlin/asJava/elements/FakeFileForLightClass;", "Lcom/intellij/psi/impl/compiled/ClsFileImpl;", "Lorg/jetbrains/kotlin/psi/KtFile;", "ktFile", "Lorg/jetbrains/kotlin/asJava/classes/KtLightClass;", "lightClass", "Lorg/jetbrains/kotlin/name/FqName;", "packageFqName", "<init>", "(Lorg/jetbrains/kotlin/psi/KtFile;Lorg/jetbrains/kotlin/asJava/classes/KtLightClass;Lorg/jetbrains/kotlin/name/FqName;)V", "Lcom/intellij/openapi/vfs/VirtualFile;", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "", "getPackageName", "()Ljava/lang/String;", "Lcom/intellij/psi/impl/java/stubs/PsiJavaFileStub;", "createFakeJavaFileStub", "()Lcom/intellij/psi/impl/java/stubs/PsiJavaFileStub;", "getStub", "", "getClasses", "()[Lorg/jetbrains/kotlin/asJava/classes/KtLightClass;", "getNavigationElement", "()Lorg/jetbrains/kotlin/psi/KtFile;", "Lcom/intellij/psi/PsiElementVisitor;", "visitor", "", "accept", "(Lcom/intellij/psi/PsiElementVisitor;)V", "Lcom/intellij/psi/PsiElement;", "getMirror", "()Lcom/intellij/psi/PsiElement;", "Lcom/intellij/pom/java/LanguageLevel;", "getLanguageLevel", "()Lcom/intellij/pom/java/LanguageLevel;", "", "hashCode", "()I", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "another", "isEquivalentTo", "(Lcom/intellij/psi/PsiElement;)Z", "packageName", "setPackageName", "(Ljava/lang/String;)V", "isPhysical", "()Z", "Lorg/jetbrains/kotlin/psi/KtFile;", "getKtFile", "Lorg/jetbrains/kotlin/asJava/classes/KtLightClass;", "Lorg/jetbrains/kotlin/name/FqName;", "Ljava/lang/ref/Reference;", "Lcom/intellij/psi/impl/source/tree/TreeElement;", "myMirrorFileElement", "Ljava/lang/ref/Reference;", "myMirrorLock", "Ljava/lang/Object;"})
public class FakeFileForLightClass
extends ClsFileImpl {
    @NotNull
    private final KtFile ktFile;
    @NotNull
    private final KtLightClass lightClass;
    @NotNull
    private final FqName packageFqName;
    @Nullable
    private volatile Reference<TreeElement> myMirrorFileElement;
    @NotNull
    private final Object myMirrorLock;

    public FakeFileForLightClass(@NotNull KtFile ktFile, @NotNull KtLightClass lightClass, @NotNull FqName packageFqName) {
        Intrinsics.checkNotNullParameter(ktFile, "ktFile");
        Intrinsics.checkNotNullParameter(lightClass, "lightClass");
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        super(ktFile.getViewProvider());
        this.ktFile = ktFile;
        this.lightClass = lightClass;
        this.packageFqName = packageFqName;
        this.myMirrorLock = new Object();
    }

    public /* synthetic */ FakeFileForLightClass(KtFile ktFile, KtLightClass ktLightClass, FqName fqName2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            fqName2 = ktFile.getPackageFqName();
        }
        this(ktFile, ktLightClass, fqName2);
    }

    @NotNull
    public final KtFile getKtFile() {
        return this.ktFile;
    }

    @Override
    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.ktFile.getVirtualFile();
        if (virtualFile == null && (virtualFile = this.ktFile.getOriginalFile().getVirtualFile()) == null) {
            VirtualFile virtualFile2 = super.getVirtualFile();
            virtualFile = virtualFile2;
            Intrinsics.checkNotNullExpressionValue(virtualFile2, "getVirtualFile(...)");
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public String getPackageName() {
        return this.packageFqName.asString();
    }

    private final PsiJavaFileStub createFakeJavaFileStub() {
        PsiJavaFileStubImpl javaFileStub = new PsiJavaFileStubImpl(this.packageFqName.asString(), true);
        javaFileStub.setPsiFactory(ClsStubPsiFactory.INSTANCE);
        javaFileStub.setPsi((PsiFile)this);
        return javaFileStub;
    }

    @NotNull
    public PsiJavaFileStub getStub() {
        return this.createFakeJavaFileStub();
    }

    @NotNull
    public KtLightClass[] getClasses() {
        KtLightClass[] ktLightClassArray = new KtLightClass[]{this.lightClass};
        return ktLightClassArray;
    }

    @Override
    @NotNull
    public KtFile getNavigationElement() {
        return this.ktFile;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        Intrinsics.checkNotNullParameter(visitor2, "visitor");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public PsiElement getMirror() {
        Reference<TreeElement> reference;
        TreeElement treeElement;
        Reference<TreeElement> reference2 = this.myMirrorFileElement;
        if (reference2 != null && (treeElement = reference2.get()) != null) {
            TreeElement it = treeElement;
            boolean bl = false;
            PsiElement psiElement = it.getPsi();
            Intrinsics.checkNotNullExpressionValue(psiElement, "getPsi(...)");
            return psiElement;
        }
        Object object = this.myMirrorLock;
        synchronized (object) {
            Reference<TreeElement> reference3;
            boolean bl = false;
            Reference<TreeElement> reference4 = this.myMirrorFileElement;
            if (reference4 != null && (reference4 = reference4.get()) != null) {
                Reference<TreeElement> it = reference4;
                boolean bl2 = false;
                reference3 = it;
            } else {
                TreeElement treeElement2;
                VirtualFile file2 = this.getVirtualFile();
                AstLoadingFilter.assertTreeLoadingAllowed(file2);
                KtLightClass[] classes2 = this.getClasses();
                String fileName = (!(classes2.length == 0) ? classes2[0].getName() : file2.getNameWithoutExtension()) + ".java";
                Document document = FileDocumentManager.getInstance().getDocument(file2);
                if (document == null) {
                    String string2 = file2.getUrl();
                    Intrinsics.checkNotNullExpressionValue(string2, "getUrl(...)");
                    String string3 = string2;
                    throw new IllegalStateException(string3.toString());
                }
                Document document2 = document;
                PsiFileFactory factory2 = PsiFileFactory.getInstance(this.getManager().getProject());
                PsiFile mirror = factory2.createFileFromText(fileName, JavaLanguage.INSTANCE, document2.getImmutableCharSequence(), false, false, true);
                mirror.putUserData(PsiUtil.FILE_LANGUAGE_LEVEL_KEY, this.getLanguageLevel());
                TreeElement treeElement3 = SourceTreeToPsiMap.psiToTreeNotNull(mirror);
                Intrinsics.checkNotNullExpressionValue(treeElement3, "psiToTreeNotNull(...)");
                TreeElement mirrorTreeElement = treeElement3;
                if (mirror instanceof PsiFileImpl) {
                    ((PsiFileImpl)mirror).setOriginalFile(this);
                }
                TreeElement it = treeElement2 = mirrorTreeElement;
                boolean bl3 = false;
                this.myMirrorFileElement = new SoftReference<TreeElement>(it);
                reference3 = treeElement2;
            }
            reference = reference3;
        }
        Reference<TreeElement> mirrorElement = reference;
        PsiElement psiElement = mirrorElement.getPsi();
        Intrinsics.checkNotNullExpressionValue(psiElement, "getPsi(...)");
        return psiElement;
    }

    @Override
    @NotNull
    public LanguageLevel getLanguageLevel() {
        return LanguageLevel.JDK_1_8;
    }

    public int hashCode() {
        KtLightClass ktLightClass;
        KtLightClass it = ktLightClass = this.lightClass;
        boolean bl = false;
        KtLightClass ktLightClass2 = it instanceof KtLightClassForFacade && ((KtLightClassForFacade)it).getFiles().size() > 1 ? ktLightClass : null;
        return (ktLightClass2 != null ? (PsiElement)ktLightClass2 : (PsiElement)this.ktFile).hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FakeFileForLightClass)) {
            return false;
        }
        return this.lightClass instanceof KtLightClassForFacade && ((KtLightClassForFacade)this.lightClass).getFiles().size() > 1 && Intrinsics.areEqual(this.lightClass, ((FakeFileForLightClass)other).lightClass) || Intrinsics.areEqual(this.ktFile, ((FakeFileForLightClass)other).ktFile);
    }

    @Override
    public boolean isEquivalentTo(@Nullable PsiElement another) {
        return Intrinsics.areEqual(this, another);
    }

    @Override
    public void setPackageName(@NotNull String packageName) {
        Intrinsics.checkNotNullParameter(packageName, "packageName");
        if (this.lightClass instanceof KtLightClassForFacade) {
            KtPackageDirective ktPackageDirective = this.ktFile.getPackageDirective();
            if (ktPackageDirective != null) {
                ktPackageDirective.setFqName(new FqName(packageName));
            }
        } else {
            super.setPackageName(packageName);
        }
    }

    @Override
    public boolean isPhysical() {
        return false;
    }
}

