/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava.elements;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.asJava.elements.KtLightMethod;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiUtil;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\u001a\u0011\u0010\u0002\u001a\u00020\u0001*\u00020\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003\u001a\u0019\u0010\u0005\u001a\u00020\u0001*\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0005\u0010\u0006\"\u0015\u0010\u0007\u001a\u00020\u0001*\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0003\"\u0015\u0010\b\u001a\u00020\u0001*\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0003"}, d2={"Lorg/jetbrains/kotlin/asJava/elements/KtLightMethod;", "", "isTraitFakeOverride", "(Lorg/jetbrains/kotlin/asJava/elements/KtLightMethod;)Z", "getter", "isAccessor", "(Lorg/jetbrains/kotlin/asJava/elements/KtLightMethod;Z)Z", "isGetter", "isSetter"})
public final class KotlinLightMethodUtilsKt {
    public static final boolean isTraitFakeOverride(@NotNull KtLightMethod $this$isTraitFakeOverride) {
        Intrinsics.checkNotNullParameter($this$isTraitFakeOverride, "<this>");
        KtDeclaration methodOrigin = (KtDeclaration)$this$isTraitFakeOverride.getKotlinOrigin();
        if (!(methodOrigin instanceof KtNamedFunction || methodOrigin instanceof KtPropertyAccessor || methodOrigin instanceof KtProperty)) {
            return false;
        }
        KtClassOrObject parentOfMethodOrigin = PsiTreeUtil.getParentOfType((PsiElement)methodOrigin, KtClassOrObject.class);
        KtClassOrObject thisClassDeclaration = (KtClassOrObject)((KtLightClass)$this$isTraitFakeOverride.getContainingClass()).getKotlinOrigin();
        return parentOfMethodOrigin != null && thisClassDeclaration != parentOfMethodOrigin && KtPsiUtil.isTrait(parentOfMethodOrigin);
    }

    public static final boolean isAccessor(@NotNull KtLightMethod $this$isAccessor, boolean getter) {
        Intrinsics.checkNotNullParameter($this$isAccessor, "<this>");
        Object t = $this$isAccessor.getKotlinOrigin();
        KtCallableDeclaration ktCallableDeclaration = t instanceof KtCallableDeclaration ? (KtCallableDeclaration)t : null;
        if (ktCallableDeclaration == null) {
            return false;
        }
        KtCallableDeclaration origin = ktCallableDeclaration;
        if (!(origin instanceof KtProperty) && !(origin instanceof KtParameter)) {
            return false;
        }
        int expectedParametersCount = (getter ? 0 : 1) + (origin.getReceiverTypeReference() != null ? 1 : 0);
        return $this$isAccessor.getParameterList().getParametersCount() == expectedParametersCount;
    }

    public static final boolean isGetter(@NotNull KtLightMethod $this$isGetter) {
        Intrinsics.checkNotNullParameter($this$isGetter, "<this>");
        return KotlinLightMethodUtilsKt.isAccessor($this$isGetter, true);
    }

    public static final boolean isSetter(@NotNull KtLightMethod $this$isSetter) {
        Intrinsics.checkNotNullParameter($this$isSetter, "<this>");
        return KotlinLightMethodUtilsKt.isAccessor($this$isSetter, false);
    }
}

