/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava.elements;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.light.LightIdentifier;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.elements.PsiElementWithOrigin;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\t\b\u0016\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B%\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u000b\u001a\u00020\u0003H\u0017\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\u0003H\u0017\u00a2\u0006\u0004\b\u0010\u0010\fJ\u000f\u0010\u0012\u001a\u00020\u0011H\u0017\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0015\u001a\u00020\u0014H\u0017\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0018\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001a\u0010\u001c\u001a\u00020\r2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001aH\u0096\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u000f\u0010\u001e\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u001e\u0010\u0019R\u0014\u0010\u0004\u001a\u00020\u00038\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u001fR\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u00058\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010 R\u0016\u0010\b\u001a\u0004\u0018\u00010\u00078\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010!R\u0016\u0010#\u001a\u0004\u0018\u00010\u00038WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\f"}, d2={"Lorg/jetbrains/kotlin/asJava/elements/KtLightIdentifier;", "Lcom/intellij/psi/impl/light/LightIdentifier;", "Lorg/jetbrains/kotlin/asJava/elements/PsiElementWithOrigin;", "Lcom/intellij/psi/PsiElement;", "lightOwner", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "ktDeclaration", "", "name", "<init>", "(Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/psi/KtDeclaration;Ljava/lang/String;)V", "copy", "()Lcom/intellij/psi/PsiElement;", "", "isPhysical", "()Z", "getParent", "Lcom/intellij/psi/PsiFile;", "getContainingFile", "()Lcom/intellij/psi/PsiFile;", "Lcom/intellij/openapi/util/TextRange;", "getTextRange", "()Lcom/intellij/openapi/util/TextRange;", "", "getTextOffset", "()I", "", "other", "equals", "(Ljava/lang/Object;)Z", "hashCode", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "Ljava/lang/String;", "getOrigin", "origin"})
public class KtLightIdentifier
extends LightIdentifier
implements PsiElementWithOrigin<PsiElement> {
    @NotNull
    private final PsiElement lightOwner;
    @Nullable
    private final KtDeclaration ktDeclaration;
    @Nullable
    private final String name;

    public KtLightIdentifier(@NotNull PsiElement lightOwner, @Nullable KtDeclaration ktDeclaration, @Nullable String name) {
        Intrinsics.checkNotNullParameter(lightOwner, "lightOwner");
        super(lightOwner.getManager(), name);
        this.lightOwner = lightOwner;
        this.ktDeclaration = ktDeclaration;
        this.name = name;
    }

    public /* synthetic */ KtLightIdentifier(PsiElement psiElement, KtDeclaration ktDeclaration, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            KtDeclaration ktDeclaration2 = ktDeclaration;
            string2 = ktDeclaration2 != null ? ktDeclaration2.getName() : null;
        }
        this(psiElement, ktDeclaration, string2);
    }

    @Override
    @Nullable
    public PsiElement getOrigin() {
        PsiElement psiElement;
        KtDeclaration ktDeclaration = this.ktDeclaration;
        if (ktDeclaration instanceof KtSecondaryConstructor) {
            psiElement = ((KtSecondaryConstructor)this.ktDeclaration).getConstructorKeyword();
        } else if (ktDeclaration instanceof KtPrimaryConstructor) {
            psiElement = ((KtPrimaryConstructor)this.ktDeclaration).getConstructorKeyword();
            if (psiElement == null) {
                KtParameterList ktParameterList = ((KtPrimaryConstructor)this.ktDeclaration).getValueParameterList();
                if (ktParameterList != null) {
                    psiElement = ktParameterList;
                } else {
                    KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject(this.ktDeclaration);
                    psiElement = ktClassOrObject != null ? ktClassOrObject.getNameIdentifier() : null;
                }
            }
        } else {
            psiElement = ktDeclaration instanceof KtPropertyAccessor ? ((KtPropertyAccessor)this.ktDeclaration).getNamePlaceholder() : (ktDeclaration instanceof KtNamedDeclaration ? ((KtNamedDeclaration)this.ktDeclaration).getNameIdentifier() : null);
        }
        return psiElement;
    }

    @Override
    @NotNull
    public PsiElement copy() {
        return new KtLightIdentifier(this.getParent(), this.ktDeclaration, this.name);
    }

    @Override
    public boolean isPhysical() {
        return true;
    }

    @Override
    @NotNull
    public PsiElement getParent() {
        return this.lightOwner;
    }

    @Override
    @NotNull
    public PsiFile getContainingFile() {
        PsiFile psiFile = this.lightOwner.getContainingFile();
        Intrinsics.checkNotNullExpressionValue(psiFile, "getContainingFile(...)");
        return psiFile;
    }

    @Override
    @NotNull
    public TextRange getTextRange() {
        Object object = this.getOrigin();
        if (object == null || (object = object.getTextRange()) == null) {
            TextRange textRange = TextRange.EMPTY_RANGE;
            object = textRange;
            Intrinsics.checkNotNullExpressionValue(textRange, "EMPTY_RANGE");
        }
        return object;
    }

    @Override
    public int getTextOffset() {
        PsiElement psiElement = this.getOrigin();
        return psiElement != null ? psiElement.getTextOffset() : -1;
    }

    public boolean equals(@Nullable Object other) {
        return other == this || other instanceof KtLightIdentifier && Intrinsics.areEqual(((KtLightIdentifier)other).lightOwner, this.lightOwner) && Intrinsics.areEqual(((KtLightIdentifier)other).ktDeclaration, this.ktDeclaration) && Intrinsics.areEqual(((KtLightIdentifier)other).name, this.name);
    }

    public int hashCode() {
        return this.lightOwner.hashCode();
    }

    public KtLightIdentifier(@NotNull PsiElement lightOwner, @Nullable KtDeclaration ktDeclaration) {
        Intrinsics.checkNotNullParameter(lightOwner, "lightOwner");
        this(lightOwner, ktDeclaration, null, 4, null);
    }
}

