/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava.elements;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassGenerationSupport;
import org.jetbrains.kotlin.asJava.UtilsKt;
import org.jetbrains.kotlin.asJava.elements.KtLightAnnotationsValuesKt;
import org.jetbrains.kotlin.asJava.elements.KtLightElementBase;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0011\u0010\n\u001a\u0004\u0018\u00010\tH\u0017\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0011\u0010\r\u001a\u0004\u0018\u00010\fH\u0017\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\u0005H\u0017\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005H\u0017\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0011\u0010\u0018\u001a\u0004\u0018\u00010\u0017H\u0017\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u001aH\u0017\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u001a\u0010\u0004\u001a\u00020\u00038\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010\u001d\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010\u0006\u001a\u00020\u00058\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010 "}, d2={"Lorg/jetbrains/kotlin/asJava/elements/KtLightPsiLiteral;", "Lorg/jetbrains/kotlin/asJava/elements/KtLightElementBase;", "Lcom/intellij/psi/PsiLiteralExpression;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "kotlinOrigin", "Lcom/intellij/psi/PsiElement;", "lightParent", "<init>", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lcom/intellij/psi/PsiElement;)V", "", "getValue", "()Ljava/lang/Object;", "Lcom/intellij/psi/PsiType;", "getType", "()Lcom/intellij/psi/PsiType;", "getParent", "()Lcom/intellij/psi/PsiElement;", "", "isPhysical", "()Z", "newElement", "replace", "(Lcom/intellij/psi/PsiElement;)Lcom/intellij/psi/PsiElement;", "Lcom/intellij/psi/PsiReference;", "getReference", "()Lcom/intellij/psi/PsiReference;", "", "getReferences", "()[Lcom/intellij/psi/PsiReference;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getKotlinOrigin", "()Lorg/jetbrains/kotlin/psi/KtExpression;", "Lcom/intellij/psi/PsiElement;"})
public class KtLightPsiLiteral
extends KtLightElementBase
implements PsiLiteralExpression {
    @NotNull
    private final KtExpression kotlinOrigin;
    @NotNull
    private final PsiElement lightParent;

    public KtLightPsiLiteral(@NotNull KtExpression kotlinOrigin, @NotNull PsiElement lightParent) {
        Intrinsics.checkNotNullParameter(kotlinOrigin, "kotlinOrigin");
        Intrinsics.checkNotNullParameter(lightParent, "lightParent");
        super(lightParent);
        this.kotlinOrigin = kotlinOrigin;
        this.lightParent = lightParent;
    }

    @Override
    @NotNull
    public KtExpression getKotlinOrigin() {
        return this.kotlinOrigin;
    }

    @Override
    @Nullable
    public Object getValue() {
        return UtilsKt.computeExpression(this);
    }

    @Override
    @Nullable
    public PsiType getType() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue(project, "getProject(...)");
        BindingContext bindingContext = LightClassGenerationSupport.Companion.getInstance(project).analyze(this.getKotlinOrigin());
        KotlinType kotlinType = (KotlinType)bindingContext.get(BindingContext.EXPECTED_EXPRESSION_TYPE, this.getKotlinOrigin());
        if (kotlinType == null) {
            return null;
        }
        KotlinType kotlinType2 = kotlinType;
        Object object = kotlinType2.getConstructor().getDeclarationDescriptor();
        if (object == null || (object = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)object)) == null || (object = ((FqName)object).asString()) == null) {
            return null;
        }
        Object typeFqName2 = object;
        return KtLightAnnotationsValuesKt.psiType$default((String)typeFqName2, this.getKotlinOrigin(), false, 4, null);
    }

    @Override
    @NotNull
    public PsiElement getParent() {
        return this.lightParent;
    }

    @Override
    public boolean isPhysical() {
        return false;
    }

    @Override
    @NotNull
    public PsiElement replace(@NotNull PsiElement newElement) {
        Intrinsics.checkNotNullParameter(newElement, "newElement");
        PsiLiteral psiLiteral = newElement instanceof PsiLiteral ? (PsiLiteral)newElement : null;
        Object object = psiLiteral != null ? psiLiteral.getValue() : null;
        String string2 = object instanceof String ? (String)object : null;
        if (string2 == null) {
            return this;
        }
        String value2 = string2;
        KtExpression ktExpression = this.getKotlinOrigin();
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue(project, "getProject(...)");
        ktExpression.replace(new KtPsiFactory(project, false, 2, null).createExpression('\"' + StringUtil.escapeStringCharacters(value2) + '\"'));
        return this;
    }

    @Override
    @Nullable
    public PsiReference getReference() {
        return ArraysKt.singleOrNull(this.getReferences());
    }

    @Override
    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = this.getKotlinOrigin().getReferences();
        Intrinsics.checkNotNullExpressionValue(psiReferenceArray, "getReferences(...)");
        return psiReferenceArray;
    }
}

