/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava.elements;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.IncorrectOperationException;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.classes.ImplUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\b\u001a\u00020\u0002H\u0017\u00a2\u0006\u0004\b\b\u0010\tJ\u0011\u0010\n\u001a\u0004\u0018\u00010\u0002H\u0017\u00a2\u0006\u0004\b\n\u0010\tJ\u000f\u0010\f\u001a\u00020\u000bH\u0017\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000f\u001a\u00020\u000eH\u0017\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u000eH\u0017\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0002H\u0017\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0018\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0015\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0017\u00a2\u0006\u0004\b\u001e\u0010\u001fR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010 R\u001d\u0010%\u001a\u0004\u0018\u00010\u00018BX\u0083\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\"\u001a\u0004\b#\u0010$"}, d2={"Lorg/jetbrains/kotlin/asJava/elements/LazyPsiReferenceDelegate;", "Lcom/intellij/psi/PsiReference;", "Lcom/intellij/psi/PsiElement;", "psiElement", "Lkotlin/Function0;", "referenceProvider", "<init>", "(Lcom/intellij/psi/PsiElement;Lkotlin/jvm/functions/Function0;)V", "getElement", "()Lcom/intellij/psi/PsiElement;", "resolve", "Lcom/intellij/openapi/util/TextRange;", "getRangeInElement", "()Lcom/intellij/openapi/util/TextRange;", "", "getCanonicalText", "()Ljava/lang/String;", "newElementName", "handleElementRename", "(Ljava/lang/String;)Lcom/intellij/psi/PsiElement;", "element", "bindToElement", "(Lcom/intellij/psi/PsiElement;)Lcom/intellij/psi/PsiElement;", "", "isSoft", "()Z", "isReferenceTo", "(Lcom/intellij/psi/PsiElement;)Z", "", "", "getVariants", "()[Ljava/lang/Object;", "Lcom/intellij/psi/PsiElement;", "delegate$delegate", "Lkotlin/Lazy;", "getDelegate", "()Lcom/intellij/psi/PsiReference;", "delegate"})
final class LazyPsiReferenceDelegate
implements PsiReference {
    @NotNull
    private final PsiElement psiElement;
    @NotNull
    private final Lazy delegate$delegate;

    public LazyPsiReferenceDelegate(@NotNull PsiElement psiElement, @NotNull Function0<? extends PsiReference> referenceProvider) {
        Intrinsics.checkNotNullParameter(psiElement, "psiElement");
        Intrinsics.checkNotNullParameter(referenceProvider, "referenceProvider");
        this.psiElement = psiElement;
        this.delegate$delegate = ImplUtilsKt.lazyPub(referenceProvider);
    }

    private final PsiReference getDelegate() {
        Lazy lazy = this.delegate$delegate;
        return (PsiReference)lazy.getValue();
    }

    @Override
    @NotNull
    public PsiElement getElement() {
        return this.psiElement;
    }

    @Override
    @Nullable
    public PsiElement resolve() {
        PsiReference psiReference = this.getDelegate();
        return psiReference != null ? psiReference.resolve() : null;
    }

    @Override
    @NotNull
    public TextRange getRangeInElement() {
        Object object = this.getDelegate();
        if (object == null || (object = object.getRangeInElement()) == null) {
            TextRange textRange = this.psiElement.getTextRange();
            object = textRange;
            Intrinsics.checkNotNullExpressionValue(textRange, "getTextRange(...)");
        }
        return object;
    }

    @Override
    @NotNull
    public String getCanonicalText() {
        Object object = this.getDelegate();
        if (object == null || (object = object.getCanonicalText()) == null) {
            object = "<no-text>";
        }
        return object;
    }

    @Override
    @NotNull
    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        Intrinsics.checkNotNullParameter(newElementName, "newElementName");
        Object object = this.getDelegate();
        if (object == null || (object = object.handleElementRename(newElementName)) == null) {
            object = this.getElement();
        }
        return object;
    }

    @Override
    @NotNull
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        Intrinsics.checkNotNullParameter(element, "element");
        Object object = this.getDelegate();
        if (object == null || (object = object.bindToElement(element)) == null) {
            throw new IncorrectOperationException("can't rename LazyPsiReferenceDelegate");
        }
        return object;
    }

    @Override
    public boolean isSoft() {
        PsiReference psiReference = this.getDelegate();
        return psiReference != null ? psiReference.isSoft() : false;
    }

    @Override
    public boolean isReferenceTo(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter(element, "element");
        PsiReference psiReference = this.getDelegate();
        return psiReference != null ? psiReference.isReferenceTo(element) : false;
    }

    @Override
    @NotNull
    public Object[] getVariants() {
        Object[] objectArray = this.getDelegate();
        if (objectArray == null || (objectArray = objectArray.getVariants()) == null) {
            objectArray = new Object[]{};
        }
        return objectArray;
    }
}

