/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava.finder;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.compiled.ClsClassImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.KotlinAsJavaSupport;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.asJava.finder.KtLightPackage;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.progress.ProgressIndicatorAndCompilationCanceledStatus;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.jvm.KotlinFinderMarker;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 ?2\u00020\u00012\u00020\u0002:\u0001?B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J!\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0017\u00a2\u0006\u0004\b\f\u0010\rJ%\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0017\u00a2\u0006\u0004\b\u0010\u0010\u0011J-\u0010\u0016\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\t2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0013H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J-\u0010\u0018\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\t2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0013H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0017J-\u0010\u0019\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\t2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0013H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u0017JI\u0010\u001f\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00132\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u001bH\u0002\u00a2\u0006\u0004\b\u001f\u0010 J%\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00070#2\u0006\u0010\"\u001a\u00020!2\u0006\u0010\n\u001a\u00020\tH\u0017\u00a2\u0006\u0004\b$\u0010%J\u0019\u0010&\u001a\u0004\u0018\u00010!2\u0006\u0010\u000e\u001a\u00020\u0007H\u0017\u00a2\u0006\u0004\b&\u0010'J%\u0010(\u001a\b\u0012\u0004\u0012\u00020!0\u000f2\u0006\u0010\"\u001a\u00020!2\u0006\u0010\n\u001a\u00020\tH\u0017\u00a2\u0006\u0004\b(\u0010)J%\u0010*\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f2\u0006\u0010\"\u001a\u00020!2\u0006\u0010\n\u001a\u00020\tH\u0017\u00a2\u0006\u0004\b*\u0010+J%\u0010/\u001a\u00020\u00152\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u000b0,2\u0006\u0010.\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b/\u00100J%\u00102\u001a\b\u0012\u0004\u0012\u0002010\u000f2\u0006\u0010\"\u001a\u00020!2\u0006\u0010\n\u001a\u00020\tH\u0017\u00a2\u0006\u0004\b2\u00103J%\u00105\u001a\b\u0012\u0004\u0012\u000201042\u0006\u0010\"\u001a\u00020!2\u0006\u0010\n\u001a\u00020\tH\u0017\u00a2\u0006\u0004\b5\u00106R\u0014\u0010\u0004\u001a\u00020\u00038\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u00107R\u0019\u0010:\u001a\u000708\u00a2\u0006\u0002\b98\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b:\u0010;R\u0014\u0010=\u001a\u00020<8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b=\u0010>"}, d2={"Lorg/jetbrains/kotlin/asJava/finder/JavaElementFinder;", "Lcom/intellij/psi/PsiElementFinder;", "Lorg/jetbrains/kotlin/resolve/jvm/KotlinFinderMarker;", "Lcom/intellij/openapi/project/Project;", "project", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "", "qualifiedName", "Lcom/intellij/psi/search/GlobalSearchScope;", "scope", "Lcom/intellij/psi/PsiClass;", "findClass", "(Ljava/lang/String;Lcom/intellij/psi/search/GlobalSearchScope;)Lcom/intellij/psi/PsiClass;", "qualifiedNameString", "", "findClasses", "(Ljava/lang/String;Lcom/intellij/psi/search/GlobalSearchScope;)[Lcom/intellij/psi/PsiClass;", "Lorg/jetbrains/kotlin/name/FqName;", "", "answer", "", "findClassesAndObjects", "(Lorg/jetbrains/kotlin/name/FqName;Lcom/intellij/psi/search/GlobalSearchScope;Ljava/util/List;)V", "findInterfaceDefaultImpls", "findRepeatableAnnotationContainer", "syntheticName", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "", "predicate", "findSyntheticInnerClass", "(Lorg/jetbrains/kotlin/name/FqName;Ljava/lang/String;Lcom/intellij/psi/search/GlobalSearchScope;Ljava/util/List;Lkotlin/jvm/functions/Function1;)V", "Lcom/intellij/psi/PsiPackage;", "psiPackage", "", "getClassNames", "(Lcom/intellij/psi/PsiPackage;Lcom/intellij/psi/search/GlobalSearchScope;)Ljava/util/Set;", "findPackage", "(Ljava/lang/String;)Lcom/intellij/psi/PsiPackage;", "getSubPackages", "(Lcom/intellij/psi/PsiPackage;Lcom/intellij/psi/search/GlobalSearchScope;)[Lcom/intellij/psi/PsiPackage;", "getClasses", "(Lcom/intellij/psi/PsiPackage;Lcom/intellij/psi/search/GlobalSearchScope;)[Lcom/intellij/psi/PsiClass;", "Lcom/intellij/util/SmartList;", "list", "searchScope", "sortByPreferenceToSourceFile", "(Lcom/intellij/util/SmartList;Lcom/intellij/psi/search/GlobalSearchScope;)V", "Lcom/intellij/psi/PsiFile;", "getPackageFiles", "(Lcom/intellij/psi/PsiPackage;Lcom/intellij/psi/search/GlobalSearchScope;)[Lcom/intellij/psi/PsiFile;", "Lcom/intellij/openapi/util/Condition;", "getPackageFilesFilter", "(Lcom/intellij/psi/PsiPackage;Lcom/intellij/psi/search/GlobalSearchScope;)Lcom/intellij/openapi/util/Condition;", "Lcom/intellij/openapi/project/Project;", "Lcom/intellij/psi/PsiManager;", "Lorg/jetbrains/annotations/NotNull;", "psiManager", "Lcom/intellij/psi/PsiManager;", "Lorg/jetbrains/kotlin/asJava/KotlinAsJavaSupport;", "kotlinAsJavaSupport", "Lorg/jetbrains/kotlin/asJava/KotlinAsJavaSupport;", "Companion"})
public final class JavaElementFinder
extends PsiElementFinder
implements KotlinFinderMarker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final PsiManager psiManager;
    @NotNull
    private final KotlinAsJavaSupport kotlinAsJavaSupport;

    public JavaElementFinder(@NotNull Project project) {
        Intrinsics.checkNotNullParameter(project, "project");
        this.project = project;
        PsiManager psiManager = PsiManager.getInstance(this.project);
        Intrinsics.checkNotNullExpressionValue(psiManager, "getInstance(...)");
        this.psiManager = psiManager;
        this.kotlinAsJavaSupport = KotlinAsJavaSupport.Companion.getInstance(this.project);
    }

    @Override
    @Nullable
    public PsiClass findClass(@NotNull String qualifiedName2, @NotNull GlobalSearchScope scope2) {
        Intrinsics.checkNotNullParameter(qualifiedName2, "qualifiedName");
        Intrinsics.checkNotNullParameter(scope2, "scope");
        return ArraysKt.firstOrNull(this.findClasses(qualifiedName2, scope2));
    }

    @Override
    @NotNull
    public PsiClass[] findClasses(@NotNull String qualifiedNameString, @NotNull GlobalSearchScope scope2) {
        Intrinsics.checkNotNullParameter(qualifiedNameString, "qualifiedNameString");
        Intrinsics.checkNotNullParameter(scope2, "scope");
        if (!FqNamesUtilKt.isValidJavaFqName(qualifiedNameString)) {
            Intrinsics.checkNotNullExpressionValue(PsiClass.EMPTY_ARRAY, "EMPTY_ARRAY");
            return PsiClass.EMPTY_ARRAY;
        }
        SmartList<PsiClass> answer = new SmartList<PsiClass>();
        FqName qualifiedName2 = new FqName(qualifiedNameString);
        this.findClassesAndObjects(qualifiedName2, scope2, (List<PsiClass>)answer);
        answer.addAll(this.kotlinAsJavaSupport.getFacadeClasses(qualifiedName2, scope2));
        answer.addAll(this.kotlinAsJavaSupport.getKotlinInternalClasses(qualifiedName2, scope2));
        this.sortByPreferenceToSourceFile(answer, scope2);
        Collection $this$toTypedArray$iv = answer;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new PsiClass[0]);
    }

    private final void findClassesAndObjects(FqName qualifiedName2, GlobalSearchScope scope2, List<PsiClass> answer) {
        this.findInterfaceDefaultImpls(qualifiedName2, scope2, answer);
        this.findRepeatableAnnotationContainer(qualifiedName2, scope2, answer);
        Collection<KtClassOrObject> classOrObjectDeclarations = this.kotlinAsJavaSupport.findClassOrObjectDeclarations(qualifiedName2, scope2);
        for (KtClassOrObject declaration : classOrObjectDeclarations) {
            KtLightClass lightClass;
            if (declaration instanceof KtEnumEntry || (lightClass = this.kotlinAsJavaSupport.getLightClass(declaration)) == null) continue;
            answer.add(lightClass);
        }
    }

    private final void findInterfaceDefaultImpls(FqName qualifiedName2, GlobalSearchScope scope2, List<PsiClass> answer) {
        this.findSyntheticInnerClass(qualifiedName2, "DefaultImpls", scope2, answer, JavaElementFinder::findInterfaceDefaultImpls$lambda$0);
    }

    private final void findRepeatableAnnotationContainer(FqName qualifiedName2, GlobalSearchScope scope2, List<PsiClass> answer) {
        this.findSyntheticInnerClass(qualifiedName2, "Container", scope2, answer, JavaElementFinder::findRepeatableAnnotationContainer$lambda$1);
    }

    private final void findSyntheticInnerClass(FqName qualifiedName2, String syntheticName, GlobalSearchScope scope2, List<PsiClass> answer, Function1<? super KtClassOrObject, Boolean> predicate) {
        if (qualifiedName2.isRoot() || !Intrinsics.areEqual(qualifiedName2.shortName().asString(), syntheticName)) {
            return;
        }
        for (KtClassOrObject classOrObject : this.kotlinAsJavaSupport.findClassOrObjectDeclarations(qualifiedName2.parent(), scope2)) {
            PsiClass implsClass;
            KtLightClass interfaceClass;
            ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
            if (!predicate.invoke(classOrObject).booleanValue() || this.kotlinAsJavaSupport.getLightClass(classOrObject) == null || interfaceClass.findInnerClassByName(syntheticName, false) == null) continue;
            answer.add(implsClass);
        }
    }

    @Override
    @NotNull
    public Set<String> getClassNames(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
        Intrinsics.checkNotNullParameter(psiPackage, "psiPackage");
        Intrinsics.checkNotNullParameter(scope2, "scope");
        String string2 = psiPackage.getQualifiedName();
        Intrinsics.checkNotNullExpressionValue(string2, "getQualifiedName(...)");
        FqName packageFQN = new FqName(string2);
        Collection<KtClassOrObject> declarations2 = this.kotlinAsJavaSupport.findClassOrObjectDeclarationsInPackage(packageFQN, scope2);
        HashSet<String> answer = new HashSet<String>();
        answer.addAll(this.kotlinAsJavaSupport.getFacadeNames(packageFQN, scope2));
        for (KtClassOrObject declaration : declarations2) {
            String name;
            if (declaration.getName() == null) continue;
            answer.add(name);
        }
        return answer;
    }

    @Override
    @Nullable
    public PsiPackage findPackage(@NotNull String qualifiedNameString) {
        Intrinsics.checkNotNullParameter(qualifiedNameString, "qualifiedNameString");
        if (!FqNamesUtilKt.isValidJavaFqName(qualifiedNameString)) {
            return null;
        }
        FqName fqName2 = new FqName(qualifiedNameString);
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope(this.project);
        Intrinsics.checkNotNullExpressionValue(globalSearchScope, "allScope(...)");
        GlobalSearchScope allScope = globalSearchScope;
        return this.kotlinAsJavaSupport.packageExists(fqName2, allScope) ? (PsiPackage)new KtLightPackage(this.psiManager, fqName2, allScope) : null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public PsiPackage[] getSubPackages(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(psiPackage, "psiPackage");
        Intrinsics.checkNotNullParameter(scope2, "scope");
        String string2 = psiPackage.getQualifiedName();
        Intrinsics.checkNotNullExpressionValue(string2, "getQualifiedName(...)");
        Collection<FqName> subpackages = this.kotlinAsJavaSupport.getSubPackages(new FqName(string2), scope2);
        Iterable $this$map$iv = subpackages;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FqName fqName2 = (FqName)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new KtLightPackage(this.psiManager, (FqName)it, scope2));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new PsiPackage[0]);
    }

    @Override
    @NotNull
    public PsiClass[] getClasses(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
        Intrinsics.checkNotNullParameter(psiPackage, "psiPackage");
        Intrinsics.checkNotNullParameter(scope2, "scope");
        SmartList<PsiClass> answer = new SmartList<PsiClass>();
        String string2 = psiPackage.getQualifiedName();
        Intrinsics.checkNotNullExpressionValue(string2, "getQualifiedName(...)");
        FqName packageFQN = new FqName(string2);
        answer.addAll(this.kotlinAsJavaSupport.getFacadeClassesInPackage(packageFQN, scope2));
        Collection<KtClassOrObject> declarations2 = this.kotlinAsJavaSupport.findClassOrObjectDeclarationsInPackage(packageFQN, scope2);
        for (KtClassOrObject declaration : declarations2) {
            KtLightClass aClass;
            if (this.kotlinAsJavaSupport.getLightClass(declaration) == null) continue;
            answer.add(aClass);
        }
        this.sortByPreferenceToSourceFile(answer, scope2);
        Collection $this$toTypedArray$iv = answer;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new PsiClass[0]);
    }

    private final void sortByPreferenceToSourceFile(SmartList<PsiClass> list, GlobalSearchScope searchScope) {
        if (list.size() < 2) {
            return;
        }
        ContainerUtil.quickSort((List)list, Companion.byClasspathComparator(searchScope));
        List $this$sortBy$iv = list;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith($this$sortBy$iv, new Comparator(){

                public final int compare(T a, T b) {
                    PsiClass it = (PsiClass)a;
                    boolean bl = false;
                    boolean bl2 = !(it instanceof ClsClassImpl);
                    it = (PsiClass)b;
                    Comparable comparable = Boolean.valueOf(bl2);
                    bl = false;
                    return ComparisonsKt.compareValues(comparable, !(it instanceof ClsClassImpl));
                }
            });
        }
    }

    @Override
    @NotNull
    public PsiFile[] getPackageFiles(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
        Intrinsics.checkNotNullParameter(psiPackage, "psiPackage");
        Intrinsics.checkNotNullParameter(scope2, "scope");
        String string2 = psiPackage.getQualifiedName();
        Intrinsics.checkNotNullExpressionValue(string2, "getQualifiedName(...)");
        Collection<KtFile> $this$toTypedArray$iv = this.kotlinAsJavaSupport.findFilesForPackage(new FqName(string2), scope2);
        boolean $i$f$toTypedArray = false;
        Collection<KtFile> thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new PsiFile[0]);
    }

    @Override
    @NotNull
    public Condition<PsiFile> getPackageFilesFilter(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
        Intrinsics.checkNotNullParameter(psiPackage, "psiPackage");
        Intrinsics.checkNotNullParameter(scope2, "scope");
        return arg_0 -> JavaElementFinder.getPackageFilesFilter$lambda$4(psiPackage, arg_0);
    }

    private static final boolean findInterfaceDefaultImpls$lambda$0(KtClassOrObject it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it instanceof KtClass && ((KtClass)it).isInterface();
    }

    private static final boolean findRepeatableAnnotationContainer$lambda$1(KtClassOrObject it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return LightClassUtilsKt.getHasRepeatableAnnotationContainer(it);
    }

    private static final boolean getPackageFilesFilter$lambda$4(PsiPackage $psiPackage, PsiFile input) {
        return !(input instanceof KtFile) ? true : Intrinsics.areEqual($psiPackage.getQualifiedName(), ((KtFile)input).getPackageFqName().asString());
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ'\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\r2\u0006\u0010\n\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000f"}, d2={"Lorg/jetbrains/kotlin/asJava/finder/JavaElementFinder$Companion;", "", "<init>", "()V", "Lcom/intellij/openapi/project/Project;", "project", "Lorg/jetbrains/kotlin/asJava/finder/JavaElementFinder;", "getInstance", "(Lcom/intellij/openapi/project/Project;)Lorg/jetbrains/kotlin/asJava/finder/JavaElementFinder;", "Lcom/intellij/psi/search/GlobalSearchScope;", "searchScope", "Ljava/util/Comparator;", "Lcom/intellij/psi/PsiElement;", "Lkotlin/Comparator;", "byClasspathComparator", "(Lcom/intellij/psi/search/GlobalSearchScope;)Ljava/util/Comparator;"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JavaElementFinder getInstance(@NotNull Project project) {
            PsiElementFinder psiElementFinder;
            block2: {
                Intrinsics.checkNotNullParameter(project, "project");
                PsiElementFinder[] psiElementFinderArray = PsiElementFinder.EP.getPoint(project).getExtensions();
                Intrinsics.checkNotNullExpressionValue(psiElementFinderArray, "getExtensions(...)");
                PsiElementFinder[] $this$firstIsInstanceOrNull$iv = psiElementFinderArray;
                boolean $i$f$firstIsInstanceOrNull = false;
                for (PsiElementFinder element$iv : $this$firstIsInstanceOrNull$iv) {
                    if (!(element$iv instanceof JavaElementFinder)) continue;
                    psiElementFinder = element$iv;
                    break block2;
                }
                psiElementFinder = null;
            }
            JavaElementFinder javaElementFinder = (JavaElementFinder)psiElementFinder;
            if (javaElementFinder == null) {
                throw new IllegalStateException((JavaElementFinder.class.getSimpleName() + " is not found for project " + project).toString());
            }
            return javaElementFinder;
        }

        @NotNull
        public final Comparator<PsiElement> byClasspathComparator(@NotNull GlobalSearchScope searchScope) {
            Intrinsics.checkNotNullParameter(searchScope, "searchScope");
            return (arg_0, arg_1) -> Companion.byClasspathComparator$lambda$0(searchScope, arg_0, arg_1);
        }

        private static final int byClasspathComparator$lambda$0(GlobalSearchScope $searchScope, PsiElement o1, PsiElement o2) {
            VirtualFile f1 = PsiUtilCore.getVirtualFile(o1);
            VirtualFile f2 = PsiUtilCore.getVirtualFile(o2);
            return f1 == f2 ? 0 : (f1 == null ? -1 : (f2 == null ? 1 : $searchScope.compare(f2, f1)));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

