/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.backend.common.FunctionsFromAnyGenerator;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nJ%\u0010\u0010\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH$\u00a2\u0006\u0004\b\u0010\u0010\u0011J%\u0010\u0012\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH$\u00a2\u0006\u0004\b\u0012\u0010\u0011J%\u0010\u0013\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH$\u00a2\u0006\u0004\b\u0013\u0010\u0011J\u001d\u0010\u0014\u001a\u00020\b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001d\u0010\u0016\u001a\u00020\b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0015J\u001d\u0010\u0017\u001a\u00020\b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0015R\u001a\u0010\u0003\u001a\u00020\u00028\u0005X\u0085\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u0005\u001a\u00020\u00048\u0005X\u0085\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001b\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001f\u001a\u00020\u001e8\u0005X\u0085\u0004\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"R\u001a\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8EX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u001a\u0010(\u001a\b\u0012\u0004\u0012\u00020&0\r8EX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010$"}, d2={"Lorg/jetbrains/kotlin/backend/common/FunctionsFromAnyGenerator;", "", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "declaration", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "bindingContext", "<init>", "(Lorg/jetbrains/kotlin/psi/KtClassOrObject;Lorg/jetbrains/kotlin/resolve/BindingContext;)V", "", "generate", "()V", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "function", "", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "properties", "generateToStringMethod", "(Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;Ljava/util/List;)V", "generateHashCodeMethod", "generateEqualsMethod", "generateToStringIfNeeded", "(Ljava/util/List;)V", "generateHashCodeIfNeeded", "generateEqualsIfNeeded", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "getDeclaration", "()Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "getBindingContext", "()Lorg/jetbrains/kotlin/resolve/BindingContext;", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "getClassDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "getPrimaryConstructorProperties", "()Ljava/util/List;", "primaryConstructorProperties", "Lorg/jetbrains/kotlin/psi/KtParameter;", "getPrimaryConstructorParameters", "primaryConstructorParameters"})
public abstract class FunctionsFromAnyGenerator {
    @NotNull
    private final KtClassOrObject declaration;
    @NotNull
    private final BindingContext bindingContext;
    @NotNull
    private final ClassDescriptor classDescriptor;

    public FunctionsFromAnyGenerator(@NotNull KtClassOrObject declaration, @NotNull BindingContext bindingContext) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(bindingContext, "bindingContext");
        this.declaration = declaration;
        this.bindingContext = bindingContext;
        Object v = BindingContextUtils.getNotNull(this.bindingContext, BindingContext.CLASS, this.declaration);
        Intrinsics.checkNotNullExpressionValue(v, "getNotNull(...)");
        this.classDescriptor = (ClassDescriptor)v;
    }

    @NotNull
    protected final KtClassOrObject getDeclaration() {
        return this.declaration;
    }

    @NotNull
    protected final BindingContext getBindingContext() {
        return this.bindingContext;
    }

    @NotNull
    protected final ClassDescriptor getClassDescriptor() {
        return this.classDescriptor;
    }

    public void generate() {
        List<PropertyDescriptor> properties2 = this.getPrimaryConstructorProperties();
        this.generateToStringIfNeeded(properties2);
        this.generateHashCodeIfNeeded(properties2);
        this.generateEqualsIfNeeded(properties2);
    }

    protected abstract void generateToStringMethod(@NotNull FunctionDescriptor var1, @NotNull List<? extends PropertyDescriptor> var2);

    protected abstract void generateHashCodeMethod(@NotNull FunctionDescriptor var1, @NotNull List<? extends PropertyDescriptor> var2);

    protected abstract void generateEqualsMethod(@NotNull FunctionDescriptor var1, @NotNull List<? extends PropertyDescriptor> var2);

    private final void generateToStringIfNeeded(List<? extends PropertyDescriptor> properties2) {
        FunctionDescriptor functionDescriptor = CodegenUtil.INSTANCE.getMemberToGenerate(this.classDescriptor, "toString", generateToStringIfNeeded.function.1.INSTANCE, generateToStringIfNeeded.function.2.INSTANCE);
        if (functionDescriptor == null) {
            return;
        }
        FunctionDescriptor function2 = functionDescriptor;
        this.generateToStringMethod(function2, properties2);
    }

    private final void generateHashCodeIfNeeded(List<? extends PropertyDescriptor> properties2) {
        FunctionDescriptor functionDescriptor = CodegenUtil.INSTANCE.getMemberToGenerate(this.classDescriptor, "hashCode", generateHashCodeIfNeeded.function.1.INSTANCE, generateHashCodeIfNeeded.function.2.INSTANCE);
        if (functionDescriptor == null) {
            return;
        }
        FunctionDescriptor function2 = functionDescriptor;
        this.generateHashCodeMethod(function2, properties2);
    }

    private final void generateEqualsIfNeeded(List<? extends PropertyDescriptor> properties2) {
        FunctionDescriptor functionDescriptor = CodegenUtil.INSTANCE.getMemberToGenerate(this.classDescriptor, "equals", generateEqualsIfNeeded.function.1.INSTANCE, FunctionsFromAnyGenerator::generateEqualsIfNeeded$lambda$0);
        if (functionDescriptor == null) {
            return;
        }
        FunctionDescriptor function2 = functionDescriptor;
        this.generateEqualsMethod(function2, properties2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final List<PropertyDescriptor> getPrimaryConstructorProperties() {
        void $this$mapTo$iv$iv;
        KtParameter it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getPrimaryConstructorParameters();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (KtParameter)element$iv$iv;
            boolean bl = false;
            if (!it.hasValOrVar()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (KtParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object v = this.bindingContext.get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, it);
            Intrinsics.checkNotNull(v);
            collection.add((PropertyDescriptor)v);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    protected final List<KtParameter> getPrimaryConstructorParameters() {
        KtClassOrObject ktClassOrObject = this.declaration;
        KtClass ktClass = ktClassOrObject instanceof KtClass ? (KtClass)ktClassOrObject : null;
        List<KtParameter> list = ktClass != null ? ktClass.getPrimaryConstructorParameters() : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private static final boolean generateEqualsIfNeeded$lambda$0(List parameters2) {
        Intrinsics.checkNotNullParameter(parameters2, "parameters");
        return parameters2.size() == 1 && KotlinBuiltIns.isNullableAny(((ValueParameterDescriptor)CollectionsKt.first(parameters2)).getType());
    }
}

