/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.builtins.functions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.functions.FunctionTypeKind;
import org.jetbrains.kotlin.builtins.functions.FunctionTypeKindKt;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0004\u0018\u0000  2\u00020\u0001:\u0002 !B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J!\u0010\u000b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ!\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0011\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u0013H\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0015J\r\u0010\u0016\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0019\u0010\u001a\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0018\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u001cR&\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u001d8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001f"}, d2={"Lorg/jetbrains/kotlin/builtins/functions/FunctionTypeKindExtractor;", "", "", "Lorg/jetbrains/kotlin/builtins/functions/FunctionTypeKind;", "kinds", "<init>", "(Ljava/util/List;)V", "Lorg/jetbrains/kotlin/name/FqName;", "packageFqName", "", "className", "getFunctionalClassKind", "(Lorg/jetbrains/kotlin/name/FqName;Ljava/lang/String;)Lorg/jetbrains/kotlin/builtins/functions/FunctionTypeKind;", "Lorg/jetbrains/kotlin/builtins/functions/FunctionTypeKindExtractor$KindWithArity;", "getFunctionalClassKindWithArity", "(Lorg/jetbrains/kotlin/name/FqName;Ljava/lang/String;)Lorg/jetbrains/kotlin/builtins/functions/FunctionTypeKindExtractor$KindWithArity;", "", "hasKindWithSpecificPackage", "(Lorg/jetbrains/kotlin/name/FqName;)Z", "", "getFunctionKindPackageNames", "()Ljava/util/Set;", "hasExtensionKinds", "()Z", "s", "", "toInt", "(Ljava/lang/String;)Ljava/lang/Integer;", "Ljava/util/List;", "", "knownKindsByPackageFqName", "Ljava/util/Map;", "Companion", "KindWithArity"})
public final class FunctionTypeKindExtractor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<FunctionTypeKind> kinds;
    @NotNull
    private final Map<FqName, List<FunctionTypeKind>> knownKindsByPackageFqName;
    @NotNull
    private static final FunctionTypeKindExtractor Default;

    /*
     * WARNING - void declaration
     */
    public FunctionTypeKindExtractor(@NotNull List<? extends FunctionTypeKind> kinds2) {
        void $this$groupByTo$iv$iv;
        void $this$groupBy$iv;
        Intrinsics.checkNotNullParameter(kinds2, "kinds");
        this.kinds = kinds2;
        Iterable iterable = this.kinds;
        FunctionTypeKindExtractor functionTypeKindExtractor = this;
        boolean $i$f$groupBy = false;
        void var4_5 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            FunctionTypeKind it = (FunctionTypeKind)element$iv$iv;
            boolean bl = false;
            FqName key$iv$iv = it.getPackageFqName();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        functionTypeKindExtractor.knownKindsByPackageFqName = destination$iv$iv;
    }

    @Nullable
    public final FunctionTypeKind getFunctionalClassKind(@NotNull FqName packageFqName, @NotNull String className) {
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        Intrinsics.checkNotNullParameter(className, "className");
        KindWithArity kindWithArity = this.getFunctionalClassKindWithArity(packageFqName, className);
        return kindWithArity != null ? kindWithArity.getKind() : null;
    }

    @Nullable
    public final KindWithArity getFunctionalClassKindWithArity(@NotNull FqName packageFqName, @NotNull String className) {
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        Intrinsics.checkNotNullParameter(className, "className");
        List<FunctionTypeKind> list = this.knownKindsByPackageFqName.get(packageFqName);
        if (list == null) {
            return null;
        }
        List<FunctionTypeKind> kinds2 = list;
        for (FunctionTypeKind kind : kinds2) {
            if (!StringsKt.startsWith$default(className, kind.getClassNamePrefix(), false, 2, null)) continue;
            String string2 = className.substring(kind.getClassNamePrefix().length());
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
            Integer n = this.toInt(string2);
            if (n == null) {
                continue;
            }
            int arity = n;
            return new KindWithArity(kind, arity);
        }
        return null;
    }

    public final boolean hasKindWithSpecificPackage(@NotNull FqName packageFqName) {
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        return this.knownKindsByPackageFqName.containsKey(packageFqName);
    }

    @NotNull
    public final Set<FqName> getFunctionKindPackageNames() {
        return this.knownKindsByPackageFqName.keySet();
    }

    public final boolean hasExtensionKinds() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.kinds;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FunctionTypeKind it = (FunctionTypeKind)element$iv;
                    boolean bl2 = false;
                    if (!(!FunctionTypeKindKt.isBuiltin(it))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final Integer toInt(String s) {
        if (((CharSequence)s).length() == 0) {
            return null;
        }
        int result2 = 0;
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            int d = c - 48;
            if (!(0 <= d ? d < 10 : false)) {
                return null;
            }
            result2 = result2 * 10 + d;
        }
        return result2;
    }

    @NotNull
    public static final FunctionTypeKindExtractor getDefault() {
        return Companion.getDefault();
    }

    static {
        FunctionTypeKind[] functionTypeKindArray = new FunctionTypeKind[]{FunctionTypeKind.Function.INSTANCE, FunctionTypeKind.SuspendFunction.INSTANCE, FunctionTypeKind.KFunction.INSTANCE, FunctionTypeKind.KSuspendFunction.INSTANCE};
        Default = new FunctionTypeKindExtractor(CollectionsKt.listOf(functionTypeKindArray));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0005\u001a\u00020\u00048\u0007\u00a2\u0006\u0012\n\u0004\b\u0005\u0010\u0006\u0012\u0004\b\t\u0010\u0003\u001a\u0004\b\u0007\u0010\b"}, d2={"Lorg/jetbrains/kotlin/builtins/functions/FunctionTypeKindExtractor$Companion;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/builtins/functions/FunctionTypeKindExtractor;", "Default", "Lorg/jetbrains/kotlin/builtins/functions/FunctionTypeKindExtractor;", "getDefault", "()Lorg/jetbrains/kotlin/builtins/functions/FunctionTypeKindExtractor;", "getDefault$annotations"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FunctionTypeKindExtractor getDefault() {
            return Default;
        }

        public static /* synthetic */ void getDefault$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u0002H\u00c7\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ$\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0004H\u00c7\u0001\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010\u0010\u001a\u00020\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u0004H\u00d6\u0001\u00a2\u0006\u0004\b\u0012\u0010\u000bJ\u0010\u0010\u0014\u001a\u00020\u0013H\u00d7\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0016\u001a\u0004\b\u0017\u0010\tR\u001a\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0018\u001a\u0004\b\u0019\u0010\u000b"}, d2={"Lorg/jetbrains/kotlin/builtins/functions/FunctionTypeKindExtractor$KindWithArity;", "", "Lorg/jetbrains/kotlin/builtins/functions/FunctionTypeKind;", "kind", "", "arity", "<init>", "(Lorg/jetbrains/kotlin/builtins/functions/FunctionTypeKind;I)V", "component1", "()Lorg/jetbrains/kotlin/builtins/functions/FunctionTypeKind;", "component2", "()I", "copy", "(Lorg/jetbrains/kotlin/builtins/functions/FunctionTypeKind;I)Lorg/jetbrains/kotlin/builtins/functions/FunctionTypeKindExtractor$KindWithArity;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "", "toString", "()Ljava/lang/String;", "Lorg/jetbrains/kotlin/builtins/functions/FunctionTypeKind;", "getKind", "I", "getArity"})
    public static final class KindWithArity {
        @NotNull
        private final FunctionTypeKind kind;
        private final int arity;

        public KindWithArity(@NotNull FunctionTypeKind kind, int arity) {
            Intrinsics.checkNotNullParameter(kind, "kind");
            this.kind = kind;
            this.arity = arity;
        }

        @NotNull
        public final FunctionTypeKind getKind() {
            return this.kind;
        }

        public final int getArity() {
            return this.arity;
        }

        @NotNull
        public final FunctionTypeKind component1() {
            return this.kind;
        }

        public final int component2() {
            return this.arity;
        }

        @NotNull
        public final KindWithArity copy(@NotNull FunctionTypeKind kind, int arity) {
            Intrinsics.checkNotNullParameter(kind, "kind");
            return new KindWithArity(kind, arity);
        }

        public static /* synthetic */ KindWithArity copy$default(KindWithArity kindWithArity, FunctionTypeKind functionTypeKind, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                functionTypeKind = kindWithArity.kind;
            }
            if ((n2 & 2) != 0) {
                n = kindWithArity.arity;
            }
            return kindWithArity.copy(functionTypeKind, n);
        }

        @NotNull
        public String toString() {
            return "KindWithArity(kind=" + this.kind + ", arity=" + this.arity + ')';
        }

        public int hashCode() {
            int result2 = this.kind.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.arity);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof KindWithArity)) {
                return false;
            }
            KindWithArity kindWithArity = (KindWithArity)other;
            if (!Intrinsics.areEqual(this.kind, kindWithArity.kind)) {
                return false;
            }
            return this.arity == kindWithArity.arity;
        }
    }
}

