/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cfg;

import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cfg.WhenOnClassExhaustivenessChecker;
import org.jetbrains.kotlin.cfg.WhenOnExpectExhaustivenessChecker;
import org.jetbrains.kotlin.cfg.WhenOnNullableExhaustivenessChecker;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.diagnostics.WhenMissingCase;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J7\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\nH\u0017\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013"}, d2={"Lorg/jetbrains/kotlin/cfg/WhenOnSealedExhaustivenessChecker;", "Lorg/jetbrains/kotlin/cfg/WhenOnClassExhaustivenessChecker;", "<init>", "()V", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "expression", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "context", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "subjectDescriptor", "", "nullable", "", "Lorg/jetbrains/kotlin/diagnostics/WhenMissingCase;", "getMissingCases", "(Lorg/jetbrains/kotlin/psi/KtWhenExpression;Lorg/jetbrains/kotlin/resolve/BindingContext;Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;Z)Ljava/util/List;", "Lorg/jetbrains/kotlin/types/KotlinType;", "subjectType", "isApplicable", "(Lorg/jetbrains/kotlin/types/KotlinType;)Z"})
public final class WhenOnSealedExhaustivenessChecker
extends WhenOnClassExhaustivenessChecker {
    @NotNull
    public static final WhenOnSealedExhaustivenessChecker INSTANCE = new WhenOnSealedExhaustivenessChecker();

    private WhenOnSealedExhaustivenessChecker() {
    }

    @Override
    @NotNull
    public List<WhenMissingCase> getMissingCases(@NotNull KtWhenExpression expression, @NotNull BindingContext context, @Nullable ClassDescriptor subjectDescriptor, boolean nullable) {
        List list;
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        boolean bl = DescriptorUtils.isSealedClass(subjectDescriptor);
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string2 = "isWhenOnSealedClassExhaustive should be called with a sealed class descriptor: " + subjectDescriptor;
            throw new AssertionError((Object)string2);
        }
        ClassDescriptor classDescriptor = subjectDescriptor;
        Intrinsics.checkNotNull(classDescriptor);
        Set<ClassDescriptor> allSubclasses = this.getDeepSealedSubclasses(classDescriptor);
        List $this$getMissingCases_u24lambda_u241 = list = kotlin.collections.CollectionsKt.createListBuilder();
        boolean bl3 = false;
        $this$getMissingCases_u24lambda_u241.addAll(INSTANCE.getMissingClassCases(expression, kotlin.collections.CollectionsKt.toSet((Iterable)allSubclasses), context));
        $this$getMissingCases_u24lambda_u241.addAll(WhenOnNullableExhaustivenessChecker.INSTANCE.getMissingCases(expression, context, nullable));
        CollectionsKt.addIfNotNull($this$getMissingCases_u24lambda_u241, WhenOnExpectExhaustivenessChecker.INSTANCE.getMissingCase(subjectDescriptor));
        return kotlin.collections.CollectionsKt.build(list);
    }

    @Override
    public boolean isApplicable(@NotNull KotlinType subjectType) {
        Intrinsics.checkNotNullParameter(subjectType, "subjectType");
        return DescriptorUtils.isSealedClass(TypeUtils.getClassDescriptor(subjectType));
    }
}

