/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common;

import java.io.File;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CodeAnalysisMeasurement;
import org.jetbrains.kotlin.cli.common.CodeGenerationMeasurement;
import org.jetbrains.kotlin.cli.common.CompilerInitializationMeasurement;
import org.jetbrains.kotlin.cli.common.GarbageCollectionMeasurement;
import org.jetbrains.kotlin.cli.common.IRMeasurement;
import org.jetbrains.kotlin.cli.common.JitCompilationMeasurement;
import org.jetbrains.kotlin.cli.common.PerformanceCounterMeasurement;
import org.jetbrains.kotlin.cli.common.PerformanceMeasurement;
import org.jetbrains.kotlin.util.PerformanceCounter;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\r\b&\u0018\u00002\u00020\u0001:\u0001PB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0006\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\r\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J'\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000f\u0010\u0019\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u0019\u0010\u000eJ\u001f\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u000f\u0010\u001c\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u001c\u0010\u000eJ\u000f\u0010\u001d\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u000eJ\u000f\u0010\u001e\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u001e\u0010\u000eJ\u000f\u0010\u001f\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u001f\u0010\u000eJ\u000f\u0010 \u001a\u00020\fH\u0016\u00a2\u0006\u0004\b \u0010\u000eJ\u000f\u0010!\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b!\u0010\u000eJ\u000f\u0010\"\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\"\u0010\u000eJ\u000f\u0010#\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b#\u0010\u000eJ\u000f\u0010$\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b$\u0010\u000eJ\u000f\u0010%\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b%\u0010\u000eJ\u0015\u0010(\u001a\u00020\f2\u0006\u0010'\u001a\u00020&\u00a2\u0006\u0004\b(\u0010)J\u000f\u0010*\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b*\u0010\u000eJ\u000f\u0010+\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b+\u0010\u000eJ\u000f\u0010,\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b,\u0010\u000eJ\u000f\u0010-\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b-\u0010\u000eJ\u000f\u0010/\u001a\u00020.H\u0002\u00a2\u0006\u0004\b/\u00100J\u000f\u00101\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b1\u0010\u0007R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u00102R&\u00104\u001a\b\u0012\u0004\u0012\u00020\t038\u0005X\u0084\u0004\u00a2\u0006\u0012\n\u0004\b4\u00105\u0012\u0004\b7\u0010\u000e\u001a\u0004\b6\u0010\u000bR\"\u00109\u001a\u0002088\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0012\n\u0004\b9\u0010:\u001a\u0004\b9\u0010;\"\u0004\b<\u0010=R\u0016\u0010>\u001a\u00020\u000f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b>\u0010?R\u0016\u0010@\u001a\u00020\u000f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b@\u0010?R\u0016\u0010A\u001a\u00020\u000f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bA\u0010?R\"\u0010D\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020C0B8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\bD\u0010ER\u0016\u0010F\u001a\u00020\u000f8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\bF\u0010?R\u0016\u0010G\u001a\u00020\u000f8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\bG\u0010?R\u0016\u0010H\u001a\u00020\u000f8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\bH\u0010?R\u0018\u0010\u0016\u001a\u0004\u0018\u00010\u00028\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u0016\u00102R$\u0010\u0014\u001a\u0004\u0018\u00010\u00138\u0005@\u0004X\u0085\u000e\u00a2\u0006\u0012\n\u0004\b\u0014\u0010I\u001a\u0004\bJ\u0010K\"\u0004\bL\u0010MR$\u0010\u0015\u001a\u0004\u0018\u00010\u00138\u0005@\u0004X\u0085\u000e\u00a2\u0006\u0012\n\u0004\b\u0015\u0010I\u001a\u0004\bN\u0010K\"\u0004\bO\u0010M"}, d2={"Lorg/jetbrains/kotlin/cli/common/CommonCompilerPerformanceManager;", "", "", "presentableName", "<init>", "(Ljava/lang/String;)V", "getTargetInfo", "()Ljava/lang/String;", "", "Lorg/jetbrains/kotlin/cli/common/PerformanceMeasurement;", "getMeasurementResults", "()Ljava/util/List;", "", "enableCollectingPerformanceStatistics", "()V", "", "start", "deltaTime", "(J)J", "", "files", "lines", "targetDescription", "notifyCompilerInitialized", "(IILjava/lang/String;)V", "notifyCompilationFinished", "addSourcesStats", "(II)V", "notifyAnalysisStarted", "notifyAnalysisFinished", "notifyGenerationStarted", "notifyGenerationFinished", "notifyIRTranslationStarted", "notifyIRTranslationFinished", "notifyIRLoweringStarted", "notifyIRLoweringFinished", "notifyIRGenerationStarted", "notifyIRGenerationFinished", "Ljava/io/File;", "destination", "dumpPerformanceReport", "(Ljava/io/File;)V", "recordGcTime", "recordJitCompilationTime", "recordInitializationTime", "recordPerfCountersMeasurements", "", "createPerformanceReport", "()[B", "renderCompilerPerformance", "Ljava/lang/String;", "", "measurements", "Ljava/util/List;", "getMeasurements", "getMeasurements$annotations", "", "isEnabled", "Z", "()Z", "setEnabled", "(Z)V", "initStartNanos", "J", "analysisStart", "generationStart", "", "Lorg/jetbrains/kotlin/cli/common/CommonCompilerPerformanceManager$GCData;", "startGCData", "Ljava/util/Map;", "irTranslationStart", "irLoweringStart", "irGenerationStart", "Ljava/lang/Integer;", "getFiles", "()Ljava/lang/Integer;", "setFiles", "(Ljava/lang/Integer;)V", "getLines", "setLines", "GCData"})
public abstract class CommonCompilerPerformanceManager {
    @NotNull
    private final String presentableName;
    @NotNull
    private final List<PerformanceMeasurement> measurements;
    private boolean isEnabled;
    private long initStartNanos;
    private long analysisStart;
    private long generationStart;
    @NotNull
    private Map<String, GCData> startGCData;
    private long irTranslationStart;
    private long irLoweringStart;
    private long irGenerationStart;
    @Nullable
    private String targetDescription;
    @Nullable
    private Integer files;
    @Nullable
    private Integer lines;

    public CommonCompilerPerformanceManager(@NotNull String presentableName2) {
        Intrinsics.checkNotNullParameter(presentableName2, "presentableName");
        this.presentableName = presentableName2;
        this.measurements = new ArrayList();
        this.initStartNanos = PerformanceCounter.Companion.currentTime();
        this.startGCData = new LinkedHashMap();
    }

    @NotNull
    protected final List<PerformanceMeasurement> getMeasurements() {
        return this.measurements;
    }

    protected static /* synthetic */ void getMeasurements$annotations() {
    }

    protected final boolean isEnabled() {
        return this.isEnabled;
    }

    protected final void setEnabled(boolean bl) {
        this.isEnabled = bl;
    }

    @Nullable
    protected final Integer getFiles() {
        return this.files;
    }

    protected final void setFiles(@Nullable Integer n) {
        this.files = n;
    }

    @Nullable
    protected final Integer getLines() {
        return this.lines;
    }

    protected final void setLines(@Nullable Integer n) {
        this.lines = n;
    }

    @NotNull
    public final String getTargetInfo() {
        return this.targetDescription + ", " + this.files + " files (" + this.lines + " lines)";
    }

    @NotNull
    public final List<PerformanceMeasurement> getMeasurementResults() {
        return this.measurements;
    }

    /*
     * WARNING - void declaration
     */
    public final void enableCollectingPerformanceStatistics() {
        void $this$associateTo$iv;
        this.isEnabled = true;
        PerformanceCounter.Companion.setTimeCounterEnabled(true);
        List<GarbageCollectorMXBean> list = ManagementFactory.getGarbageCollectorMXBeans();
        Intrinsics.checkNotNullExpressionValue(list, "getGarbageCollectorMXBeans(...)");
        Iterable iterable = list;
        Map<String, GCData> destination$iv = this.startGCData;
        boolean $i$f$associateTo = false;
        for (Object element$iv : $this$associateTo$iv) {
            Map<String, GCData> map2 = destination$iv;
            GarbageCollectorMXBean it = (GarbageCollectorMXBean)element$iv;
            boolean bl = false;
            String string2 = it.getName();
            Intrinsics.checkNotNull(it);
            Pair<String, GCData> pair = TuplesKt.to(string2, new GCData(it));
            map2.put(pair.getFirst(), pair.getSecond());
        }
    }

    private final long deltaTime(long start) {
        return PerformanceCounter.Companion.currentTime() - start;
    }

    public void notifyCompilerInitialized(int files2, int lines, @NotNull String targetDescription) {
        Intrinsics.checkNotNullParameter(targetDescription, "targetDescription");
        if (!this.isEnabled) {
            return;
        }
        this.recordInitializationTime();
        this.files = files2;
        this.lines = lines;
        this.targetDescription = targetDescription;
    }

    public void notifyCompilationFinished() {
        if (!this.isEnabled) {
            return;
        }
        this.recordGcTime();
        this.recordJitCompilationTime();
        this.recordPerfCountersMeasurements();
    }

    public void addSourcesStats(int files2, int lines) {
        if (!this.isEnabled) {
            return;
        }
        Integer n = this.files;
        this.files = n != null ? Integer.valueOf(n + files2) : Integer.valueOf(files2);
        Integer n2 = this.lines;
        this.lines = n2 != null ? Integer.valueOf(n2 + lines) : Integer.valueOf(lines);
    }

    public void notifyAnalysisStarted() {
        this.analysisStart = PerformanceCounter.Companion.currentTime();
    }

    public void notifyAnalysisFinished() {
        long time = PerformanceCounter.Companion.currentTime() - this.analysisStart;
        ((Collection)this.measurements).add(new CodeAnalysisMeasurement(this.lines, TimeUnit.NANOSECONDS.toMillis(time)));
    }

    public void notifyGenerationStarted() {
        this.generationStart = PerformanceCounter.Companion.currentTime();
    }

    public void notifyGenerationFinished() {
        long time = PerformanceCounter.Companion.currentTime() - this.generationStart;
        ((Collection)this.measurements).add(new CodeGenerationMeasurement(this.lines, TimeUnit.NANOSECONDS.toMillis(time)));
    }

    public void notifyIRTranslationStarted() {
        this.irTranslationStart = PerformanceCounter.Companion.currentTime();
    }

    public void notifyIRTranslationFinished() {
        long time = this.deltaTime(this.irTranslationStart);
        ((Collection)this.measurements).add(new IRMeasurement(this.lines, TimeUnit.NANOSECONDS.toMillis(time), IRMeasurement.Kind.TRANSLATION));
    }

    public void notifyIRLoweringStarted() {
        this.irLoweringStart = PerformanceCounter.Companion.currentTime();
    }

    public void notifyIRLoweringFinished() {
        long time = this.deltaTime(this.irLoweringStart);
        ((Collection)this.measurements).add(new IRMeasurement(this.lines, TimeUnit.NANOSECONDS.toMillis(time), IRMeasurement.Kind.LOWERING));
    }

    public void notifyIRGenerationStarted() {
        this.irGenerationStart = PerformanceCounter.Companion.currentTime();
    }

    public void notifyIRGenerationFinished() {
        long time = this.deltaTime(this.irGenerationStart);
        ((Collection)this.measurements).add(new IRMeasurement(this.lines, TimeUnit.NANOSECONDS.toMillis(time), IRMeasurement.Kind.GENERATION));
    }

    public final void dumpPerformanceReport(@NotNull File destination) {
        Intrinsics.checkNotNullParameter(destination, "destination");
        FilesKt.writeBytes(destination, this.createPerformanceReport());
    }

    private final void recordGcTime() {
        if (!this.isEnabled) {
            return;
        }
        List<GarbageCollectorMXBean> list = ManagementFactory.getGarbageCollectorMXBeans();
        Intrinsics.checkNotNullExpressionValue(list, "getGarbageCollectorMXBeans(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GCData startCounts;
            GarbageCollectorMXBean it = (GarbageCollectorMXBean)element$iv;
            boolean bl = false;
            GCData gCData = startCounts = this.startGCData.get(it.getName());
            long startCollectionTime = gCData != null ? gCData.getCollectionTime() : 0L;
            GCData gCData2 = startCounts;
            long startCollectionCount = gCData2 != null ? gCData2.getCollectionCount() : 0L;
            Collection collection = this.measurements;
            String string2 = it.getName();
            Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
            collection.add(new GarbageCollectionMeasurement(string2, it.getCollectionTime() - startCollectionTime, it.getCollectionCount() - startCollectionCount));
        }
    }

    private final void recordJitCompilationTime() {
        if (!this.isEnabled) {
            return;
        }
        CompilationMXBean compilationMXBean = ManagementFactory.getCompilationMXBean();
        if (compilationMXBean == null) {
            return;
        }
        CompilationMXBean bean = compilationMXBean;
        ((Collection)this.measurements).add(new JitCompilationMeasurement(bean.getTotalCompilationTime()));
    }

    private final void recordInitializationTime() {
        long time = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.initStartNanos);
        ((Collection)this.measurements).add(new CompilerInitializationMeasurement(time));
    }

    private final void recordPerfCountersMeasurements() {
        PerformanceCounter.Companion.report(arg_0 -> CommonCompilerPerformanceManager.recordPerfCountersMeasurements$lambda$2(this, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private final byte[] createPerformanceReport() {
        void $this$mapTo$iv$iv;
        CharSequence charSequence = new StringBuilder();
        StringBuilder $this$createPerformanceReport_u24lambda_u245 = charSequence;
        boolean bl = false;
        $this$createPerformanceReport_u24lambda_u245.append(this.presentableName + " performance report\n");
        Iterable $this$map$iv = this.measurements;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PerformanceMeasurement performanceMeasurement = (PerformanceMeasurement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it.render());
        }
        Iterable $this$forEach$iv = CollectionsKt.sorted((List)destination$iv$iv);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl3 = false;
            $this$createPerformanceReport_u24lambda_u245.append(it + '\n');
        }
        charSequence = ((StringBuilder)charSequence).toString();
        byte[] byArray = ((String)charSequence).getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String renderCompilerPerformance() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getMeasurementResults();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PerformanceMeasurement it = (PerformanceMeasurement)element$iv$iv;
            boolean bl = false;
            if (!(it instanceof CompilerInitializationMeasurement || it instanceof CodeAnalysisMeasurement || it instanceof CodeGenerationMeasurement || it instanceof PerformanceCounterMeasurement)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List relevantMeasurements = (List)destination$iv$iv;
        return "Compiler perf stats:\n" + CollectionsKt.joinToString$default(relevantMeasurements, "\n", null, null, 0, null, CommonCompilerPerformanceManager::renderCompilerPerformance$lambda$7, 30, null);
    }

    private static final Unit recordPerfCountersMeasurements$lambda$2(CommonCompilerPerformanceManager this$0, String s) {
        Intrinsics.checkNotNullParameter(s, "s");
        ((Collection)this$0.measurements).add(new PerformanceCounterMeasurement(s));
        return Unit.INSTANCE;
    }

    private static final CharSequence renderCompilerPerformance$lambda$7(PerformanceMeasurement it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return "  " + it.render();
    }

    private static final class GCData {
        @NotNull
        private final String name;
        private final long collectionTime;
        private final long collectionCount;

        public GCData(@NotNull String name, long collectionTime, long collectionCount) {
            Intrinsics.checkNotNullParameter(name, "name");
            this.name = name;
            this.collectionTime = collectionTime;
            this.collectionCount = collectionCount;
        }

        public final long getCollectionTime() {
            return this.collectionTime;
        }

        public final long getCollectionCount() {
            return this.collectionCount;
        }

        public GCData(@NotNull GarbageCollectorMXBean bean) {
            Intrinsics.checkNotNullParameter(bean, "bean");
            String string2 = bean.getName();
            Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
            this(string2, bean.getCollectionTime(), bean.getCollectionCount());
        }

        @NotNull
        public String toString() {
            return "GCData(name=" + this.name + ", collectionTime=" + this.collectionTime + ", collectionCount=" + this.collectionCount + ')';
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = result2 * 31 + Long.hashCode(this.collectionTime);
            result2 = result2 * 31 + Long.hashCode(this.collectionCount);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof GCData)) {
                return false;
            }
            GCData gCData = (GCData)other;
            if (!Intrinsics.areEqual(this.name, gCData.name)) {
                return false;
            }
            if (this.collectionTime != gCData.collectionTime) {
                return false;
            }
            return this.collectionCount == gCData.collectionCount;
        }
    }
}

