/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.localfs;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.localfs.KotlinLocalFileSystem;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

public final class KotlinLocalVirtualFile
extends VirtualFile {
    @NotNull
    private final File file;
    @NotNull
    private final KotlinLocalFileSystem _fileSystem;
    @Nullable
    private String _name;
    @Nullable
    private KotlinLocalVirtualFile _parent;
    @Nullable
    private Boolean _isDirectory;
    @Nullable
    private VirtualFile[] _children;

    public KotlinLocalVirtualFile(@NotNull File file2, @NotNull KotlinLocalFileSystem _fileSystem, @Nullable KotlinLocalVirtualFile parent2) {
        Intrinsics.checkNotNullParameter(file2, "file");
        Intrinsics.checkNotNullParameter(_fileSystem, "_fileSystem");
        this.file = file2;
        this._fileSystem = _fileSystem;
        this._parent = parent2;
    }

    public /* synthetic */ KotlinLocalVirtualFile(File file2, KotlinLocalFileSystem kotlinLocalFileSystem, KotlinLocalVirtualFile kotlinLocalVirtualFile, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            kotlinLocalVirtualFile = null;
        }
        this(file2, kotlinLocalFileSystem, kotlinLocalVirtualFile);
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    @Override
    @NotNull
    public String getName() {
        String string2;
        String string3 = this._name;
        if (string3 != null) {
            String it = string3;
            boolean bl = false;
            return it;
        }
        String it = string2 = this.file.getName();
        boolean bl = false;
        this._name = it;
        String string4 = string2;
        Intrinsics.checkNotNullExpressionValue(string4, "also(...)");
        return string4;
    }

    @Override
    @NotNull
    public VirtualFileSystem getFileSystem() {
        return this._fileSystem;
    }

    @Override
    @NotNull
    public String getPath() {
        String string2 = FileUtil.toSystemIndependentName(this.file.getAbsolutePath());
        Intrinsics.checkNotNullExpressionValue(string2, "toSystemIndependentName(...)");
        return string2;
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public boolean isDirectory() {
        boolean bl;
        Boolean bl2 = this._isDirectory;
        if (bl2 != null) {
            boolean it = bl2;
            boolean bl3 = false;
            return it;
        }
        boolean it = bl = this.file.isDirectory();
        boolean bl4 = false;
        this._isDirectory = it;
        return bl;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    @Nullable
    public VirtualFile getParent() {
        KotlinLocalVirtualFile kotlinLocalVirtualFile;
        KotlinLocalVirtualFile kotlinLocalVirtualFile2 = this._parent;
        if (kotlinLocalVirtualFile2 != null) {
            KotlinLocalVirtualFile it = kotlinLocalVirtualFile2;
            boolean bl = false;
            return it;
        }
        File file2 = this.file.getParentFile();
        if (file2 == null) {
            return null;
        }
        File parentFile = file2;
        KotlinLocalVirtualFile it = kotlinLocalVirtualFile = new KotlinLocalVirtualFile(parentFile, this._fileSystem, null, 4, null);
        boolean bl = false;
        this._parent = it;
        return kotlinLocalVirtualFile;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public VirtualFile[] getChildren() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        File[] fileChildren;
        VirtualFile[] virtualFileArray = this._children;
        if (virtualFileArray != null) {
            VirtualFile[] it = virtualFileArray;
            boolean bl = false;
            return it;
        }
        File[] fileArray = this.file.listFiles();
        if (fileArray == null) {
            fileArray = new File[]{};
        }
        File[] fileArray2 = fileChildren = fileArray;
        KotlinLocalVirtualFile kotlinLocalVirtualFile = this;
        boolean $i$f$map = false;
        void bl = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var10_13 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull(it);
            collection.add(new KotlinLocalVirtualFile((File)it, this._fileSystem, this));
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        Collection $this$toTypedArray$iv = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                KotlinLocalVirtualFile it = (KotlinLocalVirtualFile)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (KotlinLocalVirtualFile)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it.getName()));
            }
        });
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        kotlinLocalVirtualFile._children = thisCollection$iv.toArray(new VirtualFile[0]);
        Intrinsics.checkNotNull(this._children);
        return this._children;
    }

    @Override
    @Nullable
    public VirtualFile findChild(@NotNull String name) {
        VirtualFile virtualFile;
        block3: {
            Intrinsics.checkNotNullParameter(name, "name");
            KotlinLocalVirtualFile kotlinLocalVirtualFile = this;
            VirtualFile[] $this$binarySearchBy$iv = this.getChildren();
            boolean $i$f$binarySearchBy = false;
            int low$iv = 0;
            int high$iv = $this$binarySearchBy$iv.length - 1;
            while (low$iv <= high$iv) {
                VirtualFile midVal$iv;
                int mid$iv = low$iv + high$iv >>> 1;
                VirtualFile it = midVal$iv = $this$binarySearchBy$iv[mid$iv];
                boolean bl = false;
                String string2 = it.getName();
                Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
                int cmp$iv = ComparisonsKt.compareValues((Comparable)((Object)string2), (Comparable)((Object)name));
                if (cmp$iv < 0) {
                    low$iv = mid$iv + 1;
                    continue;
                }
                if (cmp$iv > 0) {
                    high$iv = mid$iv - 1;
                    continue;
                }
                virtualFile = midVal$iv;
                break block3;
            }
            virtualFile = null;
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public OutputStream getOutputStream(@Nullable Object requestor, long newModificationStamp, long newTimeStamp) {
        AddToStdlibKt.shouldNotBeCalled$default(null, 1, null);
        throw new KotlinNothingValueException();
    }

    @Override
    @NotNull
    public byte[] contentsToByteArray() {
        byte[] byArray = FileUtil.loadFileBytes(this.file);
        Intrinsics.checkNotNullExpressionValue(byArray, "loadFileBytes(...)");
        return byArray;
    }

    @Override
    public long getTimeStamp() {
        return this.file.lastModified();
    }

    @Override
    public long getLength() {
        return this.file.length();
    }

    @Override
    public void refresh(boolean asynchronous, boolean recursive, @Nullable Runnable postRunnable) {
    }

    @Override
    @NotNull
    public InputStream getInputStream() {
        InputStream inputStream = VfsUtilCore.inputStreamSkippingBOM(new BufferedInputStream(new FileInputStream(this.file)), this);
        Intrinsics.checkNotNullExpressionValue(inputStream, "inputStreamSkippingBOM(...)");
        return inputStream;
    }

    @Override
    public long getModificationStamp() {
        return 0L;
    }

    @Override
    public boolean isInLocalFileSystem() {
        return true;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull(other, "null cannot be cast to non-null type org.jetbrains.kotlin.cli.common.localfs.KotlinLocalVirtualFile");
        KotlinLocalVirtualFile cfr_ignored_0 = (KotlinLocalVirtualFile)other;
        return Intrinsics.areEqual(this.file, ((KotlinLocalVirtualFile)other).file);
    }

    public int hashCode() {
        return this.file.hashCode();
    }
}

