/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler;

import com.intellij.openapi.project.Project;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTraceContext;
import org.jetbrains.kotlin.resolve.lazy.KotlinCodeAnalyzer;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

public class CliBindingTrace
extends BindingTraceContext {
    @Nullable
    private KotlinCodeAnalyzer kotlinCodeAnalyzer;

    public CliBindingTrace(@NotNull Project project) {
        Intrinsics.checkNotNullParameter(project, "project");
        super(project);
    }

    @NotNull
    public String toString() {
        String string2 = CliBindingTrace.class.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
        return string2;
    }

    public final void setKotlinCodeAnalyzer(@NotNull KotlinCodeAnalyzer kotlinCodeAnalyzer) {
        Intrinsics.checkNotNullParameter(kotlinCodeAnalyzer, "kotlinCodeAnalyzer");
        this.kotlinCodeAnalyzer = kotlinCodeAnalyzer;
    }

    @Override
    @Nullable
    public <K, V> V get(@NotNull ReadOnlySlice<K, V> slice, K key) {
        Intrinsics.checkNotNullParameter(slice, "slice");
        V value2 = super.get(slice, key);
        if (value2 == null && key instanceof KtDeclaration) {
            if (BindingContext.FUNCTION == slice && !KtPsiUtil.isLocal((KtDeclaration)key)) {
                KotlinCodeAnalyzer kotlinCodeAnalyzer = this.kotlinCodeAnalyzer;
                Intrinsics.checkNotNull(kotlinCodeAnalyzer);
                kotlinCodeAnalyzer.resolveToDescriptor((KtDeclaration)key);
                return super.get(slice, key);
            }
            if (BindingContext.VARIABLE == slice && !KtPsiUtil.isLocal((KtDeclaration)key)) {
                KotlinCodeAnalyzer kotlinCodeAnalyzer = this.kotlinCodeAnalyzer;
                Intrinsics.checkNotNull(kotlinCodeAnalyzer);
                kotlinCodeAnalyzer.resolveToDescriptor((KtDeclaration)key);
                return super.get(slice, key);
            }
        }
        return value2;
    }
}

