/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.KotlinAsJavaSupportBase;
import org.jetbrains.kotlin.asJava.LightClassGenerationSupport;
import org.jetbrains.kotlin.asJava.classes.KtDescriptorBasedFakeLightClass;
import org.jetbrains.kotlin.asJava.classes.KtFakeLightClass;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForFacade;
import org.jetbrains.kotlin.cli.jvm.compiler.CliTraceHolder;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.load.java.components.FilesByFacadeFqNameIndexer;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.lazy.ResolveSessionUtils;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;

public final class CliKotlinAsJavaSupport
extends KotlinAsJavaSupportBase<KtFile> {
    @NotNull
    private final CliTraceHolder traceHolder;

    public CliKotlinAsJavaSupport(@NotNull Project project, @NotNull CliTraceHolder traceHolder) {
        Intrinsics.checkNotNullParameter(project, "project");
        Intrinsics.checkNotNullParameter(traceHolder, "traceHolder");
        super(project);
        this.traceHolder = traceHolder;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<KtFile> findFilesForFacadeByPackage(@NotNull FqName packageFqName, @NotNull GlobalSearchScope searchScope) {
        List list;
        List list2;
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        Intrinsics.checkNotNullParameter(searchScope, "searchScope");
        Collection collection = (Collection)this.traceHolder.getBindingContext().get(FilesByFacadeFqNameIndexer.FACADE_FILES_BY_PACKAGE_NAME, packageFqName);
        if (collection != null) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Iterable iterable = collection;
            boolean $i$f$filter = false;
            void var6_6 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                KtFile it = (KtFile)element$iv$iv;
                boolean bl = false;
                if (!PsiSearchScopeUtil.isInScope(searchScope, (PsiElement)it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = list = null;
        }
        if (list2 == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @NotNull
    protected KtFile findModule(@NotNull KtFile $this$findModule) {
        Intrinsics.checkNotNullParameter($this$findModule, "<this>");
        return $this$findModule;
    }

    @Override
    @Nullable
    protected KtLightClassForFacade createInstanceOfDecompiledLightFacade(@NotNull FqName facadeFqName, @NotNull List<? extends KtFile> files2) {
        Intrinsics.checkNotNullParameter(facadeFqName, "facadeFqName");
        Intrinsics.checkNotNullParameter(files2, "files");
        throw new IllegalStateException("Should not be called".toString());
    }

    @Override
    @NotNull
    public ModificationTracker projectWideOutOfBlockModificationTracker() {
        ModificationTracker modificationTracker = ModificationTracker.NEVER_CHANGED;
        Intrinsics.checkNotNullExpressionValue(modificationTracker, "NEVER_CHANGED");
        return modificationTracker;
    }

    @Override
    @NotNull
    public ModificationTracker librariesTracker(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter(element, "element");
        throw new IllegalStateException("Should not be called".toString());
    }

    @Override
    @NotNull
    protected KtLightClassForFacade createInstanceOfLightFacade(@NotNull FqName facadeFqName, @NotNull List<? extends KtFile> files2) {
        Intrinsics.checkNotNullParameter(facadeFqName, "facadeFqName");
        Intrinsics.checkNotNullParameter(files2, "files");
        Project project = CollectionsKt.first(files2).getProject();
        Intrinsics.checkNotNullExpressionValue(project, "getProject(...)");
        return LightClassGenerationSupport.Companion.getInstance(project).createUltraLightClassForFacade(facadeFqName, (Collection<? extends KtFile>)files2);
    }

    @Override
    @NotNull
    protected GlobalSearchScope getContentSearchScope(@NotNull KtFile $this$contentSearchScope) {
        Intrinsics.checkNotNullParameter($this$contentSearchScope, "<this>");
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope($this$contentSearchScope.getProject());
        Intrinsics.checkNotNullExpressionValue(globalSearchScope, "allScope(...)");
        return globalSearchScope;
    }

    @Override
    protected boolean facadeIsApplicable(@NotNull KtFile module2, @NotNull KtFile file2) {
        Intrinsics.checkNotNullParameter(module2, "module");
        Intrinsics.checkNotNullParameter(file2, "file");
        return !module2.isCompiled();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<KtFile> findFilesForFacade(@NotNull FqName facadeFqName, @NotNull GlobalSearchScope searchScope) {
        List list;
        List list2;
        Intrinsics.checkNotNullParameter(facadeFqName, "facadeFqName");
        Intrinsics.checkNotNullParameter(searchScope, "searchScope");
        if (facadeFqName.isRoot()) {
            return CollectionsKt.emptyList();
        }
        Collection collection = (Collection)this.traceHolder.getBindingContext().get(FilesByFacadeFqNameIndexer.FACADE_FILES_BY_FQ_NAME, facadeFqName);
        if (collection != null) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = collection;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                KtFile it = (KtFile)element$iv$iv;
                boolean bl = false;
                if (!PsiSearchScopeUtil.isInScope(searchScope, (PsiElement)it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = list = null;
        }
        if (list2 == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @NotNull
    public Collection<PsiClass> getKotlinInternalClasses(@NotNull FqName fqName2, @NotNull GlobalSearchScope scope2) {
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        Intrinsics.checkNotNullParameter(scope2, "scope");
        return CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public KtFakeLightClass getFakeLightClass(@NotNull KtClassOrObject classOrObject) {
        Intrinsics.checkNotNullParameter(classOrObject, "classOrObject");
        return new KtDescriptorBasedFakeLightClass(classOrObject);
    }

    @Override
    @NotNull
    public Collection<KtClassOrObject> findClassOrObjectDeclarationsInPackage(@NotNull FqName packageFqName, @NotNull GlobalSearchScope searchScope) {
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        Intrinsics.checkNotNullParameter(searchScope, "searchScope");
        Collection<KtFile> files2 = this.findFilesForPackage(packageFqName, searchScope);
        SmartList<KtDeclaration> result2 = new SmartList<KtDeclaration>();
        for (KtFile file2 : files2) {
            for (KtDeclaration declaration : file2.getDeclarations()) {
                if (!(declaration instanceof KtClassOrObject)) continue;
                result2.add(declaration);
            }
        }
        return result2;
    }

    @Override
    public boolean packageExists(@NotNull FqName fqName2, @NotNull GlobalSearchScope scope2) {
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        Intrinsics.checkNotNullParameter(scope2, "scope");
        return !this.traceHolder.getModule().getPackage(fqName2).isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<FqName> getSubPackages(@NotNull FqName fqn, @NotNull GlobalSearchScope scope2) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter(fqn, "fqn");
        Intrinsics.checkNotNullParameter(scope2, "scope");
        PackageViewDescriptor packageView = this.traceHolder.getModule().getPackage(fqn);
        Iterable iterable = packageView.getMemberScope().getContributedDescriptors(DescriptorKindFilter.PACKAGES, MemberScope.Companion.getALL_NAME_FILTER());
        boolean $i$f$mapNotNull = false;
        void var6_6 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            FqName it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            DeclarationDescriptor member = (DeclarationDescriptor)element$iv$iv;
            boolean bl2 = false;
            PackageViewDescriptor packageViewDescriptor = member instanceof PackageViewDescriptor ? (PackageViewDescriptor)member : null;
            if ((packageViewDescriptor != null ? packageViewDescriptor.getFqName() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    protected KtLightClass createInstanceOfLightScript(@NotNull KtScript script) {
        Intrinsics.checkNotNullParameter(script, "script");
        Project project = script.getProject();
        Intrinsics.checkNotNullExpressionValue(project, "getProject(...)");
        return LightClassGenerationSupport.Companion.getInstance(project).createUltraLightClassForScript(script);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<KtClassOrObject> findClassOrObjectDeclarations(@NotNull FqName fqName2, @NotNull GlobalSearchScope searchScope) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        Intrinsics.checkNotNullParameter(searchScope, "searchScope");
        Collection<ClassDescriptor> collection = ResolveSessionUtils.getClassDescriptorsByFqName(this.traceHolder.getModule(), fqName2);
        Intrinsics.checkNotNullExpressionValue(collection, "getClassDescriptorsByFqName(...)");
        Iterable $this$mapNotNull$iv = collection;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            KtClassOrObject it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            ClassDescriptor it = (ClassDescriptor)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull(it);
            PsiElement element = DescriptorToSourceUtils.getSourceFromDescriptor(it);
            if ((element instanceof KtClassOrObject && PsiSearchScopeUtil.isInScope(searchScope, element) ? (KtClassOrObject)element : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<KtFile> findFilesForPackage(@NotNull FqName packageFqName, @NotNull GlobalSearchScope searchScope) {
        List list;
        List list2;
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        Intrinsics.checkNotNullParameter(searchScope, "searchScope");
        Collection collection = (Collection)this.traceHolder.getBindingContext().get(BindingContext.PACKAGE_TO_FILES, packageFqName);
        if (collection != null) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = collection;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                KtFile it = (KtFile)element$iv$iv;
                boolean bl = false;
                if (!PsiSearchScopeUtil.isInScope(searchScope, (PsiElement)it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = list = null;
        }
        if (list2 == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<KtScript> findFilesForScript(@NotNull FqName scriptFqName, @NotNull GlobalSearchScope searchScope) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(scriptFqName, "scriptFqName");
        Intrinsics.checkNotNullParameter(searchScope, "searchScope");
        Iterable $this$mapNotNull$iv = this.findFilesForPackage(scriptFqName.parent(), searchScope);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            KtScript ktScript;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            KtFile file2 = (KtFile)element$iv$iv;
            boolean bl2 = false;
            if (file2.getScript() != null) {
                KtScript ktScript2;
                KtScript it = ktScript2;
                boolean bl3 = false;
                ktScript = Intrinsics.areEqual(it.getFqName(), scriptFqName) ? ktScript2 : null;
            } else {
                ktScript = null;
            }
            if (ktScript == null) continue;
            KtScript it$iv$iv = ktScript;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public KtLightClassForFacade createFacadeForSyntheticFile(@NotNull KtFile file2) {
        Intrinsics.checkNotNullParameter(file2, "file");
        throw new IllegalStateException("Should not be called".toString());
    }

    @Override
    @NotNull
    protected KotlinAsJavaSupportBase.DeclarationLocation declarationLocation(@NotNull KtFile file2) {
        Intrinsics.checkNotNullParameter(file2, "file");
        return KotlinAsJavaSupportBase.DeclarationLocation.ProjectSources;
    }

    @Override
    @NotNull
    protected KtLightClass createInstanceOfDecompiledLightClass(@NotNull KtClassOrObject classOrObject) {
        Intrinsics.checkNotNullParameter(classOrObject, "classOrObject");
        throw new IllegalStateException("Should not be called".toString());
    }

    @Override
    @NotNull
    protected KtLightClass createInstanceOfLightClass(@NotNull KtClassOrObject classOrObject) {
        Intrinsics.checkNotNullParameter(classOrObject, "classOrObject");
        Project project = classOrObject.getProject();
        Intrinsics.checkNotNullExpressionValue(project, "getProject(...)");
        return LightClassGenerationSupport.Companion.getInstance(project).createUltraLightClass(classOrObject);
    }
}

