/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler;

import com.intellij.openapi.project.Project;
import kotlin.Lazy;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassGenerationSupport;
import org.jetbrains.kotlin.asJava.classes.ImplUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtUltraLightSupport;
import org.jetbrains.kotlin.cli.jvm.compiler.CliLightClassGenerationSupport;
import org.jetbrains.kotlin.cli.jvm.compiler.CliTraceHolder;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.load.java.components.JavaDeprecationSettings;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationResolver;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.storage.StorageManager;

public final class CliLightClassGenerationSupport
extends LightClassGenerationSupport {
    @NotNull
    private final CliTraceHolder traceHolder;
    @NotNull
    private final Project project;
    @NotNull
    private final Lazy ultraLightSupport$delegate;

    public CliLightClassGenerationSupport(@NotNull CliTraceHolder traceHolder, @NotNull Project project) {
        Intrinsics.checkNotNullParameter(traceHolder, "traceHolder");
        Intrinsics.checkNotNullParameter(project, "project");
        this.traceHolder = traceHolder;
        this.project = project;
        this.ultraLightSupport$delegate = ImplUtilsKt.lazyPub(() -> CliLightClassGenerationSupport.ultraLightSupport_delegate$lambda$0(this));
    }

    @NotNull
    public final CliTraceHolder getTraceHolder() {
        return this.traceHolder;
    }

    private final KtUltraLightSupport getUltraLightSupport() {
        Lazy lazy = this.ultraLightSupport$delegate;
        return (KtUltraLightSupport)lazy.getValue();
    }

    @Override
    @NotNull
    protected KtUltraLightSupport getUltraLightClassSupport(@NotNull KtElement element) {
        Intrinsics.checkNotNullParameter(element, "element");
        if (!Intrinsics.areEqual(element.getProject(), this.project)) {
            boolean bl = false;
            String string2 = "ULC support created from another project from requested";
            throw new IllegalArgumentException(string2.toString());
        }
        return this.getUltraLightSupport();
    }

    @Override
    @Nullable
    public DeclarationDescriptor resolveToDescriptor(@NotNull KtDeclaration declaration) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        return this.traceHolder.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, declaration);
    }

    @Override
    @NotNull
    public BindingContext analyze(@NotNull KtElement element) {
        Intrinsics.checkNotNullParameter(element, "element");
        return this.traceHolder.getBindingContext();
    }

    @Override
    @Nullable
    public AnnotationDescriptor analyzeAnnotation(@NotNull KtAnnotationEntry element) {
        Intrinsics.checkNotNullParameter(element, "element");
        return (AnnotationDescriptor)this.traceHolder.getBindingContext().get(BindingContext.ANNOTATION, element);
    }

    @Override
    @NotNull
    public BindingContext analyzeWithContent(@NotNull KtClassOrObject element) {
        Intrinsics.checkNotNullParameter(element, "element");
        return this.traceHolder.getBindingContext();
    }

    private static final CliLightClassSupport ultraLightSupport_delegate$lambda$0(CliLightClassGenerationSupport this$0) {
        return new CliLightClassSupport(this$0.project, this$0.traceHolder.getLanguageVersionSettings());
    }

    private static final class CliLightClassSupport
    implements KtUltraLightSupport {
        @NotNull
        private final Project project;
        @NotNull
        private final LanguageVersionSettings languageVersionSettings;
        @NotNull
        private final Lazy typeMapper$delegate;

        public CliLightClassSupport(@NotNull Project project, @NotNull LanguageVersionSettings languageVersionSettings) {
            Intrinsics.checkNotNullParameter(project, "project");
            Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
            this.project = project;
            this.languageVersionSettings = languageVersionSettings;
            this.typeMapper$delegate = ImplUtilsKt.lazyPub(() -> CliLightClassSupport.typeMapper_delegate$lambda$0(this));
        }

        @Override
        @NotNull
        public LanguageVersionSettings getLanguageVersionSettings() {
            return this.languageVersionSettings;
        }

        private final CliTraceHolder getTraceHolder() {
            LightClassGenerationSupport lightClassGenerationSupport = LightClassGenerationSupport.Companion.getInstance(this.project);
            Intrinsics.checkNotNull(lightClassGenerationSupport, "null cannot be cast to non-null type org.jetbrains.kotlin.cli.jvm.compiler.CliLightClassGenerationSupport");
            return ((CliLightClassGenerationSupport)lightClassGenerationSupport).getTraceHolder();
        }

        @Override
        public boolean possiblyHasAlias(@NotNull KtFile file2, @NotNull Name shortName) {
            Intrinsics.checkNotNullParameter(file2, "file");
            Intrinsics.checkNotNullParameter(shortName, "shortName");
            return true;
        }

        @Override
        @NotNull
        public ModuleDescriptor getModuleDescriptor() {
            return this.getTraceHolder().getModule();
        }

        @Override
        @NotNull
        public String getModuleName() {
            String string2 = JvmCodegenUtil.getModuleName(this.getModuleDescriptor());
            Intrinsics.checkNotNullExpressionValue(string2, "getModuleName(...)");
            return string2;
        }

        @Override
        @NotNull
        public DeprecationResolver getDeprecationResolver() {
            StorageManager storageManager = LockBasedStorageManager.NO_LOCKS;
            Intrinsics.checkNotNullExpressionValue(storageManager, "NO_LOCKS");
            return new DeprecationResolver(storageManager, this.getLanguageVersionSettings(), JavaDeprecationSettings.INSTANCE);
        }

        @Override
        @NotNull
        public KotlinTypeMapper getTypeMapper() {
            Lazy lazy = this.typeMapper$delegate;
            return (KotlinTypeMapper)lazy.getValue();
        }

        private static final KotlinTypeMapper typeMapper_delegate$lambda$0(CliLightClassSupport this$0) {
            return new KotlinTypeMapper(this$0.getModuleName(), this$0.getLanguageVersionSettings(), false, typeMapper.2.1.INSTANCE, typeMapper.2.2.INSTANCE);
        }
    }
}

