/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Set;
import kotlin._Assertions;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.jvm.index.JavaRoot;
import org.jetbrains.kotlin.cli.jvm.index.JvmDependenciesIndex;
import org.jetbrains.kotlin.load.kotlin.VirtualFileFinder;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.serialization.deserialization.builtins.BuiltInSerializerProtocol;

public final class CliVirtualFileFinder
extends VirtualFileFinder {
    @NotNull
    private final JvmDependenciesIndex index;
    @NotNull
    private final GlobalSearchScope scope;
    private final boolean enableSearchInCtSym;

    public CliVirtualFileFinder(@NotNull JvmDependenciesIndex index2, @NotNull GlobalSearchScope scope2, boolean enableSearchInCtSym) {
        Intrinsics.checkNotNullParameter(index2, "index");
        Intrinsics.checkNotNullParameter(scope2, "scope");
        this.index = index2;
        this.scope = scope2;
        this.enableSearchInCtSym = enableSearchInCtSym;
    }

    @Override
    @Nullable
    public VirtualFile findVirtualFileWithHeader(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter(classId, "classId");
        return this.findBinaryOrSigClass(classId);
    }

    @Override
    @Nullable
    public VirtualFile findSourceOrBinaryVirtualFile(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter(classId, "classId");
        VirtualFile virtualFile = this.findBinaryOrSigClass(classId);
        if (virtualFile == null) {
            virtualFile = this.findSourceClass(classId, classId.getRelativeClassName().asString() + ".java");
        }
        return virtualFile;
    }

    @Override
    @Nullable
    public InputStream findMetadata(@NotNull ClassId classId) {
        boolean bl;
        Intrinsics.checkNotNullParameter(classId, "classId");
        boolean bl2 = bl = !classId.isNestedClass();
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Nested classes are not supported here: " + classId;
            throw new AssertionError((Object)string2);
        }
        VirtualFile virtualFile = this.findBinaryClass(classId, classId.getShortClassName().asString() + ".kotlin_metadata");
        return virtualFile != null ? virtualFile.getInputStream() : null;
    }

    @Override
    @NotNull
    public Set<String> findMetadataTopLevelClassesInPackage(@NotNull FqName packageFqName) {
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        ObjectOpenHashSet result2 = new ObjectOpenHashSet();
        JvmDependenciesIndex.traverseDirectoriesInPackage$default(this.index, packageFqName, null, (arg_0, arg_1) -> CliVirtualFileFinder.findMetadataTopLevelClassesInPackage$lambda$1(result2, arg_0, arg_1), 2, null);
        return result2;
    }

    @Override
    public boolean hasMetadataPackage(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        Ref.BooleanRef found = new Ref.BooleanRef();
        JvmDependenciesIndex.traverseDirectoriesInPackage$default(this.index, fqName2, null, (arg_0, arg_1) -> CliVirtualFileFinder.hasMetadataPackage$lambda$3(found, arg_0, arg_1), 2, null);
        return found.element;
    }

    @Override
    @Nullable
    public InputStream findBuiltInsData(@NotNull FqName packageFqName) {
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        Name name = Name.special("<builtins-metadata>");
        Intrinsics.checkNotNullExpressionValue(name, "special(...)");
        ClassId classId = new ClassId(packageFqName, name);
        VirtualFile virtualFile = this.findBinaryClass(classId, BuiltInSerializerProtocol.INSTANCE.getBuiltInsFileName(packageFqName));
        return virtualFile != null ? virtualFile.getInputStream() : null;
    }

    /*
     * WARNING - void declaration
     */
    private final VirtualFile findClass(ClassId classId, String fileName, Set<? extends JavaRoot.RootType> rootType) {
        Object v0;
        block1: {
            void $this$firstOrNull$iv;
            Iterable iterable = this.index.findClasses(classId, rootType, (arg_0, arg_1) -> CliVirtualFileFinder.findClass$lambda$4(fileName, arg_0, arg_1));
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                VirtualFile it = (VirtualFile)element$iv;
                boolean bl = false;
                if (!this.scope.contains(it)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final VirtualFile findSigFileIfEnabled(VirtualFile dir2, String simpleName2) {
        return this.enableSearchInCtSym ? dir2.findChild(simpleName2 + ".sig") : null;
    }

    /*
     * WARNING - void declaration
     */
    private final VirtualFile findBinaryOrSigClass(ClassId classId, String simpleName2, Set<? extends JavaRoot.RootType> rootType) {
        Object v0;
        block1: {
            void $this$firstOrNull$iv;
            Iterable iterable = this.index.findClasses(classId, rootType, (arg_0, arg_1) -> CliVirtualFileFinder.findBinaryOrSigClass$lambda$6(simpleName2, this, arg_0, arg_1));
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                VirtualFile it = (VirtualFile)element$iv;
                boolean bl = false;
                if (!this.scope.contains(it)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final VirtualFile findBinaryOrSigClass(ClassId classId) {
        return this.findBinaryOrSigClass(classId, StringsKt.replace$default(classId.getRelativeClassName().asString(), '.', '$', false, 4, null), JavaRoot.RootTypes.getOnlyBinary());
    }

    private final VirtualFile findBinaryClass(ClassId classId, String fileName) {
        return this.findClass(classId, fileName, JavaRoot.RootTypes.getOnlyBinary());
    }

    private final VirtualFile findSourceClass(ClassId classId, String fileName) {
        return this.findClass(classId, fileName, JavaRoot.RootTypes.getOnlySource());
    }

    private static final boolean findMetadataTopLevelClassesInPackage$lambda$1(ObjectOpenHashSet $result, VirtualFile dir2, JavaRoot.RootType rootType) {
        Intrinsics.checkNotNullParameter(dir2, "dir");
        Intrinsics.checkNotNullParameter((Object)rootType, "<unused var>");
        Iterator<VirtualFile> iterator2 = ArrayIteratorKt.iterator(dir2.getChildren());
        while (iterator2.hasNext()) {
            VirtualFile child = iterator2.next();
            if (!Intrinsics.areEqual(child.getExtension(), "kotlin_metadata")) continue;
            $result.add(child.getNameWithoutExtension());
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean hasMetadataPackage$lambda$3(Ref.BooleanRef $found, VirtualFile dir2, JavaRoot.RootType rootType) {
        boolean bl;
        boolean bl2;
        block1: {
            void $this$any$iv;
            Intrinsics.checkNotNullParameter(dir2, "dir");
            Intrinsics.checkNotNullParameter((Object)rootType, "<unused var>");
            boolean bl3 = $found.element;
            VirtualFile[] virtualFileArray = dir2.getChildren();
            Intrinsics.checkNotNullExpressionValue(virtualFileArray, "getChildren(...)");
            Object[] objectArray = virtualFileArray;
            bl2 = bl3;
            Ref.BooleanRef booleanRef = $found;
            boolean $i$f$any = false;
            for (void element$iv : $this$any$iv) {
                VirtualFile it = (VirtualFile)element$iv;
                boolean bl4 = false;
                if (!Intrinsics.areEqual(it.getExtension(), "kotlin_metadata")) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        boolean bl5 = bl;
        booleanRef.element = bl2 | bl5;
        return !$found.element;
    }

    private static final VirtualFile findClass$lambda$4(String $fileName, VirtualFile dir2, JavaRoot.RootType rootType) {
        VirtualFile virtualFile;
        Intrinsics.checkNotNullParameter(dir2, "dir");
        Intrinsics.checkNotNullParameter((Object)rootType, "<unused var>");
        VirtualFile virtualFile2 = dir2.findChild($fileName);
        if (virtualFile2 != null) {
            VirtualFile virtualFile3;
            VirtualFile p0 = virtualFile3 = virtualFile2;
            boolean bl = false;
            virtualFile = p0.isValid() ? virtualFile3 : null;
        } else {
            virtualFile = null;
        }
        return virtualFile;
    }

    private static final VirtualFile findBinaryOrSigClass$lambda$6(String $simpleName, CliVirtualFileFinder this$0, VirtualFile dir2, JavaRoot.RootType rootType) {
        VirtualFile file2;
        Intrinsics.checkNotNullParameter(dir2, "dir");
        Intrinsics.checkNotNullParameter((Object)rootType, "<unused var>");
        VirtualFile virtualFile = dir2.findChild($simpleName + ".class");
        if (virtualFile == null) {
            virtualFile = this$0.findSigFileIfEnabled(dir2, $simpleName);
        }
        return (file2 = virtualFile) != null && file2.isValid() ? file2 : null;
    }
}

