/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.SmartList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.jvm.compiler.JvmPackagePartProviderKt;
import org.jetbrains.kotlin.cli.jvm.index.JavaRoot;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.load.kotlin.JvmPackagePartProviderBase;
import org.jetbrains.kotlin.metadata.jvm.deserialization.ModuleMapping;
import org.jetbrains.kotlin.resolve.CompilerDeserializationConfiguration;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ#\u0010\u000f\u001a\u00020\u000e2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0006\u001a\u00020\u00058\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0011R\u001a\u0010\u0013\u001a\u00020\u00128\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R&\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00180\u00178\u0015X\u0095\u0004\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001c"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/compiler/JvmPackagePartProvider;", "Lorg/jetbrains/kotlin/load/kotlin/JvmPackagePartProviderBase;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "languageVersionSettings", "Lcom/intellij/psi/search/GlobalSearchScope;", "scope", "<init>", "(Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lcom/intellij/psi/search/GlobalSearchScope;)V", "", "Lorg/jetbrains/kotlin/cli/jvm/index/JavaRoot;", "roots", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "messageCollector", "", "addRoots", "(Ljava/util/List;Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;)V", "Lcom/intellij/psi/search/GlobalSearchScope;", "Lorg/jetbrains/kotlin/resolve/CompilerDeserializationConfiguration;", "deserializationConfiguration", "Lorg/jetbrains/kotlin/resolve/CompilerDeserializationConfiguration;", "getDeserializationConfiguration", "()Lorg/jetbrains/kotlin/resolve/CompilerDeserializationConfiguration;", "", "Lorg/jetbrains/kotlin/load/kotlin/JvmPackagePartProviderBase$ModuleMappingInfo;", "loadedModules", "Ljava/util/List;", "getLoadedModules", "()Ljava/util/List;"})
public final class JvmPackagePartProvider
extends JvmPackagePartProviderBase<VirtualFile> {
    @NotNull
    private final GlobalSearchScope scope;
    @NotNull
    private final CompilerDeserializationConfiguration deserializationConfiguration;
    @NotNull
    private final List<JvmPackagePartProviderBase.ModuleMappingInfo<VirtualFile>> loadedModules;

    public JvmPackagePartProvider(@NotNull LanguageVersionSettings languageVersionSettings, @NotNull GlobalSearchScope scope2) {
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        Intrinsics.checkNotNullParameter(scope2, "scope");
        this.scope = scope2;
        this.deserializationConfiguration = new CompilerDeserializationConfiguration(languageVersionSettings);
        this.loadedModules = new SmartList();
    }

    @Override
    @NotNull
    public CompilerDeserializationConfiguration getDeserializationConfiguration() {
        return this.deserializationConfiguration;
    }

    @Override
    @NotNull
    protected List<JvmPackagePartProviderBase.ModuleMappingInfo<VirtualFile>> getLoadedModules() {
        return this.loadedModules;
    }

    public final void addRoots(@NotNull List<JavaRoot> roots, @NotNull MessageCollector messageCollector) {
        Intrinsics.checkNotNullParameter(roots, "roots");
        Intrinsics.checkNotNullParameter(messageCollector, "messageCollector");
        for (JavaRoot javaRoot : roots) {
            VirtualFile metaInf;
            VirtualFile root = javaRoot.component1();
            JavaRoot.RootType type2 = javaRoot.component2();
            if (type2 != JavaRoot.RootType.BINARY || !this.scope.contains(root) || root.findChild("META-INF") == null) continue;
            Iterator<VirtualFile> iterator2 = ArrayIteratorKt.iterator(metaInf.getChildren());
            while (iterator2.hasNext()) {
                VirtualFile moduleFile = iterator2.next();
                String string2 = moduleFile.getName();
                Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
                if (!StringsKt.endsWith$default(string2, "kotlin_module", false, 2, null)) continue;
                Function0<byte[]> function0 = () -> JvmPackagePartProvider.addRoots$lambda$0(moduleFile);
                String string3 = moduleFile.toString();
                Intrinsics.checkNotNullExpressionValue(string3, "toString(...)");
                String string4 = moduleFile.getPath();
                Intrinsics.checkNotNullExpressionValue(string4, "getPath(...)");
                ModuleMapping moduleMapping = JvmPackagePartProviderKt.tryLoadModuleMapping(function0, string3, string4, this.getDeserializationConfiguration(), messageCollector);
                if (moduleMapping == null) continue;
                ModuleMapping it = moduleMapping;
                boolean bl = false;
                List<JvmPackagePartProviderBase.ModuleMappingInfo<VirtualFile>> list = this.getLoadedModules();
                String string5 = moduleFile.getNameWithoutExtension();
                Intrinsics.checkNotNullExpressionValue(string5, "getNameWithoutExtension(...)");
                list.add(new JvmPackagePartProviderBase.ModuleMappingInfo<VirtualFile>(root, it, string5));
            }
        }
    }

    private static final byte[] addRoots$lambda$0(VirtualFile $moduleFile) {
        byte[] byArray = $moduleFile.contentsToByteArray();
        Intrinsics.checkNotNullExpressionValue(byArray, "contentsToByteArray(...)");
        return byArray;
    }
}

