/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler;

import com.intellij.mock.MockApplication;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.ThrowableComputable;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class KotlinCoreUnitTestApplication
extends MockApplication {
    @NotNull
    private final ThreadLocal<Boolean> isWriteAccessAllowedInThread;

    public KotlinCoreUnitTestApplication(@NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter(parentDisposable, "parentDisposable");
        super(parentDisposable);
        ThreadLocal<Boolean> threadLocal = ThreadLocal.withInitial(KotlinCoreUnitTestApplication::isWriteAccessAllowedInThread$lambda$0);
        Intrinsics.checkNotNullExpressionValue(threadLocal, "withInitial(...)");
        this.isWriteAccessAllowedInThread = threadLocal;
    }

    @Override
    public boolean isUnitTestMode() {
        return true;
    }

    @Override
    public boolean isWriteAccessAllowed() {
        Boolean bl = this.isWriteAccessAllowedInThread.get();
        Intrinsics.checkNotNullExpressionValue(bl, "get(...)");
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runWriteAction(@NotNull Runnable action) {
        Intrinsics.checkNotNullParameter(action, "action");
        KotlinCoreUnitTestApplication this_$iv = this;
        boolean $i$f$withWriteAccessAllowedInThread = false;
        this_$iv.isWriteAccessAllowedInThread.set(true);
        try {
            boolean bl = false;
            action.run();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            this_$iv.isWriteAccessAllowedInThread.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public <T> T runWriteAction(@NotNull Computable<T> computation) {
        T t;
        Intrinsics.checkNotNullParameter(computation, "computation");
        KotlinCoreUnitTestApplication this_$iv = this;
        boolean $i$f$withWriteAccessAllowedInThread = false;
        this_$iv.isWriteAccessAllowedInThread.set(true);
        try {
            boolean bl = false;
            t = computation.compute();
        }
        finally {
            this_$iv.isWriteAccessAllowedInThread.set(false);
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public <T, E extends Throwable> T runWriteAction(@NotNull ThrowableComputable<T, E> computation) {
        T t;
        Intrinsics.checkNotNullParameter(computation, "computation");
        KotlinCoreUnitTestApplication this_$iv = this;
        boolean $i$f$withWriteAccessAllowedInThread = false;
        this_$iv.isWriteAccessAllowedInThread.set(true);
        try {
            boolean bl = false;
            t = computation.compute();
        }
        finally {
            this_$iv.isWriteAccessAllowedInThread.set(false);
        }
        return t;
    }

    private static final Boolean isWriteAccessAllowedInThread$lambda$0() {
        return false;
    }
}

