/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler.jarfs;

import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;

public final class FastJarFileSystemKt {
    private static final boolean IS_PRIOR_9_JRE;

    private static final Function1<ByteBuffer, Unit> prepareCleanerCallback() {
        Function1<ByteBuffer, Unit> function1;
        try {
            Function1<ByteBuffer, Unit> function12;
            GenericDeclaration clean;
            if (IS_PRIOR_9_JRE) {
                Method cleaner = Class.forName("java.nio.DirectByteBuffer").getMethod("cleaner", new Class[0]);
                cleaner.setAccessible(true);
                clean = Class.forName("sun.misc.Cleaner").getMethod("clean", new Class[0]);
                ((Method)clean).setAccessible(true);
                function12 = arg_0 -> FastJarFileSystemKt.prepareCleanerCallback$lambda$1(cleaner, (Method)clean, arg_0);
            } else {
                try {
                    clean = Class.forName("sun.misc.Unsafe");
                }
                catch (Exception ex) {
                    clean = Class.forName("jdk.internal.misc.Unsafe");
                }
                Class<?> unsafeClass = clean;
                Class[] ex = new Class[]{ByteBuffer.class};
                clean = unsafeClass.getMethod("invokeCleaner", ex);
                ((Method)clean).setAccessible(true);
                Field theUnsafeField = unsafeClass.getDeclaredField("theUnsafe");
                theUnsafeField.setAccessible(true);
                Object theUnsafe = theUnsafeField.get(null);
                function12 = arg_0 -> FastJarFileSystemKt.prepareCleanerCallback$lambda$2((Method)clean, theUnsafe, arg_0);
            }
            function1 = function12;
        }
        catch (Exception ex) {
            function1 = null;
        }
        return function1;
    }

    private static final Unit prepareCleanerCallback$lambda$1(Method $cleaner, Method $clean, ByteBuffer buffer) {
        block0: {
            Intrinsics.checkNotNullParameter(buffer, "buffer");
            Object object = $cleaner.invoke((Object)buffer, new Object[0]);
            if (object == null) break block0;
            Object it = object;
            boolean bl = false;
            $clean.invoke(it, new Object[0]);
        }
        return Unit.INSTANCE;
    }

    private static final Unit prepareCleanerCallback$lambda$2(Method $clean, Object $theUnsafe, ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        Object[] objectArray = new Object[]{buffer};
        $clean.invoke($theUnsafe, objectArray);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Function1 access$prepareCleanerCallback() {
        return FastJarFileSystemKt.prepareCleanerCallback();
    }

    static {
        String string2 = System.getProperty("java.specification.version", "");
        Intrinsics.checkNotNullExpressionValue(string2, "getProperty(...)");
        IS_PRIOR_9_JRE = StringsKt.startsWith$default(string2, "1.", false, 2, null);
    }
}

