/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler.jarfs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.FileAccessorCache;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.jvm.compiler.jarfs.FastJarFileSystem;
import org.jetbrains.kotlin.cli.jvm.compiler.jarfs.FastJarVirtualFile;
import org.jetbrains.kotlin.cli.jvm.compiler.jarfs.LargeDynamicMappedBuffer;
import org.jetbrains.kotlin.cli.jvm.compiler.jarfs.ZipEntryDescription;
import org.jetbrains.kotlin.cli.jvm.compiler.jarfs.ZipImplementationKt;

public final class FastJarHandler {
    @NotNull
    private final FastJarFileSystem fileSystem;
    @Nullable
    private final VirtualFile myRoot;
    @NotNull
    private final File file;
    @Nullable
    private final byte[] cachedManifest;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public FastJarHandler(@NotNull FastJarFileSystem fileSystem, @NotNull String path) {
        Intrinsics.checkNotNullParameter(fileSystem, "fileSystem");
        Intrinsics.checkNotNullParameter(path, "path");
        this.fileSystem = fileSystem;
        this.file = new File(path);
        List<ZipEntryDescription> entries = null;
        Closeable closeable = new RandomAccessFile(this.file, "r");
        Iterator iterator2 = null;
        try {
            Object randomAccessFile = (RandomAccessFile)closeable;
            boolean bl = false;
            long l = ((RandomAccessFile)randomAccessFile).length();
            Function2<Long, Long, MappedByteBuffer> function2 = (arg_0, arg_1) -> FastJarHandler.lambda$2$lambda$0((RandomAccessFile)randomAccessFile, arg_0, arg_1);
            Function1<MappedByteBuffer, Unit> function1 = this.fileSystem.getUnmapBuffer$cli_base();
            ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
            Intrinsics.checkNotNullExpressionValue(byteOrder, "LITTLE_ENDIAN");
            LargeDynamicMappedBuffer largeBuffer = new LargeDynamicMappedBuffer(l, function2, function1, byteOrder);
            try {
                byte[] byArray;
                Object v4;
                FastJarHandler fastJarHandler;
                Object object;
                block16: {
                    void $this$singleOrNull$iv;
                    try {
                        object = ZipImplementationKt.parseCentralDirectory(largeBuffer);
                    }
                    catch (Exception e) {
                        Logger.getInstance(this.getClass()).warn("Error while reading zip file: " + this.file.getPath() + ": " + e, e);
                        object = CollectionsKt.emptyList();
                    }
                    entries = object;
                    Iterable e = entries;
                    fastJarHandler = this;
                    boolean $i$f$singleOrNull = false;
                    Object single$iv = null;
                    boolean found$iv = false;
                    for (Object element$iv : $this$singleOrNull$iv) {
                        ZipEntryDescription it = (ZipEntryDescription)element$iv;
                        boolean bl2 = false;
                        if (!StringUtil.equals("META-INF/MANIFEST.MF", it.getRelativePath())) continue;
                        if (found$iv) {
                            v4 = null;
                            break block16;
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    v4 = !found$iv ? null : single$iv;
                }
                FastJarHandler fastJarHandler2 = fastJarHandler;
                object = v4;
                if (object != null) {
                    void p0;
                    Object $i$f$singleOrNull = object;
                    fastJarHandler = fastJarHandler2;
                    boolean bl3 = false;
                    byArray = ZipImplementationKt.contentsToByteArray(largeBuffer, (ZipEntryDescription)p0);
                    fastJarHandler2 = fastJarHandler;
                } else {
                    byArray = null;
                }
                fastJarHandler2.cachedManifest = byArray;
            }
            finally {
                largeBuffer.unmap();
            }
            randomAccessFile = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            iterator2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally(closeable, (Throwable)((Object)iterator2));
        }
        this.myRoot = new FastJarVirtualFile(this, "", -1L, null, null);
        HashMap filesByRelativePath = new HashMap(entries.size());
        ((Map)filesByRelativePath).put("", this.myRoot);
        for (ZipEntryDescription entryDescription : entries) {
            FastJarVirtualFile fastJarVirtualFile = !entryDescription.isDirectory() ? this.createFile(entryDescription, filesByRelativePath) : this.getOrCreateDirectory(entryDescription.getRelativePath(), filesByRelativePath);
        }
        for (Object v : filesByRelativePath.values()) {
            Intrinsics.checkNotNullExpressionValue(v, "next(...)");
            FastJarVirtualFile node = (FastJarVirtualFile)v;
            node.initChildrenArrayFromList();
        }
    }

    @NotNull
    public final FastJarFileSystem getFileSystem() {
        return this.fileSystem;
    }

    @NotNull
    public final File getFile$cli_base() {
        return this.file;
    }

    private final FastJarVirtualFile createFile(ZipEntryDescription entry, Map<String, FastJarVirtualFile> directories2) {
        Pair<CharSequence, CharSequence> pair = this.splitPath(entry.getRelativePath());
        CharSequence parentName = pair.component1();
        CharSequence shortName = pair.component2();
        FastJarVirtualFile parentFile = this.getOrCreateDirectory(parentName, directories2);
        if (Intrinsics.areEqual(".", shortName)) {
            return parentFile;
        }
        return new FastJarVirtualFile(this, shortName, entry.isDirectory() ? -1L : entry.getUncompressedSize(), parentFile, entry);
    }

    /*
     * WARNING - void declaration
     */
    private final FastJarVirtualFile getOrCreateDirectory(CharSequence entryName, Map<String, FastJarVirtualFile> directories2) {
        Object object;
        void $this$getOrPut$iv;
        Map<String, FastJarVirtualFile> map2 = directories2;
        String key$iv = ((Object)entryName).toString();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Pair<CharSequence, CharSequence> pair = this.splitPath(entryName);
            CharSequence parentPath = pair.component1();
            CharSequence shortName = pair.component2();
            FastJarVirtualFile parentFile = this.getOrCreateDirectory(parentPath, directories2);
            FastJarVirtualFile answer$iv = new FastJarVirtualFile(this, shortName, -1L, parentFile, null);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (FastJarVirtualFile)object;
    }

    private final Pair<CharSequence, CharSequence> splitPath(CharSequence $this$splitPath) {
        int slashIndex;
        for (slashIndex = $this$splitPath.length() - 1; slashIndex >= 0 && $this$splitPath.charAt(slashIndex) != '/'; --slashIndex) {
        }
        if (slashIndex == -1) {
            return new Pair<CharSequence, CharSequence>("", $this$splitPath);
        }
        return new Pair<CharSequence, CharSequence>($this$splitPath.subSequence(0, slashIndex), $this$splitPath.subSequence(slashIndex + 1, $this$splitPath.length()));
    }

    @Nullable
    public final VirtualFile findFileByPath(@NotNull String pathInJar) {
        Intrinsics.checkNotNullParameter(pathInJar, "pathInJar");
        VirtualFile virtualFile = this.myRoot;
        return virtualFile != null ? virtualFile.findFileByRelativePath(pathInJar) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final byte[] contentsToByteArray(@NotNull ZipEntryDescription zipEntryDescription) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter(zipEntryDescription, "zipEntryDescription");
        CharSequence relativePath = zipEntryDescription.getRelativePath();
        if (StringUtil.equals(relativePath, "META-INF/MANIFEST.MF")) {
            if (this.cachedManifest == null) {
                throw new FileNotFoundException(this.file + "!/" + relativePath);
            }
            return this.cachedManifest;
        }
        Closeable closeable = this.fileSystem.getCachedOpenFileHandles$cli_base().get(this.file);
        Throwable throwable = null;
        try {
            byte[] byArray2;
            FileAccessorCache.Handle it = (FileAccessorCache.Handle)closeable;
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            FileAccessorCache.Handle handle = it;
            synchronized (handle) {
                boolean bl2 = false;
                byArray2 = ZipImplementationKt.contentsToByteArray((LargeDynamicMappedBuffer)((Pair)it.get()).getSecond(), zipEntryDescription);
            }
            byArray = byArray2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        return byArray;
    }

    private static final MappedByteBuffer lambda$2$lambda$0(RandomAccessFile $randomAccessFile, long offset, long size) {
        MappedByteBuffer mappedByteBuffer = $randomAccessFile.getChannel().map(FileChannel.MapMode.READ_ONLY, offset, size);
        Intrinsics.checkNotNullExpressionValue(mappedByteBuffer, "map(...)");
        return mappedByteBuffer;
    }
}

