/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler.jarfs;

import com.google.common.primitives.Longs;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0012\b\u0000\u0018\u00002\u00020\u0001:\u0001#BG\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ7\u0010\u0013\u001a\u00028\u0000\"\u0004\b\u0000\u0010\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00022\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J'\u0010\u0015\u001a\u00028\u0000\"\u0004\b\u0000\u0010\u000e2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0016J/\u0010\u0017\u001a\u00028\u0000\"\u0004\b\u0000\u0010\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0004\b\u0017\u0010\u0018J\r\u0010\u0019\u001a\u00020\b\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001bR&\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00050\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u001cR \u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u00078\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u001dR\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u001eR\u0018\u0010\u001f\u001a\u0004\u0018\u00010\u00058\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R\u0016\u0010!\u001a\u00020\u00028\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b!\u0010\u001bR\u0016\u0010\"\u001a\u00020\u00028\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\"\u0010\u001b"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/compiler/jarfs/LargeDynamicMappedBuffer;", "", "", "dataSize", "Lkotlin/Function2;", "Ljava/nio/MappedByteBuffer;", "mapBuffer", "Lkotlin/Function1;", "", "unmapBuffer", "Ljava/nio/ByteOrder;", "defaultByteOrder", "<init>", "(JLkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function1;Ljava/nio/ByteOrder;)V", "R", "start", "end", "Lorg/jetbrains/kotlin/cli/jvm/compiler/jarfs/LargeDynamicMappedBuffer$Mapping;", "body", "withMappedRange", "(JJLkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "withMappedTail", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "withMappedRangeFrom", "(JLkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "unmap", "()V", "J", "Lkotlin/jvm/functions/Function2;", "Lkotlin/jvm/functions/Function1;", "Ljava/nio/ByteOrder;", "currentMappedBuffer", "Ljava/nio/MappedByteBuffer;", "currentStart", "currentEnd", "Mapping"})
public final class LargeDynamicMappedBuffer {
    private final long dataSize;
    @NotNull
    private final Function2<Long, Long, MappedByteBuffer> mapBuffer;
    @NotNull
    private final Function1<MappedByteBuffer, Unit> unmapBuffer;
    @NotNull
    private final ByteOrder defaultByteOrder;
    @Nullable
    private MappedByteBuffer currentMappedBuffer;
    private long currentStart;
    private long currentEnd;

    public LargeDynamicMappedBuffer(long dataSize, @NotNull Function2<? super Long, ? super Long, ? extends MappedByteBuffer> mapBuffer, @NotNull Function1<? super MappedByteBuffer, Unit> unmapBuffer, @NotNull ByteOrder defaultByteOrder) {
        Intrinsics.checkNotNullParameter(mapBuffer, "mapBuffer");
        Intrinsics.checkNotNullParameter(unmapBuffer, "unmapBuffer");
        Intrinsics.checkNotNullParameter(defaultByteOrder, "defaultByteOrder");
        this.dataSize = dataSize;
        this.mapBuffer = mapBuffer;
        this.unmapBuffer = unmapBuffer;
        this.defaultByteOrder = defaultByteOrder;
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized <R> R withMappedRange(long start, long end, @NotNull Function1<? super Mapping, ? extends R> body2) {
        Intrinsics.checkNotNullParameter(body2, "body");
        long l = start + 1L;
        if (!((end <= this.dataSize ? l <= end : false) && end - start <= Integer.MAX_VALUE)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        long currentSize = Integer.MAX_VALUE;
        if (this.currentMappedBuffer == null || this.currentStart > start || this.currentEnd < end) {
            void it;
            MappedByteBuffer mappedByteBuffer;
            if (this.dataSize <= Integer.MAX_VALUE) {
                this.currentStart = 0L;
                this.currentEnd = this.dataSize;
                currentSize = this.dataSize;
            } else if (start + (long)Integer.MAX_VALUE > this.dataSize) {
                this.currentStart = this.dataSize - (long)Integer.MAX_VALUE;
                this.currentEnd = this.dataSize;
            } else {
                this.currentStart = start;
                this.currentEnd = start + (long)Integer.MAX_VALUE;
            }
            this.unmap();
            MappedByteBuffer mappedByteBuffer2 = mappedByteBuffer = this.mapBuffer.invoke(this.currentStart, currentSize);
            LargeDynamicMappedBuffer largeDynamicMappedBuffer = this;
            boolean bl = false;
            it.order(this.defaultByteOrder);
            largeDynamicMappedBuffer.currentMappedBuffer = mappedByteBuffer;
        }
        MappedByteBuffer mappedByteBuffer = this.currentMappedBuffer;
        Intrinsics.checkNotNull(mappedByteBuffer);
        MappedByteBuffer buffer = mappedByteBuffer;
        if (!(this.currentStart <= start && this.currentEnd >= end && start - this.currentStart < Integer.MAX_VALUE)) {
            String string3 = "Failed requirement.";
            throw new IllegalArgumentException(string3.toString());
        }
        buffer.position((int)(start - this.currentStart));
        return body2.invoke(new Mapping(buffer, buffer.position()));
    }

    public final <R> R withMappedTail(@NotNull Function1<? super Mapping, ? extends R> body2) {
        Intrinsics.checkNotNullParameter(body2, "body");
        long[] lArray = new long[]{this.dataSize, Integer.MAX_VALUE};
        long size = Longs.min(lArray);
        return this.withMappedRange(this.dataSize - size, this.dataSize, body2);
    }

    public final <R> R withMappedRangeFrom(long start, @NotNull Function1<? super Mapping, ? extends R> body2) {
        Intrinsics.checkNotNullParameter(body2, "body");
        if (!(start < this.dataSize)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        long[] lArray = new long[]{this.dataSize - start, Integer.MAX_VALUE};
        long size = Longs.min(lArray);
        return this.withMappedRange(start, start + size, body2);
    }

    public final void unmap() {
        MappedByteBuffer mappedByteBuffer = this.currentMappedBuffer;
        if (mappedByteBuffer != null) {
            this.unmapBuffer.invoke(mappedByteBuffer);
        }
    }

    public static final class Mapping {
        @NotNull
        private final MappedByteBuffer buffer;
        private final int baseOffset;

        public Mapping(@NotNull MappedByteBuffer buffer, int baseOffset) {
            Intrinsics.checkNotNullParameter(buffer, "buffer");
            this.buffer = buffer;
            this.baseOffset = baseOffset;
        }

        public final int getInt(int offset) {
            return this.buffer.getInt(this.baseOffset + offset);
        }

        public final long getLong(int offset) {
            return this.buffer.getLong(this.baseOffset + offset);
        }

        public final short getShort(int offset) {
            return this.buffer.getShort(this.baseOffset + offset);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final byte[] getBytes(int offset, int length) {
            byte[] bytes = new byte[length];
            this.buffer.position(this.baseOffset + offset);
            try {
                this.buffer.get(bytes, 0, length);
                byte[] byArray = bytes;
                return byArray;
            }
            finally {
                this.buffer.position(this.baseOffset);
            }
        }

        public final int endOffset() {
            return this.buffer.capacity() - this.baseOffset;
        }
    }
}

