/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.index;

import com.intellij.openapi.vfs.VirtualFile;
import java.util.EnumSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0086\b\u0018\u0000 \u001f2\u00020\u0001:\u0002 \u001fB#\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u0002H\u00c7\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\u0004H\u00c7\u0003\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010\u0010\u001a\u00020\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0013\u001a\u00020\u0012H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0016\u001a\u00020\u0015H\u00d7\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0018\u001a\u0004\b\u0019\u0010\u000bR\u001a\u0010\u0005\u001a\u00020\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001a\u001a\u0004\b\u001b\u0010\rR\u001c\u0010\u0007\u001a\u0004\u0018\u00010\u00068\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010\u001c\u001a\u0004\b\u001d\u0010\u001e"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/index/JavaRoot;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "file", "Lorg/jetbrains/kotlin/cli/jvm/index/JavaRoot$RootType;", "type", "Lorg/jetbrains/kotlin/name/FqName;", "prefixFqName", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Lorg/jetbrains/kotlin/cli/jvm/index/JavaRoot$RootType;Lorg/jetbrains/kotlin/name/FqName;)V", "component1", "()Lcom/intellij/openapi/vfs/VirtualFile;", "component2", "()Lorg/jetbrains/kotlin/cli/jvm/index/JavaRoot$RootType;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lcom/intellij/openapi/vfs/VirtualFile;", "getFile", "Lorg/jetbrains/kotlin/cli/jvm/index/JavaRoot$RootType;", "getType", "Lorg/jetbrains/kotlin/name/FqName;", "getPrefixFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "RootTypes", "RootType"})
public final class JavaRoot {
    @NotNull
    public static final RootTypes RootTypes = new RootTypes(null);
    @NotNull
    private final VirtualFile file;
    @NotNull
    private final RootType type;
    @Nullable
    private final FqName prefixFqName;
    @NotNull
    private static final Set<RootType> OnlyBinary;
    @NotNull
    private static final Set<RootType> OnlySource;
    @NotNull
    private static final Set<RootType> SourceAndBinary;

    public JavaRoot(@NotNull VirtualFile file2, @NotNull RootType type2, @Nullable FqName prefixFqName) {
        Intrinsics.checkNotNullParameter(file2, "file");
        Intrinsics.checkNotNullParameter((Object)type2, "type");
        this.file = file2;
        this.type = type2;
        this.prefixFqName = prefixFqName;
    }

    public /* synthetic */ JavaRoot(VirtualFile virtualFile, RootType rootType, FqName fqName2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            fqName2 = null;
        }
        this(virtualFile, rootType, fqName2);
    }

    @NotNull
    public final VirtualFile getFile() {
        return this.file;
    }

    @NotNull
    public final RootType getType() {
        return this.type;
    }

    @Nullable
    public final FqName getPrefixFqName() {
        return this.prefixFqName;
    }

    @NotNull
    public final VirtualFile component1() {
        return this.file;
    }

    @NotNull
    public final RootType component2() {
        return this.type;
    }

    @NotNull
    public String toString() {
        return "JavaRoot(file=" + this.file + ", type=" + (Object)((Object)this.type) + ", prefixFqName=" + this.prefixFqName + ')';
    }

    public int hashCode() {
        int result2 = this.file.hashCode();
        result2 = result2 * 31 + this.type.hashCode();
        result2 = result2 * 31 + (this.prefixFqName == null ? 0 : this.prefixFqName.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JavaRoot)) {
            return false;
        }
        JavaRoot javaRoot = (JavaRoot)other;
        if (!Intrinsics.areEqual(this.file, javaRoot.file)) {
            return false;
        }
        if (this.type != javaRoot.type) {
            return false;
        }
        return Intrinsics.areEqual(this.prefixFqName, javaRoot.prefixFqName);
    }

    static {
        EnumSet<Enum> enumSet = EnumSet.of((Enum)RootType.BINARY, (Enum)RootType.BINARY_SIG);
        Intrinsics.checkNotNullExpressionValue(enumSet, "of(...)");
        OnlyBinary = enumSet;
        EnumSet<Enum> enumSet2 = EnumSet.of((Enum)RootType.SOURCE);
        Intrinsics.checkNotNullExpressionValue(enumSet2, "of(...)");
        OnlySource = enumSet2;
        EnumSet<Enum> enumSet3 = EnumSet.of((Enum)RootType.BINARY, (Enum)RootType.BINARY_SIG, (Enum)RootType.SOURCE);
        Intrinsics.checkNotNullExpressionValue(enumSet3, "of(...)");
        SourceAndBinary = enumSet3;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/index/JavaRoot$RootType;", "", "<init>", "(Ljava/lang/String;I)V", "SOURCE", "BINARY", "BINARY_SIG"})
    public static final class RootType
    extends Enum<RootType> {
        public static final /* enum */ RootType SOURCE = new RootType();
        public static final /* enum */ RootType BINARY = new RootType();
        public static final /* enum */ RootType BINARY_SIG = new RootType();
        private static final /* synthetic */ RootType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static RootType[] values() {
            return (RootType[])$VALUES.clone();
        }

        public static RootType valueOf(String value2) {
            return Enum.valueOf(RootType.class, value2);
        }

        @NotNull
        public static EnumEntries<RootType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = rootTypeArray = new RootType[]{RootType.SOURCE, RootType.BINARY, RootType.BINARY_SIG};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R \u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\tR \u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\n\u0010\u0007\u001a\u0004\b\u000b\u0010\tR \u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\f\u0010\u0007\u001a\u0004\b\r\u0010\t"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/index/JavaRoot$RootTypes;", "", "<init>", "()V", "", "Lorg/jetbrains/kotlin/cli/jvm/index/JavaRoot$RootType;", "OnlyBinary", "Ljava/util/Set;", "getOnlyBinary", "()Ljava/util/Set;", "OnlySource", "getOnlySource", "SourceAndBinary", "getSourceAndBinary"})
    public static final class RootTypes {
        private RootTypes() {
        }

        @NotNull
        public final Set<RootType> getOnlyBinary() {
            return OnlyBinary;
        }

        @NotNull
        public final Set<RootType> getOnlySource() {
            return OnlySource;
        }

        @NotNull
        public final Set<RootType> getSourceAndBinary() {
            return SourceAndBinary;
        }

        public /* synthetic */ RootTypes(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

