/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.modules;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.search.GlobalSearchScope;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.CompilationErrorException;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.jvm.modules.CtSymDirectoryContainer;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.jvm.KotlinCliJavaFileManager;
import org.jetbrains.kotlin.resolve.jvm.modules.JavaModule;
import org.jetbrains.kotlin.resolve.jvm.modules.JavaModuleFinder;
import org.jetbrains.kotlin.resolve.jvm.modules.JavaModuleInfo;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010$\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\f\u0018\u00002\u00020\u0001B5\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0019\u0010\u0015\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0014\u001a\u00020\u0013H\u0017\u00a2\u0006\u0004\b\u0015\u0010\u0016J#\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0018\u001a\u00020\u00172\b\b\u0002\u0010\u001a\u001a\u00020\u0019H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001d\u0010\"\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\u001f\u001a\u00020\u001eH\u0002\u00a2\u0006\u0004\b\"\u0010#J'\u0010\"\u001a\u00020!2\u0006\u0010$\u001a\u00020\u00192\u0006\u0010%\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u001eH\u0002\u00a2\u0006\u0004\b\"\u0010&J\u0017\u0010(\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b(\u0010)J\u001f\u0010+\u001a\u00020\u00192\u0006\u0010*\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b+\u0010,J\u001b\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00170-H\u0002\u00a2\u0006\u0004\b.\u0010/J\u0019\u00101\u001a\u0004\u0018\u00010\u00172\u0006\u00100\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b1\u00102R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u00103R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u00104R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u00105R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\n8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u00106R\u001b\u00108\u001a\t\u0018\u00010\u0017\u00a2\u0006\u0002\b78\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b8\u00109R\u001b\u0010:\u001a\t\u0018\u00010\u0017\u00a2\u0006\u0002\b78\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b:\u00109R0\u0010=\u001a\u001e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u000e0;j\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u000e`<8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b=\u0010>R\u0019\u0010A\u001a\u00070?\u00a2\u0006\u0002\b@8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\bA\u0010BR\u001d\u0010G\u001a\u0004\u0018\u00010\u00178BX\u0083\u0084\u0002\u00a2\u0006\f\n\u0004\bC\u0010D\u001a\u0004\bE\u0010FR\u001d\u0010J\u001a\u0004\u0018\u00010\u00178BX\u0083\u0084\u0002\u00a2\u0006\f\n\u0004\bH\u0010D\u001a\u0004\bI\u0010FR\u001b\u0010N\u001a\u00020\n8BX\u0083\u0084\u0002\u00a2\u0006\f\n\u0004\bK\u0010D\u001a\u0004\bL\u0010MR'\u0010Q\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00170-8GX\u0087\u0084\u0002\u00a2\u0006\f\n\u0004\bO\u0010D\u001a\u0004\bP\u0010/R\u0014\u0010R\u001a\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bR\u0010SR\u0014\u0010U\u001a\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bT\u0010SR\u0017\u0010Y\u001a\b\u0012\u0004\u0012\u00020\u000e0V8G\u00a2\u0006\u0006\u001a\u0004\bW\u0010XR \u0010[\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u001b0Z8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b[\u0010\\R\u0017\u0010^\u001a\b\u0012\u0004\u0012\u00020\u001b0V8G\u00a2\u0006\u0006\u001a\u0004\b]\u0010XR\u001b\u0010b\u001a\u00020!8GX\u0087\u0084\u0002\u00a2\u0006\f\n\u0004\b_\u0010D\u001a\u0004\b`\u0010aR!\u0010f\u001a\b\u0012\u0004\u0012\u00020\u00170 8BX\u0083\u0084\u0002\u00a2\u0006\f\n\u0004\bc\u0010D\u001a\u0004\bd\u0010e"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/modules/CliJavaModuleFinder;", "Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModuleFinder;", "Ljava/io/File;", "jdkHome", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "messageCollector", "Lorg/jetbrains/kotlin/resolve/jvm/KotlinCliJavaFileManager;", "javaFileManager", "Lcom/intellij/openapi/project/Project;", "project", "", "jdkRelease", "<init>", "(Ljava/io/File;Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;Lorg/jetbrains/kotlin/resolve/jvm/KotlinCliJavaFileManager;Lcom/intellij/openapi/project/Project;Ljava/lang/Integer;)V", "Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModule;", "module", "", "addUserModule", "(Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModule;)V", "", "name", "findModule", "(Ljava/lang/String;)Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModule;", "Lcom/intellij/openapi/vfs/VirtualFile;", "moduleRoot", "", "useSig", "Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModule$Explicit;", "findSystemModule", "(Lcom/intellij/openapi/vfs/VirtualFile;Z)Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModule$Explicit;", "Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModuleInfo;", "moduleInfo", "", "Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModule$Root;", "createModuleFromSignature", "(Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModuleInfo;)Ljava/util/List;", "filterPackages", "filterModules", "(ZZLorg/jetbrains/kotlin/resolve/jvm/modules/JavaModuleInfo;)Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModule$Root;", "release", "codeFor", "(I)Ljava/lang/String;", "fileName", "matchesRelease", "(Ljava/lang/String;I)Z", "", "collectModuleRoots", "()Ljava/util/Map;", "message", "reportError", "(Ljava/lang/String;)Lcom/intellij/openapi/vfs/VirtualFile;", "Ljava/io/File;", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "Lorg/jetbrains/kotlin/resolve/jvm/KotlinCliJavaFileManager;", "Ljava/lang/Integer;", "Lorg/jetbrains/annotations/Nullable;", "jrtFileSystemRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "modulesRoot", "Ljava/util/LinkedHashMap;", "Lkotlin/collections/LinkedHashMap;", "userModules", "Ljava/util/LinkedHashMap;", "Lcom/intellij/psi/search/GlobalSearchScope;", "Lorg/jetbrains/annotations/NotNull;", "allScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "ctSymFile$delegate", "Lkotlin/Lazy;", "getCtSymFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "ctSymFile", "ctSymRootFolder$delegate", "getCtSymRootFolder", "ctSymRootFolder", "compilationJdkVersion$delegate", "getCompilationJdkVersion", "()I", "compilationJdkVersion", "ctSymModules$delegate", "getCtSymModules", "ctSymModules", "isCompilationJDK12OrLater", "()Z", "getUseLastJdkApi", "useLastJdkApi", "Lkotlin/sequences/Sequence;", "getAllObservableModules", "()Lkotlin/sequences/Sequence;", "allObservableModules", "", "systemModulesCache", "Ljava/util/Map;", "getSystemModules", "systemModules", "nonModuleRoot$delegate", "getNonModuleRoot", "()Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModule$Root;", "nonModuleRoot", "listFoldersForRelease$delegate", "getListFoldersForRelease", "()Ljava/util/List;", "listFoldersForRelease"})
public final class CliJavaModuleFinder
implements JavaModuleFinder {
    @Nullable
    private final File jdkHome;
    @Nullable
    private final MessageCollector messageCollector;
    @NotNull
    private final KotlinCliJavaFileManager javaFileManager;
    @Nullable
    private final Integer jdkRelease;
    @Nullable
    private final VirtualFile jrtFileSystemRoot;
    @Nullable
    private final VirtualFile modulesRoot;
    @NotNull
    private final LinkedHashMap<String, JavaModule> userModules;
    @NotNull
    private final GlobalSearchScope allScope;
    @NotNull
    private final Lazy ctSymFile$delegate;
    @NotNull
    private final Lazy ctSymRootFolder$delegate;
    @NotNull
    private final Lazy compilationJdkVersion$delegate;
    @NotNull
    private final Lazy ctSymModules$delegate;
    @NotNull
    private final Map<String, JavaModule.Explicit> systemModulesCache;
    @NotNull
    private final Lazy nonModuleRoot$delegate;
    @NotNull
    private final Lazy listFoldersForRelease$delegate;

    /*
     * WARNING - void declaration
     */
    public CliJavaModuleFinder(@Nullable File jdkHome, @Nullable MessageCollector messageCollector, @NotNull KotlinCliJavaFileManager javaFileManager, @NotNull Project project, @Nullable Integer jdkRelease) {
        VirtualFile virtualFile;
        Intrinsics.checkNotNullParameter(javaFileManager, "javaFileManager");
        Intrinsics.checkNotNullParameter(project, "project");
        this.jdkHome = jdkHome;
        this.messageCollector = messageCollector;
        this.javaFileManager = javaFileManager;
        this.jdkRelease = jdkRelease;
        CliJavaModuleFinder cliJavaModuleFinder = this;
        Object object = this.jdkHome;
        if (object != null && (object = ((File)object).getPath()) != null) {
            void path;
            Object object2 = object;
            CliJavaModuleFinder cliJavaModuleFinder2 = cliJavaModuleFinder;
            boolean bl = false;
            VirtualFileSystem virtualFileSystem = VirtualFileManager.getInstance().getFileSystem("jrt");
            virtualFile = virtualFileSystem != null ? virtualFileSystem.findFileByPath((String)path + "!/") : null;
            cliJavaModuleFinder = cliJavaModuleFinder2;
        } else {
            virtualFile = null;
        }
        cliJavaModuleFinder.jrtFileSystemRoot = virtualFile;
        VirtualFile virtualFile2 = this.jrtFileSystemRoot;
        this.modulesRoot = virtualFile2 != null ? virtualFile2.findChild("modules") : null;
        this.userModules = new LinkedHashMap();
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope(project);
        Intrinsics.checkNotNullExpressionValue(globalSearchScope, "allScope(...)");
        this.allScope = globalSearchScope;
        this.ctSymFile$delegate = LazyKt.lazy(() -> CliJavaModuleFinder.ctSymFile_delegate$lambda$1(this));
        this.ctSymRootFolder$delegate = LazyKt.lazy(() -> CliJavaModuleFinder.ctSymRootFolder_delegate$lambda$2(this));
        this.compilationJdkVersion$delegate = LazyKt.lazy(() -> CliJavaModuleFinder.compilationJdkVersion_delegate$lambda$5(this));
        this.ctSymModules$delegate = LazyKt.lazy(() -> CliJavaModuleFinder.ctSymModules_delegate$lambda$6(this));
        this.systemModulesCache = new LinkedHashMap();
        this.nonModuleRoot$delegate = LazyKt.lazy(() -> CliJavaModuleFinder.nonModuleRoot_delegate$lambda$16(this));
        this.listFoldersForRelease$delegate = LazyKt.lazy(() -> CliJavaModuleFinder.listFoldersForRelease_delegate$lambda$20(this));
    }

    private final VirtualFile getCtSymFile() {
        Lazy lazy = this.ctSymFile$delegate;
        return (VirtualFile)lazy.getValue();
    }

    private final VirtualFile getCtSymRootFolder() {
        Lazy lazy = this.ctSymRootFolder$delegate;
        return (VirtualFile)lazy.getValue();
    }

    private final int getCompilationJdkVersion() {
        Lazy lazy = this.compilationJdkVersion$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    @NotNull
    public final Map<String, VirtualFile> getCtSymModules() {
        Lazy lazy = this.ctSymModules$delegate;
        return (Map)lazy.getValue();
    }

    private final boolean isCompilationJDK12OrLater() {
        return this.getCompilationJdkVersion() >= 12;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean getUseLastJdkApi() {
        if (this.jdkRelease == null) return true;
        Integer n = this.jdkRelease;
        int n2 = this.getCompilationJdkVersion();
        if (n == null) return false;
        if (n != n2) return false;
        return true;
    }

    public final void addUserModule(@NotNull JavaModule module2) {
        Intrinsics.checkNotNullParameter(module2, "module");
        this.userModules.putIfAbsent(module2.getName(), module2);
    }

    @NotNull
    public final Sequence<JavaModule> getAllObservableModules() {
        Sequence<JavaModule.Explicit> sequence2 = this.getSystemModules();
        Collection<JavaModule> collection = this.userModules.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        return SequencesKt.plus(sequence2, (Iterable)collection);
    }

    @NotNull
    public final Sequence<JavaModule.Explicit> getSystemModules() {
        Sequence<JavaModule.Explicit> sequence2;
        if (this.getUseLastJdkApi()) {
            VirtualFile virtualFile = this.modulesRoot;
            VirtualFile[] $this$orEmpty$iv = virtualFile != null ? virtualFile.getChildren() : null;
            boolean $i$f$orEmpty = false;
            VirtualFile[] virtualFileArray = $this$orEmpty$iv;
            if ($this$orEmpty$iv == null) {
                virtualFileArray = new VirtualFile[]{};
            }
            sequence2 = SequencesKt.mapNotNull(ArraysKt.asSequence(virtualFileArray), (Function1)new Function1<VirtualFile, JavaModule.Explicit>((Object)this){

                public final JavaModule.Explicit invoke(VirtualFile p0) {
                    Intrinsics.checkNotNullParameter(p0, "p0");
                    return CliJavaModuleFinder.findSystemModule$default((CliJavaModuleFinder)this.receiver, p0, false, 2, null);
                }
            });
        } else {
            sequence2 = SequencesKt.mapNotNull(CollectionsKt.asSequence((Iterable)this.getCtSymModules().values()), arg_0 -> CliJavaModuleFinder._get_systemModules_$lambda$7(this, arg_0));
        }
        return sequence2;
    }

    @Override
    @Nullable
    public JavaModule findModule(@NotNull String name) {
        JavaModule javaModule;
        JavaModule javaModule2;
        Intrinsics.checkNotNullParameter(name, "name");
        if (this.getUseLastJdkApi()) {
            JavaModule.Explicit explicit;
            VirtualFile virtualFile = this.modulesRoot;
            if (virtualFile != null && (virtualFile = virtualFile.findChild(name)) != null) {
                VirtualFile p0 = virtualFile;
                boolean bl = false;
                explicit = CliJavaModuleFinder.findSystemModule$default(this, p0, false, 2, null);
            } else {
                explicit = null;
            }
            javaModule2 = explicit;
        } else {
            JavaModule.Explicit explicit;
            VirtualFile virtualFile = this.getCtSymModules().get(name);
            if (virtualFile != null) {
                VirtualFile it = virtualFile;
                boolean bl = false;
                explicit = this.findSystemModule(it, true);
            } else {
                explicit = null;
            }
            javaModule2 = javaModule = (JavaModule)explicit;
        }
        if (javaModule2 == null) {
            javaModule = this.userModules.get(name);
        }
        return javaModule;
    }

    /*
     * WARNING - void declaration
     */
    private final JavaModule.Explicit findSystemModule(VirtualFile moduleRoot, boolean useSig) {
        Object object;
        void $this$getOrPut$iv;
        Object object2;
        VirtualFile virtualFile = moduleRoot.findChild(useSig ? "module-info.sig" : "module-info.class");
        if (virtualFile == null) {
            return null;
        }
        VirtualFile file2 = virtualFile;
        try {
            JavaModuleInfo javaModuleInfo = JavaModuleInfo.Companion.read(file2, this.javaFileManager, this.allScope);
            if (javaModuleInfo == null) {
                return null;
            }
            object2 = javaModuleInfo;
        }
        catch (JavaModuleInfo.FileReadingException e) {
            this.reportError(e.getMessage() + "\nCaused by: " + e.getCause().getClass().getName() + ": " + e.getCause().getMessage());
            throw new CompilationErrorException();
        }
        JavaModuleInfo moduleInfo = object2;
        object2 = this.systemModulesCache;
        String key$iv = moduleInfo.getModuleName();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            List<JavaModule.Root> list;
            boolean bl = false;
            if (this.getUseLastJdkApi()) {
                list = CollectionsKt.listOf(new JavaModule.Root(moduleRoot, true, useSig));
            } else if (useSig) {
                list = this.createModuleFromSignature(moduleInfo);
            } else {
                throw new IllegalStateException(("Can't find " + moduleRoot.getPath() + " module").toString());
            }
            JavaModule.Explicit answer$iv = new JavaModule.Explicit(moduleInfo, list, file2, !this.getUseLastJdkApi() && useSig);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (JavaModule.Explicit)object;
    }

    static /* synthetic */ JavaModule.Explicit findSystemModule$default(CliJavaModuleFinder cliJavaModuleFinder, VirtualFile virtualFile, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return cliJavaModuleFinder.findSystemModule(virtualFile, bl);
    }

    private final List<JavaModule.Root> createModuleFromSignature(JavaModuleInfo moduleInfo) {
        return CollectionsKt.listOf(this.createModuleFromSignature(!this.isCompilationJDK12OrLater(), this.isCompilationJDK12OrLater(), moduleInfo));
    }

    /*
     * WARNING - void declaration
     */
    private final JavaModule.Root createModuleFromSignature(boolean filterPackages, boolean filterModules, JavaModuleInfo moduleInfo) {
        VirtualFile virtualFile;
        List moduleFolders;
        List list;
        Map packageParts;
        Iterable $this$forEach$iv;
        Map map2;
        if (!filterPackages) {
            map2 = MapsKt.emptyMap();
        } else {
            JavaModuleInfo.Exports it;
            HashMap hashMap;
            HashMap parts = hashMap = new HashMap();
            boolean bl = false;
            $this$forEach$iv = moduleInfo.getExports();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (JavaModuleInfo.Exports)element$iv;
                boolean bl2 = false;
                Iterator<FqName> iterator2 = SequencesKt.generateSequence(it.getPackageFqName(), CliJavaModuleFinder::createModuleFromSignature$lambda$14$lambda$12$lambda$11).iterator();
                while (iterator2.hasNext()) {
                    FqName part = iterator2.next();
                    ((Map)parts).put(part.asString(), false);
                }
            }
            $this$forEach$iv = moduleInfo.getExports();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (JavaModuleInfo.Exports)element$iv;
                boolean bl3 = false;
                ((Map)parts).put(it.getPackageFqName().asString(), true);
            }
            map2 = packageParts = (Map)hashMap;
        }
        if (filterModules) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.getListFoldersForRelease();
            boolean $i$f$filter = false;
            $this$forEach$iv = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                VirtualFile virtualFile2 = (VirtualFile)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(virtualFile2.getName(), moduleInfo.getModuleName())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = moduleFolders = this.getListFoldersForRelease();
        }
        if ((virtualFile = this.getCtSymRootFolder()) == null) {
            virtualFile = this.getCtSymFile();
        }
        return new JavaModule.Root(new CtSymDirectoryContainer(virtualFile, moduleFolders, packageParts, "", moduleInfo.getModuleName(), !filterPackages), true, true);
    }

    private final String codeFor(int release) {
        String string2 = Integer.toString(release, CharsKt.checkRadix(36));
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        String string3 = string2.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string3, "toUpperCase(...)");
        return string3;
    }

    private final boolean matchesRelease(String fileName, int release) {
        return !StringsKt.contains$default((CharSequence)fileName, "-", false, 2, null) && StringsKt.contains$default((CharSequence)fileName, this.codeFor(release), false, 2, null);
    }

    @NotNull
    public final JavaModule.Root getNonModuleRoot() {
        Lazy lazy = this.nonModuleRoot$delegate;
        return (JavaModule.Root)lazy.getValue();
    }

    private final List<VirtualFile> getListFoldersForRelease() {
        Lazy lazy = this.listFoldersForRelease$delegate;
        return (List)lazy.getValue();
    }

    private final Map<String, VirtualFile> collectModuleRoots() {
        Map result2 = new LinkedHashMap();
        if (this.isCompilationJDK12OrLater()) {
            Iterable $this$forEach$iv = this.getListFoldersForRelease();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                VirtualFile modulesRoot = (VirtualFile)element$iv;
                boolean bl = false;
                if (modulesRoot.findChild("module-info.sig") == null) continue;
                boolean bl2 = false;
                result2.put(modulesRoot.getName(), modulesRoot);
            }
        } else {
            Integer n = this.jdkRelease;
            Intrinsics.checkNotNull(n);
            if (n > 8 && this.getCtSymRootFolder() != null) {
                VirtualFile virtualFile = this.getCtSymRootFolder();
                Intrinsics.checkNotNull(virtualFile);
                VirtualFile virtualFile2 = virtualFile.findChild(this.codeFor(this.jdkRelease) + (!this.isCompilationJDK12OrLater() ? "-modules" : ""));
                if (virtualFile2 != null) {
                    VirtualFile virtualFile3;
                    VirtualFile $this$collectModuleRoots_u24lambda_u2424 = virtualFile3 = virtualFile2;
                    boolean bl = false;
                    VirtualFile[] virtualFileArray = $this$collectModuleRoots_u24lambda_u2424.getChildren();
                    Intrinsics.checkNotNullExpressionValue(virtualFileArray, "getChildren(...)");
                    Object[] $this$forEach$iv = virtualFileArray;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        VirtualFile it = (VirtualFile)element$iv;
                        boolean bl3 = false;
                        result2.put(it.getName(), it);
                    }
                } else {
                    StringBuilder stringBuilder = new StringBuilder().append("Can't find modules signatures in `ct.sym` file for `-Xjdk-release=").append(this.jdkRelease).append("` in ");
                    VirtualFile virtualFile4 = this.getCtSymFile();
                    Intrinsics.checkNotNull(virtualFile4);
                    this.reportError(stringBuilder.append(virtualFile4.getPath()).toString());
                }
            }
        }
        return result2;
    }

    private final VirtualFile reportError(String message) {
        block0: {
            MessageCollector messageCollector = this.messageCollector;
            if (messageCollector == null) break block0;
            MessageCollector.report$default(messageCollector, CompilerMessageSeverity.ERROR, message, null, 4, null);
        }
        return null;
    }

    private static final VirtualFile ctSymFile_delegate$lambda$1(CliJavaModuleFinder this$0) {
        if (this$0.jdkHome == null) {
            return this$0.reportError("JDK_HOME path is not specified in compiler configuration");
        }
        VirtualFile virtualFile = StandardFileSystems.local().findFileByPath(this$0.jdkHome.getPath());
        if (virtualFile == null) {
            return this$0.reportError("Can't create virtual file for JDK root under " + this$0.jdkHome.getPath());
        }
        VirtualFile jdkRootFile = virtualFile;
        VirtualFile virtualFile2 = jdkRootFile.findChild("lib");
        if (virtualFile2 == null) {
            return this$0.reportError("Can't find `lib` folder under JDK root: " + this$0.jdkHome.getPath());
        }
        VirtualFile lib = virtualFile2;
        VirtualFile virtualFile3 = lib.findChild("ct.sym");
        if (virtualFile3 == null) {
            return this$0.reportError("This JDK does not have the 'ct.sym' file required for the '-Xjdk-release=" + this$0.jdkRelease + "' option: " + this$0.jdkHome.getPath());
        }
        VirtualFile ctSym = virtualFile3;
        return ctSym;
    }

    private static final VirtualFile ctSymRootFolder_delegate$lambda$2(CliJavaModuleFinder this$0) {
        Object object;
        block4: {
            block2: {
                block3: {
                    if (this$0.getCtSymFile() == null) break block2;
                    object = StandardFileSystems.jar();
                    if (object == null) break block3;
                    VirtualFile virtualFile = this$0.getCtSymFile();
                    if ((object = ((VirtualFileSystem)object).findFileByPath((virtualFile != null ? virtualFile.getPath() : null) + "!/")) != null) break block4;
                }
                VirtualFile virtualFile = this$0.getCtSymFile();
                object = this$0.reportError("Can't open `ct.sym` as jar file, file path: " + (virtualFile != null ? virtualFile.getPath() : null) + ' ');
                break block4;
            }
            object = null;
        }
        return object;
    }

    private static final int compilationJdkVersion_delegate$lambda$5(CliJavaModuleFinder this$0) {
        int n;
        VirtualFile[] virtualFileArray = this$0.getCtSymRootFolder();
        if (virtualFileArray != null && (virtualFileArray = virtualFileArray.getChildren()) != null) {
            boolean bl;
            int n2;
            VirtualFile[] virtualFileArray2 = virtualFileArray;
            if (virtualFileArray2.length == 0) {
                throw new NoSuchElementException();
            }
            VirtualFile it = virtualFileArray2[0];
            boolean bl2 = false;
            if (Intrinsics.areEqual(it.getName(), "META-INF")) {
                n2 = -1;
            } else {
                String string2 = it.getName();
                Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
                CharSequence charSequence = StringsKt.substringBeforeLast$default(string2, "-modules", null, 2, null);
                if (charSequence.length() == 0) {
                    throw new NoSuchElementException();
                }
                int n3 = charSequence.charAt(0);
                int n4 = 0;
                Integer n5 = StringsKt.toIntOrNull(String.valueOf((char)n3), 36);
                n3 = n5 != null ? n5 : -1;
                n4 = 1;
                int n6 = StringsKt.getLastIndex(charSequence);
                if (n4 <= n6) {
                    while (true) {
                        n14 = charSequence.charAt(n4);
                        bl = false;
                        Integer n7 = StringsKt.toIntOrNull(String.valueOf((char)n14), 36);
                        int n8 = n14 = n7 != null ? n7 : -1;
                        if (n3 < n14) {
                            n3 = n14;
                        }
                        if (n4 == n6) break;
                        ++n4;
                    }
                }
                n2 = n3;
            }
            int n9 = n2;
            int n10 = 1;
            int n11 = ArraysKt.getLastIndex(virtualFileArray2);
            if (n10 <= n11) {
                while (true) {
                    int n12;
                    int n13;
                    VirtualFile it2 = virtualFileArray2[n10];
                    $i$a$-maxOf-CliJavaModuleFinder$compilationJdkVersion$2$1 = false;
                    if (Intrinsics.areEqual(it2.getName(), "META-INF")) {
                        n13 = -1;
                    } else {
                        String string3 = it2.getName();
                        Intrinsics.checkNotNullExpressionValue(string3, "getName(...)");
                        CharSequence charSequence = StringsKt.substringBeforeLast$default(string3, "-modules", null, 2, null);
                        if (charSequence.length() == 0) {
                            throw new NoSuchElementException();
                        }
                        int n14 = charSequence.charAt(0);
                        bl = false;
                        Integer n15 = StringsKt.toIntOrNull(String.valueOf((char)n14), 36);
                        int n16 = n15 != null ? n15 : -1;
                        int n17 = 1;
                        int n18 = StringsKt.getLastIndex(charSequence);
                        if (n17 <= n18) {
                            while (true) {
                                int n19;
                                char c = charSequence.charAt(n17);
                                $i$a$-maxOf-CliJavaModuleFinder$compilationJdkVersion$2$1$1 = false;
                                Integer n20 = StringsKt.toIntOrNull(String.valueOf(c), 36);
                                int n21 = n19 = n20 != null ? n20 : -1;
                                if (n16 < n19) {
                                    n16 = n19;
                                }
                                if (n17 == n18) break;
                                ++n17;
                            }
                        }
                        n13 = n16;
                    }
                    if (n9 < (n12 = n13)) {
                        n9 = n12;
                    }
                    if (n10 == n11) break;
                    ++n10;
                }
            }
            n = n9;
        } else {
            n = -1;
        }
        return n;
    }

    private static final Map ctSymModules_delegate$lambda$6(CliJavaModuleFinder this$0) {
        return this$0.collectModuleRoots();
    }

    private static final JavaModule.Explicit _get_systemModules_$lambda$7(CliJavaModuleFinder this$0, VirtualFile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return this$0.findSystemModule(it, true);
    }

    private static final FqName createModuleFromSignature$lambda$14$lambda$12$lambda$11(FqName part) {
        Intrinsics.checkNotNullParameter(part, "part");
        return !part.isRoot() ? part.parent() : null;
    }

    private static final JavaModule.Root nonModuleRoot_delegate$lambda$16(CliJavaModuleFinder this$0) {
        return this$0.createModuleFromSignature(false, false, new JavaModuleInfo("*", CollectionsKt.emptyList(), CollectionsKt.emptyList(), CollectionsKt.emptyList()));
    }

    /*
     * WARNING - void declaration
     */
    private static final List listFoldersForRelease_delegate$lambda$20(CliJavaModuleFinder this$0) {
        List list;
        if (this$0.getCtSymRootFolder() == null) {
            list = CollectionsKt.emptyList();
        } else {
            List list2;
            void $this$flatMapTo$iv$iv;
            Iterable $this$filterTo$iv$iv;
            VirtualFile virtualFile = this$0.getCtSymRootFolder();
            Intrinsics.checkNotNull(virtualFile);
            VirtualFile[] virtualFileArray = virtualFile.getChildren();
            Intrinsics.checkNotNullExpressionValue(virtualFileArray, "getChildren(...)");
            Object[] $this$filter$iv = virtualFileArray;
            boolean $i$f$filter = false;
            Object[] objectArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                VirtualFile it = (VirtualFile)element$iv$iv;
                boolean bl = false;
                String string2 = it.getName();
                Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
                Integer n = this$0.jdkRelease;
                Intrinsics.checkNotNull(n);
                if (!this$0.matchesRelease(string2, n)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$flatMap$iv = (List)destination$iv$iv;
            boolean $i$f$flatMap = false;
            $this$filterTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                List<Object> list3;
                VirtualFile it = (VirtualFile)element$iv$iv;
                boolean bl = false;
                if (this$0.isCompilationJDK12OrLater()) {
                    VirtualFile[] virtualFileArray2 = it.getChildren();
                    Intrinsics.checkNotNullExpressionValue(virtualFileArray2, "getChildren(...)");
                    list3 = ArraysKt.toList((Object[])virtualFileArray2);
                } else {
                    list3 = CollectionsKt.listOf(it);
                }
                Iterable list$iv$iv = list3;
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            List $this$listFoldersForRelease_delegate_u24lambda_u2420_u24lambda_u2419 = list2 = (List)destination$iv$iv;
            boolean bl = false;
            if ($this$listFoldersForRelease_delegate_u24lambda_u2420_u24lambda_u2419.isEmpty()) {
                File file2 = this$0.jdkHome;
                this$0.reportError("'-Xjdk-release=" + this$0.jdkRelease + "' option is not supported by used JDK: " + (file2 != null ? file2.getPath() : null));
            }
            list = list2;
        }
        return list;
    }
}

