/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.modules;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.jvm.modules.JavaModuleGraph;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.load.java.structure.JavaAnnotation;
import org.jetbrains.kotlin.load.kotlin.VirtualFileFinder;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.jvm.modules.JavaModule;
import org.jetbrains.kotlin.resolve.jvm.modules.JavaModuleInfo;
import org.jetbrains.kotlin.resolve.jvm.modules.JavaModuleResolver;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 +2\u00020\u0001:\u0001+B3\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001f\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\rH\u0017\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0019\u0010\u0014\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001c\u0010\u0017\u001a\u00020\u0016*\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0012H\u0082\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J-\u0010\u001e\u001a\u0004\u0018\u00010\u001d2\b\u0010\u0019\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001a\u001a\u00020\u00122\b\u0010\u001c\u001a\u0004\u0018\u00010\u001bH\u0017\u00a2\u0006\u0004\b\u001e\u0010\u001fR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010 R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010!R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010!R\u0014\u0010\n\u001a\u00020\t8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010\"R\u001b\u0010(\u001a\u00020#8BX\u0083\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b&\u0010'R\u0016\u0010)\u001a\u0004\u0018\u00010\u00058\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b)\u0010*"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/modules/CliJavaModuleResolver;", "Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModuleResolver;", "Lorg/jetbrains/kotlin/cli/jvm/modules/JavaModuleGraph;", "moduleGraph", "", "Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModule;", "userModules", "Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModule$Explicit;", "systemModules", "Lcom/intellij/openapi/project/Project;", "project", "<init>", "(Lorg/jetbrains/kotlin/cli/jvm/modules/JavaModuleGraph;Ljava/util/List;Ljava/util/List;Lcom/intellij/openapi/project/Project;)V", "Lorg/jetbrains/kotlin/name/ClassId;", "classId", "Lorg/jetbrains/kotlin/load/java/structure/JavaAnnotation;", "getAnnotationsForModuleOwnerOfClass", "(Lorg/jetbrains/kotlin/name/ClassId;)Ljava/util/List;", "Lcom/intellij/openapi/vfs/VirtualFile;", "file", "findJavaModule", "(Lcom/intellij/openapi/vfs/VirtualFile;)Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModule;", "", "contains", "(Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModule;Lcom/intellij/openapi/vfs/VirtualFile;)Z", "fileFromOurModule", "referencedFile", "Lorg/jetbrains/kotlin/name/FqName;", "referencedPackage", "Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModuleResolver$AccessError;", "checkAccessibility", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/vfs/VirtualFile;Lorg/jetbrains/kotlin/name/FqName;)Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModuleResolver$AccessError;", "Lorg/jetbrains/kotlin/cli/jvm/modules/JavaModuleGraph;", "Ljava/util/List;", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/kotlin/load/kotlin/VirtualFileFinder;", "virtualFileFinder$delegate", "Lkotlin/Lazy;", "getVirtualFileFinder", "()Lorg/jetbrains/kotlin/load/kotlin/VirtualFileFinder;", "virtualFileFinder", "sourceModule", "Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModule;", "Companion"})
public final class CliJavaModuleResolver
implements JavaModuleResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JavaModuleGraph moduleGraph;
    @NotNull
    private final List<JavaModule> userModules;
    @NotNull
    private final List<JavaModule.Explicit> systemModules;
    @NotNull
    private final Project project;
    @NotNull
    private final Lazy virtualFileFinder$delegate;
    @Nullable
    private final JavaModule sourceModule;

    /*
     * WARNING - void declaration
     */
    public CliJavaModuleResolver(@NotNull JavaModuleGraph moduleGraph, @NotNull List<? extends JavaModule> userModules, @NotNull List<JavaModule.Explicit> systemModules2, @NotNull Project project) {
        Object v2;
        block5: {
            void $this$firstOrNull$iv;
            int n;
            Intrinsics.checkNotNullParameter(moduleGraph, "moduleGraph");
            Intrinsics.checkNotNullParameter(userModules, "userModules");
            Intrinsics.checkNotNullParameter(systemModules2, "systemModules");
            Intrinsics.checkNotNullParameter(project, "project");
            this.moduleGraph = moduleGraph;
            this.userModules = userModules;
            this.systemModules = systemModules2;
            this.project = project;
            Iterable $this$count$iv = this.userModules;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    JavaModule p0 = (JavaModule)element$iv;
                    boolean bl = false;
                    if (!p0.isSourceModule() || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            boolean bl = $this$count$iv = n <= 1;
            if (_Assertions.ENABLED && !$this$count$iv) {
                boolean $i$a$-assert-CliJavaModuleResolver$32 = false;
                String $i$a$-assert-CliJavaModuleResolver$32 = "Modules computed by ClasspathRootsResolver cannot have more than one source module: " + this.userModules;
                throw new AssertionError((Object)$i$a$-assert-CliJavaModuleResolver$32);
            }
            this.virtualFileFinder$delegate = LazyKt.lazy(() -> CliJavaModuleResolver.virtualFileFinder_delegate$lambda$1(this));
            $this$count$iv = this.userModules;
            CliJavaModuleResolver cliJavaModuleResolver = this;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                JavaModule p0 = (JavaModule)element$iv;
                boolean bl2 = false;
                if (!p0.isSourceModule()) continue;
                v2 = element$iv;
                break block5;
            }
            v2 = null;
        }
        cliJavaModuleResolver.sourceModule = v2;
    }

    private final VirtualFileFinder getVirtualFileFinder() {
        Lazy lazy = this.virtualFileFinder$delegate;
        return (VirtualFileFinder)lazy.getValue();
    }

    @Override
    @Nullable
    public List<JavaAnnotation> getAnnotationsForModuleOwnerOfClass(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter(classId, "classId");
        VirtualFile virtualFile = this.getVirtualFileFinder().findSourceOrBinaryVirtualFile(classId);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        JavaModule javaModule = this.findJavaModule(virtualFile2);
        Object object = javaModule instanceof JavaModule.Explicit ? (JavaModule.Explicit)javaModule : null;
        return object != null && (object = ((JavaModule.Explicit)object).getModuleInfo()) != null ? ((JavaModuleInfo)object).getAnnotations() : null;
    }

    private final JavaModule findJavaModule(VirtualFile file2) {
        JavaModule javaModule;
        if (Intrinsics.areEqual(file2.getFileSystem().getProtocol(), "jrt") || Intrinsics.areEqual(file2.getExtension(), "sig")) {
            Object v0;
            block7: {
                Iterable $this$firstOrNull$iv = this.systemModules;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    JavaModule.Explicit module2 = (JavaModule.Explicit)element$iv;
                    boolean bl = false;
                    if (!this.contains(module2, file2)) continue;
                    v0 = element$iv;
                    break block7;
                }
                v0 = null;
            }
            return v0;
        }
        FileType fileType = file2.getFileType();
        if (Intrinsics.areEqual(fileType, KotlinFileType.INSTANCE) || Intrinsics.areEqual(fileType, JavaFileType.INSTANCE)) {
            javaModule = this.sourceModule;
        } else if (Intrinsics.areEqual(fileType, JavaClassFileType.INSTANCE)) {
            Object v2;
            block8: {
                Iterable $this$firstOrNull$iv = this.userModules;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    JavaModule module3 = (JavaModule)element$iv;
                    boolean bl = false;
                    if (!this.contains(module3, file2)) continue;
                    v2 = element$iv;
                    break block8;
                }
                v2 = null;
            }
            javaModule = v2;
        } else {
            javaModule = null;
        }
        return javaModule;
    }

    private final boolean contains(JavaModule $this$contains, VirtualFile file2) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter($this$contains, "<this>");
            Iterable $this$any$iv = $this$contains.getModuleRoots();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    JavaModule.Root root = (JavaModule.Root)element$iv;
                    boolean bl2 = false;
                    VirtualFile root2 = root.component1();
                    boolean isBinary = root.component2();
                    if (!(isBinary && VfsUtilCore.isAncestor(root2, file2, false))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    @Nullable
    public JavaModuleResolver.AccessError checkAccessibility(@Nullable VirtualFile fileFromOurModule, @NotNull VirtualFile referencedFile, @Nullable FqName referencedPackage) {
        JavaModule javaModule;
        Intrinsics.checkNotNullParameter(referencedFile, "referencedFile");
        VirtualFile virtualFile = fileFromOurModule;
        if (virtualFile != null) {
            VirtualFile p0 = virtualFile;
            boolean bl = false;
            javaModule = this.findJavaModule(p0);
        } else {
            javaModule = null;
        }
        JavaModule ourModule = javaModule;
        JavaModule theirModule = this.findJavaModule(referencedFile);
        JavaModule javaModule2 = ourModule;
        JavaModule javaModule3 = theirModule;
        if (Intrinsics.areEqual(javaModule2 != null ? javaModule2.getName() : null, javaModule3 != null ? javaModule3.getName() : null)) {
            return null;
        }
        if (theirModule == null) {
            return JavaModuleResolver.AccessError.ModuleDoesNotReadUnnamedModule.INSTANCE;
        }
        if (ourModule != null && !this.moduleGraph.reads(ourModule.getName(), theirModule.getName())) {
            return new JavaModuleResolver.AccessError.ModuleDoesNotReadModule(theirModule.getName());
        }
        FqName fqName2 = referencedPackage;
        if (fqName2 == null) {
            return null;
        }
        FqName fqName3 = fqName2;
        if (!(theirModule.exports(fqName3) || ourModule != null && theirModule.exportsTo(fqName3, ourModule.getName()))) {
            return new JavaModuleResolver.AccessError.ModuleDoesNotExportPackage(theirModule.getName());
        }
        return null;
    }

    private static final VirtualFileFinder virtualFileFinder_delegate$lambda$1(CliJavaModuleResolver this$0) {
        return VirtualFileFinder.SERVICE.getInstance(this$0.project);
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

