/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.modules;

import com.intellij.openapi.vfs.DeprecatedVirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ConcurrentFactoryMap;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.jvm.modules.CoreJrtVirtualFile;
import org.jetbrains.kotlin.cli.jvm.modules.JavaVersionUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0017\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0019\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0007\u001a\u00020\u0004H\u0017\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0019\u0010\u0010\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0007\u001a\u00020\u0004H\u0017\u00a2\u0006\u0004\b\u0010\u0010\nR-\u0010\u0014\u001a\u001b\u0012\b\u0012\u0006*\u00020\u00040\u0004\u0012\b\u0012\u0006*\u00020\u00120\u00120\u0011\u00a2\u0006\u0002\b\u00138\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/modules/CoreJrtFileSystem;", "Lcom/intellij/openapi/vfs/DeprecatedVirtualFileSystem;", "<init>", "()V", "", "getProtocol", "()Ljava/lang/String;", "path", "Lcom/intellij/openapi/vfs/VirtualFile;", "findFileByPath", "(Ljava/lang/String;)Lcom/intellij/openapi/vfs/VirtualFile;", "", "asynchronous", "", "refresh", "(Z)V", "refreshAndFindFileByPath", "Ljava/util/concurrent/ConcurrentMap;", "Lorg/jetbrains/kotlin/cli/jvm/modules/CoreJrtVirtualFile;", "Lorg/jetbrains/annotations/NotNull;", "roots", "Ljava/util/concurrent/ConcurrentMap;", "Companion"})
public final class CoreJrtFileSystem
extends DeprecatedVirtualFileSystem {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentMap<String, CoreJrtVirtualFile> roots;
    @NotNull
    private static final ConcurrentMap<String, FileSystem> globalJrtFsCache;

    public CoreJrtFileSystem() {
        ConcurrentMap<Object, CoreJrtVirtualFile> concurrentMap = ConcurrentFactoryMap.createMap(arg_0 -> CoreJrtFileSystem.roots$lambda$1(arg_0 -> CoreJrtFileSystem.roots$lambda$0(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue(concurrentMap, "createMap(...)");
        this.roots = concurrentMap;
    }

    @Override
    @NotNull
    public String getProtocol() {
        return "jrt";
    }

    @Override
    @Nullable
    public VirtualFile findFileByPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter(path, "path");
        Pair<String, String> pair = Companion.splitPath(path);
        String jdkHomePath = pair.component1();
        String pathInImage = pair.component2();
        CoreJrtVirtualFile coreJrtVirtualFile = (CoreJrtVirtualFile)this.roots.get(jdkHomePath);
        if (coreJrtVirtualFile == null) {
            return null;
        }
        CoreJrtVirtualFile root = coreJrtVirtualFile;
        if (((CharSequence)pathInImage).length() == 0) {
            return root;
        }
        return root.findFileByRelativePath(pathInImage);
    }

    @Override
    public void refresh(boolean asynchronous) {
    }

    @Override
    @Nullable
    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter(path, "path");
        return this.findFileByPath(path);
    }

    private static final CoreJrtVirtualFile roots$lambda$0(CoreJrtFileSystem this$0, String jdkHomePath) {
        FileSystem fileSystem = (FileSystem)globalJrtFsCache.get(jdkHomePath);
        if (fileSystem == null) {
            return null;
        }
        FileSystem fileSystem2 = fileSystem;
        Intrinsics.checkNotNull(jdkHomePath);
        Path path = fileSystem2.getPath("", new String[0]);
        Intrinsics.checkNotNullExpressionValue(path, "getPath(...)");
        return new CoreJrtVirtualFile(this$0, jdkHomePath, path, null);
    }

    private static final CoreJrtVirtualFile roots$lambda$1(Function1 $tmp0, Object p0) {
        return (CoreJrtVirtualFile)$tmp0.invoke(p0);
    }

    private static final FileSystem globalJrtFsCache$lambda$2(String jdkHomePath) {
        FileSystem fileSystem;
        File jdkHome = new File(jdkHomePath);
        File file2 = CoreJrtFileSystem.Companion.loadJrtFsJar(jdkHome);
        if (file2 == null) {
            return null;
        }
        File jrtFsJar = file2;
        URI rootUri = URI.create("jrt:/");
        if (JavaVersionUtilsKt.isAtLeastJava9()) {
            fileSystem = FileSystems.newFileSystem(rootUri, MapsKt.mapOf(TuplesKt.to("java.home", jdkHome.getAbsolutePath())));
        } else {
            URL[] uRLArray = new URL[]{jrtFsJar.toURI().toURL()};
            URLClassLoader classLoader = new URLClassLoader(uRLArray, null);
            fileSystem = FileSystems.newFileSystem(rootUri, MapsKt.emptyMap(), (ClassLoader)classLoader);
        }
        return fileSystem;
    }

    private static final FileSystem globalJrtFsCache$lambda$3(Function1 $tmp0, Object p0) {
        return (FileSystem)$tmp0.invoke(p0);
    }

    static {
        ConcurrentMap<Object, FileSystem> concurrentMap = ConcurrentFactoryMap.createMap(arg_0 -> CoreJrtFileSystem.globalJrtFsCache$lambda$3(CoreJrtFileSystem::globalJrtFsCache$lambda$2, arg_0));
        Intrinsics.checkNotNullExpressionValue(concurrentMap, "createMap(...)");
        globalJrtFsCache = concurrentMap;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\u0006\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J#\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\n2\u0006\u0010\t\u001a\u00020\bH\u0007\u00a2\u0006\u0004\b\u000b\u0010\fR-\u0010\u0010\u001a\u001b\u0012\b\u0012\u0006*\u00020\b0\b\u0012\b\u0012\u0006*\u00020\u000e0\u000e0\r\u00a2\u0006\u0002\b\u000f8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/modules/CoreJrtFileSystem$Companion;", "", "<init>", "()V", "Ljava/io/File;", "jdkHome", "loadJrtFsJar", "(Ljava/io/File;)Ljava/io/File;", "", "path", "Lkotlin/Pair;", "splitPath", "(Ljava/lang/String;)Lkotlin/Pair;", "Ljava/util/concurrent/ConcurrentMap;", "Ljava/nio/file/FileSystem;", "Lorg/jetbrains/annotations/NotNull;", "globalJrtFsCache", "Ljava/util/concurrent/ConcurrentMap;"})
    public static final class Companion {
        private Companion() {
        }

        private final File loadJrtFsJar(File jdkHome) {
            File file2;
            File p0 = file2 = new File(jdkHome, "lib/jrt-fs.jar");
            boolean bl = false;
            return p0.exists() ? file2 : null;
        }

        @NotNull
        public final Pair<String, String> splitPath(@NotNull String path) {
            Intrinsics.checkNotNullParameter(path, "path");
            int separator = StringsKt.indexOf$default((CharSequence)path, "!/", 0, false, 6, null);
            if (separator < 0) {
                throw new IllegalArgumentException("Path in CoreJrtFileSystem must contain a separator: " + path);
            }
            String string2 = path.substring(0, separator);
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
            String localPath = string2;
            String string3 = path.substring(separator + 2);
            Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
            String pathInJar = string3;
            return new Pair<String, String>(localPath, pathInJar);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

