/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.modules;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.jvm.modules.CtSymClassVirtualFile;

public final class CtSymDirectoryContainer
extends VirtualFile {
    @Nullable
    private final VirtualFile parent;
    @NotNull
    private final List<VirtualFile> rootOrPackageParts;
    @NotNull
    private final Map<String, Boolean> packages;
    @NotNull
    private final String currentPackage;
    @NotNull
    private final String moduleRoot;
    private final boolean skipPackageCheck;
    @NotNull
    private final Lazy _path$delegate;
    @NotNull
    private final Lazy _fileSystem$delegate;
    @NotNull
    private final Lazy _isValid$delegate;
    @NotNull
    private final Lazy _children$delegate;

    public CtSymDirectoryContainer(@Nullable VirtualFile parent2, @NotNull List<? extends VirtualFile> rootOrPackageParts, @NotNull Map<String, Boolean> packages2, @NotNull String currentPackage, @NotNull String moduleRoot, boolean skipPackageCheck) {
        Intrinsics.checkNotNullParameter(rootOrPackageParts, "rootOrPackageParts");
        Intrinsics.checkNotNullParameter(packages2, "packages");
        Intrinsics.checkNotNullParameter(currentPackage, "currentPackage");
        Intrinsics.checkNotNullParameter(moduleRoot, "moduleRoot");
        this.parent = parent2;
        this.rootOrPackageParts = rootOrPackageParts;
        this.packages = packages2;
        this.currentPackage = currentPackage;
        this.moduleRoot = moduleRoot;
        this.skipPackageCheck = skipPackageCheck;
        this._path$delegate = LazyKt.lazy(() -> CtSymDirectoryContainer._path_delegate$lambda$0(this));
        this._fileSystem$delegate = LazyKt.lazy(() -> CtSymDirectoryContainer._fileSystem_delegate$lambda$1(this));
        this._isValid$delegate = LazyKt.lazy(() -> CtSymDirectoryContainer._isValid_delegate$lambda$3(this));
        this._children$delegate = LazyKt.lazy(() -> CtSymDirectoryContainer._children_delegate$lambda$9(this));
    }

    private final String get_path() {
        Lazy lazy = this._path$delegate;
        return (String)lazy.getValue();
    }

    private final VirtualFileSystem get_fileSystem() {
        Lazy lazy = this._fileSystem$delegate;
        return (VirtualFileSystem)lazy.getValue();
    }

    private final boolean get_isValid() {
        Lazy lazy = this._isValid$delegate;
        return (Boolean)lazy.getValue();
    }

    private final VirtualFile[] get_children() {
        Lazy lazy = this._children$delegate;
        return (VirtualFile[])lazy.getValue();
    }

    @Override
    @NotNull
    public String getName() {
        return StringsKt.substringAfterLast$default(this.currentPackage, ".", null, 2, null);
    }

    @Override
    @NotNull
    public VirtualFileSystem getFileSystem() {
        return this.get_fileSystem();
    }

    @Override
    @NotNull
    public String getPath() {
        return this.get_path();
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    @Override
    public boolean isValid() {
        return this.get_isValid();
    }

    @Override
    @Nullable
    public VirtualFile getParent() {
        return this.parent;
    }

    @Override
    @Nullable
    public VirtualFile[] getChildren() {
        return this.get_children();
    }

    @NotNull
    public Void getOutputStream(@Nullable Object p0, long p1, long p2) {
        throw new IllegalStateException("not supported".toString());
    }

    @Override
    @NotNull
    public byte[] contentsToByteArray() {
        throw new IllegalStateException("not supported".toString());
    }

    @NotNull
    public Void getTimeStamp() {
        throw new IllegalStateException("not supported".toString());
    }

    @NotNull
    public Void getLength() {
        throw new IllegalStateException("not supported".toString());
    }

    @Override
    public void refresh(boolean p0, boolean p1, @Nullable Runnable p2) {
    }

    @Override
    @NotNull
    public InputStream getInputStream() {
        throw new IllegalStateException("not supported".toString());
    }

    private static final String _path_delegate$lambda$0(CtSymDirectoryContainer this$0) {
        VirtualFile virtualFile = this$0.parent;
        return (virtualFile != null ? virtualFile.getPath() : null) + this$0.currentPackage + '/';
    }

    private static final VirtualFileSystem _fileSystem_delegate$lambda$1(CtSymDirectoryContainer this$0) {
        VirtualFile virtualFile = this$0.parent;
        Intrinsics.checkNotNull(virtualFile);
        return virtualFile.getFileSystem();
    }

    private static final boolean _isValid_delegate$lambda$3(CtSymDirectoryContainer this$0) {
        boolean bl;
        block3: {
            Iterable $this$all$iv = this$0.rootOrPackageParts;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    VirtualFile it = (VirtualFile)element$iv;
                    boolean bl2 = false;
                    if (it.isValid()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private static final VirtualFile[] _children_delegate$lambda$9(CtSymDirectoryContainer this$0) {
        void $this$toTypedArray$iv;
        void $this$mapNotNullTo$iv$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this$0.rootOrPackageParts;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo22 = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            Object object = it.getChildren();
            if (object == null || (object = ArraysKt.toList(object)) == null) {
                object = CollectionsKt.emptyList();
            }
            Iterable list$iv$iv = (Iterable)object;
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        List children2 = (List)destination$iv$iv;
        if (children2.isEmpty()) {
            return new VirtualFile[0];
        }
        boolean isExported = this$0.skipPackageCheck || this$0.packages.getOrDefault(this$0.currentPackage, false) != false;
        Map containers = new LinkedHashMap();
        Iterable $this$mapNotNull$iv = children2;
        boolean $i$f$mapNotNull = false;
        Iterable $i$f$flatMapTo22 = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            VirtualFile virtualFile;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            VirtualFile child = (VirtualFile)element$iv$iv;
            boolean bl2 = false;
            if (child.isDirectory()) {
                String string2 = ((CharSequence)this$0.currentPackage).length() == 0 ? child.getName() : this$0.currentPackage + '.' + child.getName();
                Intrinsics.checkNotNull(string2);
                String childPackage = string2;
                CtSymDirectoryContainer addingEntry = null;
                if (this$0.skipPackageCheck || this$0.packages.containsKey(childPackage)) {
                    Object object;
                    Map $this$getOrPut$iv = containers;
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv.get(childPackage);
                    if (value$iv == null) {
                        CtSymDirectoryContainer ctSymDirectoryContainer;
                        boolean bl3 = false;
                        List list = new ArrayList();
                        CtSymDirectoryContainer it = ctSymDirectoryContainer = new CtSymDirectoryContainer(this$0, list, this$0.packages, childPackage, this$0.moduleRoot, this$0.skipPackageCheck);
                        boolean bl4 = false;
                        addingEntry = it;
                        Pair<CtSymDirectoryContainer, List> answer$iv = TuplesKt.to(ctSymDirectoryContainer, list);
                        $this$getOrPut$iv.put(childPackage, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    Object v = object;
                    Pair it = (Pair)v;
                    boolean bl5 = false;
                    List list = (List)it.getSecond();
                    Intrinsics.checkNotNull(child);
                    list.add(child);
                }
                virtualFile = addingEntry;
            } else if (isExported) {
                VirtualFile virtualFile2 = this$0;
                Intrinsics.checkNotNull(child);
                virtualFile = new CtSymClassVirtualFile(virtualFile2, child);
            } else {
                virtualFile = null;
            }
            if (virtualFile == null) continue;
            VirtualFile it$iv$iv = virtualFile;
            boolean bl6 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv2;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new VirtualFile[0]);
    }
}

