/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.plugins;

import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.compiler.plugin.AbstractCliOption;
import org.jetbrains.kotlin.compiler.plugin.CliOptionProcessingException;
import org.jetbrains.kotlin.compiler.plugin.CliOptionValue;
import org.jetbrains.kotlin.compiler.plugin.CliOptionsKt;
import org.jetbrains.kotlin.compiler.plugin.CommandLineProcessor;
import org.jetbrains.kotlin.compiler.plugin.PluginCliOptionProcessingException;
import org.jetbrains.kotlin.config.CompilerConfiguration;

public final class PluginsOptionsParserKt {
    /*
     * WARNING - void declaration
     */
    public static final void processCompilerPluginsOptions(@NotNull CompilerConfiguration configuration2, @Nullable Iterable<String> pluginOptions, @NotNull List<? extends CommandLineProcessor> commandLineProcessors) {
        Map map2;
        Intrinsics.checkNotNullParameter(configuration2, "configuration");
        Intrinsics.checkNotNullParameter(commandLineProcessors, "commandLineProcessors");
        Iterable<String> iterable = pluginOptions;
        if (iterable != null) {
            void $this$groupByTo$iv$iv;
            void $this$mapTo$iv$iv;
            Iterable<String> iterable2 = iterable;
            boolean $i$f$map = false;
            Iterable<String> iterable3 = iterable2;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault(iterable2, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(CliOptionsKt.parseLegacyPluginOption((String)p0));
            }
            Iterable $this$groupBy$iv = (List)destination$iv$iv;
            boolean $i$f$groupBy = false;
            destination$iv$iv = $this$groupBy$iv;
            Map destination$iv$iv2 = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                CliOptionValue it = (CliOptionValue)element$iv$iv;
                boolean bl = false;
                if (it == null) {
                    throw new CliOptionProcessingException("Wrong plugin option format: " + it + ", should be plugin:<pluginId>:<optionName>=<value>", null, 2, null);
                }
                String key$iv$iv = it.getPluginId();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv2;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            map2 = destination$iv$iv2;
        } else {
            map2 = MapsKt.emptyMap();
        }
        Map optionValuesByPlugin = map2;
        for (CommandLineProcessor commandLineProcessor : commandLineProcessors) {
            List<CliOptionValue> list = (List<CliOptionValue>)optionValuesByPlugin.get(commandLineProcessor.getPluginId());
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            Intrinsics.checkNotNull(list, "null cannot be cast to non-null type kotlin.collections.List<org.jetbrains.kotlin.compiler.plugin.CliOptionValue>");
            PluginsOptionsParserKt.processCompilerPluginOptions(commandLineProcessor, list, configuration2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void processCompilerPluginOptions(@NotNull CommandLineProcessor processor, @NotNull List<CliOptionValue> pluginOptions, @NotNull CompilerConfiguration configuration2) {
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter(processor, "processor");
        Intrinsics.checkNotNullParameter(pluginOptions, "pluginOptions");
        Intrinsics.checkNotNullParameter(configuration2, "configuration");
        Iterable $this$associateBy$iv = processor.getPluginOptions();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv, 10)), 16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            AbstractCliOption abstractCliOption = (AbstractCliOption)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            map2.put(it.getOptionName(), element$iv$iv);
        }
        Map declaredOptions = destination$iv$iv;
        MultiMap<AbstractCliOption, CliOptionValue> optionsToValues = new MultiMap<AbstractCliOption, CliOptionValue>();
        for (CliOptionValue optionValue : pluginOptions) {
            AbstractCliOption option;
            if ((AbstractCliOption)declaredOptions.get(optionValue.getOptionName()) == null) {
                throw new CliOptionProcessingException("Unsupported plugin option: " + optionValue, null, 2, null);
            }
            optionsToValues.putValue(option, optionValue);
        }
        for (AbstractCliOption option : processor.getPluginOptions()) {
            Collection values2;
            Intrinsics.checkNotNullExpressionValue(optionsToValues.get(option), "get(...)");
            if (option.getRequired() && values2.isEmpty()) {
                throw new PluginCliOptionProcessingException(processor.getPluginId(), processor.getPluginOptions(), "Required plugin option not present: " + processor.getPluginId() + ':' + option.getOptionName(), null, 8, null);
            }
            if (!option.getAllowMultipleOccurrences() && values2.size() > 1) {
                throw new PluginCliOptionProcessingException(processor.getPluginId(), processor.getPluginOptions(), "Multiple values are not allowed for plugin option " + processor.getPluginId() + ':' + option.getOptionName(), null, 8, null);
            }
            for (CliOptionValue value2 : values2) {
                processor.processOption(option, value2.getValue(), configuration2);
            }
        }
    }
}

