/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.util.Collection;
import java.util.List;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;

public final class CodegenUtilKt {
    public static final boolean isJvmStaticInObjectOrClassOrInterface(@NotNull CallableDescriptor $this$isJvmStaticInObjectOrClassOrInterface) {
        Intrinsics.checkNotNullParameter($this$isJvmStaticInObjectOrClassOrInterface, "<this>");
        return CodegenUtilKt.isJvmStaticIn($this$isJvmStaticInObjectOrClassOrInterface, CodegenUtilKt::isJvmStaticInObjectOrClassOrInterface$lambda$4);
    }

    public static final boolean isJvmStaticInCompanionObject(@NotNull CallableDescriptor $this$isJvmStaticInCompanionObject) {
        Intrinsics.checkNotNullParameter($this$isJvmStaticInCompanionObject, "<this>");
        return CodegenUtilKt.isJvmStaticIn($this$isJvmStaticInCompanionObject, CodegenUtilKt::isJvmStaticInCompanionObject$lambda$5);
    }

    private static final boolean isJvmStaticIn(CallableDescriptor $this$isJvmStaticIn, Function1<? super DeclarationDescriptor, Boolean> predicate) {
        boolean bl;
        if ($this$isJvmStaticIn instanceof PropertyAccessorDescriptor) {
            PropertyDescriptor propertyDescriptor = ((PropertyAccessorDescriptor)$this$isJvmStaticIn).getCorrespondingProperty();
            Intrinsics.checkNotNullExpressionValue(propertyDescriptor, "getCorrespondingProperty(...)");
            PropertyDescriptor propertyDescriptor2 = propertyDescriptor;
            DeclarationDescriptor declarationDescriptor = propertyDescriptor2.getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "getContainingDeclaration(...)");
            bl = predicate.invoke(declarationDescriptor).booleanValue() && (AnnotationUtilKt.hasJvmStaticAnnotation($this$isJvmStaticIn) || AnnotationUtilKt.hasJvmStaticAnnotation(propertyDescriptor2));
        } else {
            DeclarationDescriptor declarationDescriptor = $this$isJvmStaticIn.getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "getContainingDeclaration(...)");
            bl = predicate.invoke(declarationDescriptor) != false && AnnotationUtilKt.hasJvmStaticAnnotation($this$isJvmStaticIn);
        }
        return bl;
    }

    public static final boolean isGenericToArray(@NotNull FunctionDescriptor $this$isGenericToArray) {
        Intrinsics.checkNotNullParameter($this$isGenericToArray, "<this>");
        if (!Intrinsics.areEqual($this$isGenericToArray.getName().asString(), "toArray")) {
            return false;
        }
        if ($this$isGenericToArray.getValueParameters().size() != 1 || $this$isGenericToArray.getTypeParameters().size() != 1) {
            return false;
        }
        KotlinType kotlinType = $this$isGenericToArray.getReturnType();
        if (kotlinType == null) {
            throw new AssertionError((Object)$this$isGenericToArray.toString());
        }
        KotlinType returnType = kotlinType;
        KotlinType kotlinType2 = $this$isGenericToArray.getValueParameters().get(0).getType();
        Intrinsics.checkNotNullExpressionValue(kotlinType2, "getType(...)");
        KotlinType paramType = kotlinType2;
        if (!KotlinBuiltIns.isArray(returnType) || !KotlinBuiltIns.isArray(paramType)) {
            return false;
        }
        SimpleType simpleType2 = $this$isGenericToArray.getTypeParameters().get(0).getDefaultType();
        Intrinsics.checkNotNullExpressionValue(simpleType2, "getDefaultType(...)");
        SimpleType elementType = simpleType2;
        return KotlinTypeChecker.DEFAULT.equalTypes(elementType, DescriptorUtilsKt.getBuiltIns($this$isGenericToArray).getArrayElementType(returnType)) && KotlinTypeChecker.DEFAULT.equalTypes(elementType, DescriptorUtilsKt.getBuiltIns($this$isGenericToArray).getArrayElementType(paramType));
    }

    public static final boolean isNonGenericToArray(@NotNull FunctionDescriptor $this$isNonGenericToArray) {
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter($this$isNonGenericToArray, "<this>");
                if (!Intrinsics.areEqual($this$isNonGenericToArray.getName().asString(), "toArray")) {
                    return false;
                }
                List<ValueParameterDescriptor> list = $this$isNonGenericToArray.getValueParameters();
                Intrinsics.checkNotNullExpressionValue(list, "getValueParameters(...)");
                if (!((Collection)list).isEmpty()) break block4;
                List<TypeParameterDescriptor> list2 = $this$isNonGenericToArray.getTypeParameters();
                Intrinsics.checkNotNullExpressionValue(list2, "getTypeParameters(...)");
                if (!(!((Collection)list2).isEmpty())) break block5;
            }
            return false;
        }
        KotlinType returnType = $this$isNonGenericToArray.getReturnType();
        return returnType != null && KotlinBuiltIns.isArray(returnType);
    }

    public static final boolean isToArrayFromCollection(@NotNull MemberDescriptor $this$isToArrayFromCollection) {
        Intrinsics.checkNotNullParameter($this$isToArrayFromCollection, "<this>");
        if (!($this$isToArrayFromCollection instanceof FunctionDescriptor)) {
            return false;
        }
        DeclarationDescriptor declarationDescriptor = ((FunctionDescriptor)$this$isToArrayFromCollection).getContainingDeclaration();
        ClassDescriptor classDescriptor = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
        if (classDescriptor == null) {
            return false;
        }
        ClassDescriptor containingClassDescriptor = classDescriptor;
        if (Intrinsics.areEqual(containingClassDescriptor.getSource(), SourceElement.NO_SOURCE)) {
            return false;
        }
        declarationDescriptor = DescriptorUtilsKt.getBuiltIns($this$isToArrayFromCollection).getCollection();
        Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "getCollection(...)");
        DeclarationDescriptor collectionClass = declarationDescriptor;
        if (!DescriptorUtils.isSubclass(containingClassDescriptor, (ClassDescriptor)collectionClass)) {
            return false;
        }
        return CodegenUtilKt.isGenericToArray((FunctionDescriptor)$this$isToArrayFromCollection) || CodegenUtilKt.isNonGenericToArray((FunctionDescriptor)$this$isToArrayFromCollection);
    }

    private static final boolean isJvmStaticInObjectOrClassOrInterface$lambda$4(DeclarationDescriptor it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return DescriptorUtils.isNonCompanionObject(it) || DescriptorUtils.isClassOrEnumClass(it) || JvmCodegenUtil.isJvmInterface(it);
    }

    private static final boolean isJvmStaticInCompanionObject$lambda$5(DeclarationDescriptor it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return DescriptorUtils.isCompanionObject(it);
    }
}

